/* 
  Copyright (c) 1998 Further Consulting
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/prefs.cpp,v 1.1.1.1 1999/02/25 15:28:10 jonny Exp $

*/

#include <qframe.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <kapp.h>
#include <ktopwidget.h>
#include <kwm.h>
#include <kconfig.h>
#include <kiconloader.h>
#include <kspinbox.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include "khylafax.h"
#include "prefs.h"


KHylaFaxPrefs::KHylaFaxPrefs(KConfig *conf) {

  config = conf;
  config->setGroup("Personal Information");
  QFrame *perInfo = new QFrame(this);
  
  int gridrowmax = 5;
  int gridcolmax = 4;
  int gridrow = 0;
  int gridcol = 0;
  
  QGridLayout *senderGrid = new QGridLayout(perInfo, gridrowmax, gridcolmax, 10);

  QLabel *nameLab = new QLabel(perInfo);
  nameLab->setText(klocale->translate("Name"));
  senderGrid->addWidget(nameLab,gridrow, gridcol++);

  name = new QLineEdit(perInfo);
  name->setText(config->readEntry("Name"));
  senderGrid->addMultiCellWidget(name, gridrow, gridrow, gridcol++, gridcolmax -1);
  
  gridrow++;
  gridcol = 0;

  QLabel *companyLab = new QLabel(perInfo);
  companyLab->setText(klocale->translate("Company"));
  senderGrid->addWidget(companyLab, gridrow, gridcol++);

  company = new QLineEdit(perInfo);
  company->setText(config->readEntry("Company"));
  senderGrid->addMultiCellWidget(company, gridrow, gridrow, gridcol++, gridcolmax -1);

  gridrow++;
  gridcol = 0;

  QLabel *locationLab = new QLabel(perInfo);
  locationLab->setText(klocale->translate("Location"));
  senderGrid->addWidget(locationLab, gridrow, gridcol++);

  location = new QLineEdit(perInfo);
  location->setText(config->readEntry("Location"));
  senderGrid->addMultiCellWidget(location, gridrow, gridrow, gridcol++, gridcolmax -1);

  gridrow++;
  gridcol = 0;

  QLabel *voiceLab = new QLabel(perInfo);
  voiceLab->setText(klocale->translate("Voice Phone"));
  senderGrid->addWidget(voiceLab, gridrow, gridcol++);

  voice = new QLineEdit(perInfo);
  voice->setText(config->readEntry("Voice Phone"));
  senderGrid->addWidget(voice, gridrow, gridcol++);

  QLabel *faxNumLab = new QLabel(perInfo);
  faxNumLab->setText(klocale->translate("Fax Number"));
  senderGrid->addWidget(faxNumLab, gridrow, gridcol++);

  faxNum = new QLineEdit(perInfo);
  faxNum->setText(config->readEntry("Fax Number"));
  senderGrid->addWidget(faxNum, gridrow, gridcol++);

  int tmpgridrow;
  for(tmpgridrow = 0; tmpgridrow <= gridrow; tmpgridrow++) {
    senderGrid->addRowSpacing(tmpgridrow,nameLab->sizeHint().height()+7);
    senderGrid->setRowStretch(tmpgridrow,0);
  }

  senderGrid->addColSpacing(0,voiceLab->sizeHint().width());
  senderGrid->setColStretch(0,0);
  senderGrid->setColStretch(1,20);
  senderGrid->addColSpacing(2,faxNumLab->sizeHint().width());
  senderGrid->setColStretch(2,0);
  senderGrid->setColStretch(3,20);

  config->setGroup("Transmission Preferences");

  gridrowmax = 4;
  gridcolmax = 4;
  gridrow = 0;
  gridcol = 0;

  QFrame *transInfo = new QFrame(this);
  QGridLayout *transGrid = new QGridLayout(transInfo, gridrowmax, gridcolmax, 10);
  
  QLabel *hostLab = new QLabel(transInfo);
  hostLab->setText(klocale->translate("Fax Server Hostname"));
  transGrid->addWidget(hostLab, gridrow, gridcol++);

  host = new QLineEdit(transInfo);
  host->setText(config->readEntry("Hostname"));
  transGrid->addMultiCellWidget(host, gridrow, gridrow, gridcol++, gridcolmax-1);

  gridrow++;
  gridcol = 0;

  QLabel *userLab = new QLabel(transInfo);
  userLab->setText(klocale->translate("Fax Server Username"));
  transGrid->addWidget(userLab, gridrow, gridcol++);

  user = new QLineEdit(transInfo);
  user->setText(config->readEntry("Username"));
  transGrid->addMultiCellWidget(user, gridrow, gridrow, gridcol++, gridcolmax-1);

  gridrow++;
  gridcol = 0;

  QLabel *retryLab = new QLabel(transInfo);
  retryLab->setText(klocale->translate("Maximum Retries"));
  transGrid->addWidget(retryLab, gridrow, gridcol++);
  
  retry = new KNumericSpinBox(transInfo);
  retry->setValue(config->readNumEntry("Maximum Retries"));
  retry->setRange(0,20);
  transGrid->addWidget(retry, gridrow, gridcol++);
  
  coverPage = new QCheckBox(transInfo);
  coverPage->setChecked(config->readBoolEntry("Send Coverpage"));
  coverPage->setText(klocale->translate("Send Coverpage"));
  transGrid->addWidget(coverPage, gridrow, gridcolmax-1);
  
  for(tmpgridrow = 0; tmpgridrow <= gridrow; tmpgridrow++) {
    transGrid->addRowSpacing(tmpgridrow,hostLab->sizeHint().height() +7);
    transGrid->setRowStretch(tmpgridrow,0);
  }

  gridrow++;
  gridcol=0;

  QButtonGroup *dpig = new QButtonGroup(transInfo);
  QBoxLayout *dpiBox = new QVBoxLayout(dpig, 5);
  dpiBox->addSpacing(10);
  dpi98 = new QRadioButton("98",dpig);
  dpi98->setText("98");
  dpiBox->addWidget(dpi98);
  dpi196 = new QRadioButton("196",dpig);
  dpi196->setText("196");
  dpiBox->addWidget(dpi196);

  if(config->readNumEntry("Dpi") == 98)
    dpi98->setChecked(true);
  else
    dpi196->setChecked(true);
  
  dpig->insert(dpi98);
  dpig->insert(dpi196);
  dpig->setTitle(klocale->translate("Lines Per Inch"));
  dpig->resize(dpig->sizeHint());
  transGrid->addMultiCellWidget(dpig, gridrow, gridrow, gridcol, gridcol+1);
  gridcol = gridcol+2;

  QButtonGroup *notifyg = new QButtonGroup(transInfo);
  QBoxLayout *notifyBox = new QVBoxLayout(notifyg, 5);
  notifyBox->addSpacing(10);
  notifyRetry = new QCheckBox(notifyg);
  notifyRetry->setText(klocale->translate("Notify on Retry"));
  notifyBox->addWidget(notifyRetry);
  notifyDone = new QCheckBox(notifyg);
  notifyDone->setText(klocale->translate("Notify when Done"));
  notifyBox->addWidget(notifyDone);
  
  notifyRetry->setChecked(config->readBoolEntry("Notify on Retry"));
  notifyDone->setChecked(config->readBoolEntry("Notify when Done"));

  notifyg->insert(notifyRetry);
  notifyg->insert(notifyDone);
  notifyg->setTitle(klocale->translate("Email Notification"));
  notifyg->resize(notifyg->sizeHint());
  transGrid->addMultiCellWidget(notifyg, gridrow, gridrow, gridcol, gridcol+1);
  gridcol = gridcol+2;

  transGrid->setRowStretch(gridrow,100);
  
  transGrid->addColSpacing(0, hostLab->sizeHint().width());
  transGrid->setColStretch(0,0);
  transGrid->setColStretch(1,0);
  transGrid->addColSpacing(1,40);
  transGrid->setColStretch(2,10);
  //  transGrid->addColSpacing(2,notifyDone->sizeHint().width() - 60);
  transGrid->setColStretch(3,10);
  transGrid->addColSpacing(3,coverPage->sizeHint().width());

  /* MISC Settings */

  config->setGroup("Misc Preferences");

  gridrowmax = 4;
  gridcolmax = 4;
  gridrow = 0;
  gridcol = 0;

  QFrame *miscInfo = new QFrame(this);
  QGridLayout *miscGrid = new QGridLayout(miscInfo, gridrowmax, gridcolmax, 10);

  QLabel *checklab = new QLabel(miscInfo);
  checklab->setText(klocale->translate("Enable autocheck"));
  miscGrid->addWidget(checklab, gridrow, gridcol++);

  autocheck = new QCheckBox(miscInfo);
  autocheck->setChecked(config->readBoolEntry("Autocheck"));
  miscGrid->addWidget(autocheck, gridrow++, gridcol);

  gridcol = 0;

  QLabel *autolab = new QLabel(miscInfo);
  autolab->setText(klocale->translate("Autocheck interval"));
  miscGrid->addWidget(autolab, gridrow, gridcol++);

  autocheckinterval = new KNumericSpinBox(miscInfo);
  autocheckinterval->setValue(config->readNumEntry("Autocheckinterval"));
  autocheckinterval->setRange(1,60);
  miscGrid->addWidget(autocheckinterval, gridrow++, gridcol);

  gridcol = 0;

  QLabel *docklab = new QLabel(miscInfo);
  docklab->setText(klocale->translate("Dock to taskbar"));
  miscGrid->addWidget(docklab, gridrow, gridcol++);

  dock = new QCheckBox(miscInfo);
  dock->setChecked(config->readBoolEntry("Dock"));
  miscGrid->addWidget(dock, gridrow++, gridcol);

  /* Now add the tabs to the dialog */

  addTab(perInfo,"Personal Information");
  addTab(transInfo, "Fax Transmission Information");
  addTab(miscInfo, "Miscellaneous Settings");
  setOkButton(klocale->translate("Save"));
  setCancelButton(klocale->translate("Cancel"));
  setCaption(klocale->translate("KHylaFax Preferences"));
  
  connect(this, SIGNAL(applyButtonPressed()), SLOT(savePrefs()));

  resize(400,250);
  setMinimumSize(400,250);
  show();
}

KHylaFaxPrefs::~KHylaFaxPrefs() {

}

void KHylaFaxPrefs::savePrefs() {

  config->setGroup("Personal Information");
  config->writeEntry("Name", name->text());
  config->writeEntry("Company", company->text());
  config->writeEntry("Location", location->text());
  config->writeEntry("Voice Phone", voice->text());
  config->writeEntry("Fax Number", faxNum->text());

  config->setGroup("Transmission Preferences");
  config->writeEntry("Hostname", host->text());
  config->writeEntry("Username", user->text());
  config->writeEntry("Maximum Retries", retry->getValue());
  config->writeEntry("Send Coverpage", coverPage->isChecked());
  if(dpi98->isChecked())
    config->writeEntry("Dpi", 98);
  else
    config->writeEntry("Dpi", 196);
  config->writeEntry("Notify on Retry", notifyRetry->isChecked());
  config->writeEntry("Notify when Done", notifyDone->isChecked());

  config->setGroup("Misc Preferences");
  config->writeEntry("Dock", dock->isChecked());
  config->writeEntry("Autocheck", autocheck->isChecked());
  config->writeEntry("Autocheckinterval", autocheckinterval->getValue());

  config->sync();

  // Make a ~/.faxdb file to hold user prefs. sendfax and faxcover
  // from the HylaFax rely on this file for certain cover page information
}


#include "prefs.moc"

/*

$Log: prefs.cpp,v $
Revision 1.1.1.1  1999/02/25 15:28:10  jonny


Revision 0.2  1998/07/21 12:57:55  jlublin
had a coverpage variable named wrong so saving the pref was not working
correctly

Revision 0.1.1.1  1998/06/11 17:52:41  jlublin
Initial Rev

Revision 0.2  1998/06/11 17:47:37  jlublin
Added support for saving and restoring preferences

Revision 0.1.1.1  1998/06/03 00:06:48  jlublin
Initial Rev


*/

