/* 
  Copyright (c) 1999 js <jonny@dillingen.baynet.de>
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/netcom.cpp,v 1.3 1999/03/06 18:01:52 jonny Exp $

*/

#include <qlist.h>
#include <ksock.h>
#include <qstring.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <iostream.h>
#include <qbuffer.h>
#include "netcom.h"


// Class KExtSocket

KExtSocket::KExtSocket(const char *_host, int _port) :
  KSocket(_host, _port)
{
  // set socket to non-blocking mode
  fcntl(socket(), F_SETFL, (fcntl(socket(), F_GETFL) & !O_NDELAY));  
}


QString KExtSocket::readLine()
{
  QString response;
  char buffer;

  while((::read(socket(), &buffer, 1) > 0) && (buffer != '\n'))
    response += buffer;

  //cout << "KExtSocket::readline: got reply: " << response << endl;

  return response;
}


void KExtSocket::writeLine(const QString &str)
{
  QString tmp = str;

//  cout << "NetCom::writeString: " << str << "; length " << str.length() << endl;
  
  // always send new-line
  if(tmp.right(1) != "\n")
    tmp.append("\n");
  
  ::write(socket(), (const char*)tmp, tmp.length());
}



// Class NetCom

NetCom::NetCom(const char *_host, int _port)
{
  sock = new KExtSocket(_host, _port);
  
  // get hello message from fax-server
  sock->readLine();
}


NetCom::~NetCom()
{
  delete sock;
}

KExtSocket *NetCom::openPassiveConnection()
{
  QString hostname;
  int port;

  // tell server to use passive mode
  sock->writeLine("PASV");

  // read line with info for ports
  parsePassiveReply(sock->readLine(), hostname, port);

  // open data connection
  return new KExtSocket(hostname, port);
}

QString *NetCom::makePORT(int iaddr[], int port)
{
  QString *str;

  int a = port & 0xFF;
  int b = (port & 0xFF00) >> 8;

  str = new QString;
  str->sprintf("%d, %d, %d, %d, %d, %d",
	      iaddr[0] & 0xff,
	      iaddr[1] & 0xff,
	      iaddr[2] & 0xff,
	      iaddr[3] & 0xff,
	      b & 0xff,
	      a & 0xff
  );

  return str;
}

/*
QByteArray *NetCom::getInetAddr()
{
  QByteArray *addr;
  unsigned long a;

  addr = new QByteArray(4);

  if(host->upper() == "LOCALHOST") {
    addr[0] = 127;
    addr[1] = addr[2] = 0;
    addr[3] = 1;
  }
  else {
    a = sock->getAddr();
    addr[0] = (a >> 24) & 0xff;
    addr[1] = (a >> 16) & 0xff;
    addr[2] = (a >>  8) & 0xff;
    addr[3] = a & 0xff;
  }

  return addr;
}
*/

int NetCom::check(const QString &str)
{
  char delim;
  int pos1;

  if(str.isEmpty())
    return -1;

  if(str[3] == '-') {
    delim = '-';
  }
  else {
    delim = ' ';
  }

  pos1 = str.find(delim, 0);
  return str.left(pos1).toInt();
}


int NetCom::login(const char *uname)
{
  QString cmd = "USER " + QString(uname);
  sock->writeLine(cmd);
  return check(sock->readLine());
}

QBuffer *NetCom::getFile(const char *dir, const char *name)
{
	QBuffer *buffer = new QBuffer();
	KExtSocket *dsock;
	int readlen;
	char buf[1024];

	buffer->open(IO_ReadWrite);

	// change directory
	sock->writeLine("CWD " + QString(dir));
	sock->readLine();

	sock->writeLine("TYPE I");
	sock->readLine();

	sock->writeLine("MODE S");
	sock->readLine();

	// open data connection
	dsock = openPassiveConnection();

	// retrieve file
	sock->writeLine("RETR " + QString(name));

	while((readlen = read(dsock->socket(), buf, sizeof(buf)))) {
		buffer->writeBlock(buf, readlen);
	}

	// read answers from server
	sock->readLine();
	sock->readLine();

	// cd to faxserver root
	sock->writeLine("CWD ..");
	sock->readLine();

	// close data connection
	delete dsock;
	
	return buffer;
}

QString NetCom::sendBuffer(QBuffer *buffer)
{
	int numread;
	char buf[1024];
	KExtSocket *dsock;
	
	sock->writeLine("TYPE I");
	sock->readLine();
	sock->writeLine("MODE S");
	sock->readLine();
	
	dsock = openPassiveConnection();
	
	sock->writeLine("STOT");
	
	while((numread = buffer->readBlock(buf, 1024)) > 0)
	{
		write(dsock->socket(), buf, numread);
	}

	QString answer = sock->readLine();
	
	cout << "answer: " << answer << endl;	
		
	delete dsock;
	
	int pos = answer.find("/");
	int pos2 = answer.find(" ", pos);
	
	cout << "pos: " << pos << "; pos2: " << pos2 << endl;
	
	QString jobname = answer.mid(pos, pos2-pos);
	
	cout << "JOBNAME: " << jobname << endl;
	
	cout << "reading again... " << sock->readLine() << endl;
	
	return jobname;
}

int NetCom::getFileCount(const char *dir)
{
	QList<QString> list = readDir(dir);
	list.setAutoDelete(true);
	return list.count();
}

QList<QString> NetCom::readDir(const char *dir)
{
  // socket for data-connection
  KExtSocket *dsock;
  QString line;
  QList<QString> list;

  // change directory
  sock->writeLine("CWD " + QString(dir));
  sock->readLine();

  // open data connection
  dsock = openPassiveConnection();

  // specify rcvfmt; IMPORTANT: same separator as with KTabListBox
  // get at least one space, because of the ktablistbox
  sock->writeLine("RCVFMT \"%p |%s |%1a |%t |%f\"");
  sock->readLine();

  // list directory
  sock->writeLine("LIST");

  while(line = dsock->readLine()) {
    if(!line.isNull()) {
      list.append(new QString(line));
    }
  }

  // read answers from server
  sock->readLine();
  sock->readLine();

  sock->writeLine("CWD ..");
  sock->readLine();

  // close data connection
  delete dsock;

  return list;
}

QString NetCom::command(const char *cmd)
{
	sock->writeLine(cmd);
	return sock->readLine();
}

void NetCom::parsePassiveReply(const QString &reply, QString &hostname, int &port)
{
  QString portLine = reply;
  int ip1,ip2,ip3,ip4,port1,port2;

  // remove "Entering passive mode ("
  portLine = portLine.remove(0, portLine.find('(')+1);

  // get integers from server reply; hostname is always an ip adress
  sscanf(portLine, "%d,%d,%d,%d,%d,%d", &ip1, &ip2, &ip3, &ip4, &port1, &port2);

  // construct hostname & port
  hostname.sprintf("%d.%d.%d.%d", ip1, ip2, ip3, ip4);
  port = (port1 << 8) + port2;
}


/*

$Log: netcom.cpp,v $
Revision 1.3  1999/03/06 18:01:52  jonny

You can view the receive queue and load received faxes over the network
and display it using a local shell script.

Revision 1.2  1999/02/26 17:43:15  jonny

Second version of networking; now we can connect to a server and retrieve
the receive queue and show it using a KTabListBox.

Revision 1.1  1999/02/26 15:45:01  jonny
First version of network support working. Client can log into server :-)

*/


