/***************************************************************************
                          khylainfo.h  -  description                              
                             -------------------                                         
    begin                : Thu Mar 25 1999                                           
    copyright            : (C) 1999 by Jonas Sextl                         
    email                : jonny@dillingen.baynet.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHYLAINFO_H
#define KHYLAINFO_H

#include <qwidget.h>
#include <qpainter.h>
#include <kconfig.h>
#include <qtimer.h>
#include <kpopmenu.h>

#include "khylafax.h"
#include "netcom.h"

/**
  *@author Jonas Sextl
  */

class KHylaInfo : public QWidget  {
   Q_OBJECT
public: 
	KHylaInfo(QWidget *parent=0, const char *name=0, WFlags f=0);
	~KHylaInfo();

protected:
	virtual void paintEvent( QPaintEvent *);
	virtual void mouseDoubleClickEvent (QMouseEvent *);
	virtual void timerEvent(QTimerEvent *);
	virtual void mouseReleaseEvent (QMouseEvent *);
	
private:
	KHylaFax *khf;
	NetCom *netcom;
	KConfig *conf;
	int tid;
	unsigned timer_interval;
	int faxcount;
	bool newfaxpending;
	KPopupMenu *menu;
	
public slots:
	void open();
	void quit();
	void status();
	void prefs();
};

#endif






























