/***************************************************************************
                          inputs.cpp  -  description                              
                             -------------------                                         

    version              :                                   
    begin                : Sat Feb 6 1999                                           
    copyright            : (C) 1999 by Didier Gaudin                         
    email                : gaudin@club-internet?fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <kapp.h>
#include <klocale.h>

#include "inputs.h"
#include <qlabel.h>
#include <qpixmap.h>
#include <qframe.h>
#include <kconfig.h>
#include <kiconloader.h>

#define MAX_MOUSE 5

MOUSE Mouse[MAX_MOUSE]={{"Microsoft Mouse(serial)","Microsoft"},
                       { "PS/2 Mouse","PS/2"},
                       { "Bus Mouse Logitech", "Logitech"},
                       { "Intelimouse","IntelliMouse"},
                       { "None" ,"None"} };


Inputs::Inputs(QWidget *parent, const char *name) : QWidget(parent, name)
{
  KIconLoader IL;
  KConfig * fichier = new KConfig(NULL,"xfreeconfig");
  fichier->setGroup("Keyboard");

  QLabel * KPixmap = new QLabel(this);
  KPixmap -> setPixmap(IL.loadIcon("keyboard.xpm"));
  KPixmap -> setGeometry(20,20,60,40);
  QLabel * LKey = new QLabel (this);
  LKey -> setText(klocale->translate("Keyboard"));
  LKey-> setFont( QFont( "lucidatypewriter", 16, 75, 0));
  LKey -> setGeometry(70,30,90,20);

  QLabel * LabelLayout = new QLabel(this);
  LabelLayout -> setText (klocale->translate("Layout"));
  LabelLayout -> setGeometry(70,90,100,20);
  QLabel * LabelKey = new QLabel (this);
  LabelKey -> setText(klocale->translate("Model"));
  LabelKey -> setGeometry(70,120,100,20);

  ComboLayout =  new QComboBox ( this );
  ComboLayout -> setGeometry(180,90,170,20);
  ComboLayout -> insertItem("fr");
  ComboLayout -> insertItem("en");
  ComboLayout -> insertItem("de");
  ComboLayout -> setCurrentItem(fichier->readNumEntry("idXkbLayout",0));

  ComboKey = new QComboBox(this);
  ComboKey -> insertItem("Clavier 105 Touches");
  ComboKey -> insertItem("Clavier 102 Touches");
  ComboKey -> insertItem("Clavier 101 Touches");
  ComboKey -> setGeometry(180,120,170,20);
  ComboKey -> setCurrentItem(fichier->readNumEntry("idXkbModel",0) );

  QFrame * Separator = new QFrame (this);
  Separator ->setGeometry( -4, 175, 453, 9 );
  Separator ->setLineWidth( 1 );
  Separator ->setFrameStyle( QFrame::HLine | QFrame::Raised );

fichier -> setGroup("Mouse");

  QLabel * MPixmap = new QLabel(this);
  MPixmap -> setPixmap(IL.loadIcon("mouse.xpm"));
  MPixmap -> setGeometry(20,190,40,40);

  QLabel * LMouse = new QLabel (this);
  LMouse -> setText(klocale->translate("Mouse"));
  LMouse -> setGeometry(70,200,70,20);
  LMouse -> setFont( QFont( "lucidatypewriter", 16, 75, 0));

  QLabel * MouseType = new QLabel(this);
  MouseType -> setText(klocale->translate("Mouse Model"));
  MouseType -> setGeometry(70,260,100,20);

  ComboMouse =  new QComboBox ( this );
  ComboMouse ->setGeometry(180,260,170,20);
  for (int n=0; n<MAX_MOUSE; n++)
    ComboMouse -> insertItem(Mouse[n].text);
  ComboMouse-> setCurrentItem(fichier-> readNumEntry("idProtocol",0));

  QLabel * MouseDev = new QLabel(this);
  MouseDev -> setText(klocale->translate("Device"));
  MouseDev -> setGeometry(70,290,100,20);
  ComboDev = new QComboBox( this);
  ComboDev -> setGeometry(180,290,170,20);
  ComboDev -> insertItem("/dev/mouse");
  ComboDev -> insertItem("/dev/ttyS0");
  ComboDev -> insertItem("/dev/ttyS1");
  ComboDev -> insertItem("/dev/ttyS2");
  ComboDev -> insertItem("/dev/ttyS3");
  ComboDev -> insertItem("/dev/psaux");
  ComboDev -> setCurrentItem(fichier->readNumEntry("idDevice",0));

  ChkEmul3 = new QCheckBox (klocale->translate("Emmulate 3 Buttons"),this);
  ChkEmul3 -> setGeometry(70,320,135,20);
  if (fichier -> readBoolEntry("Emulate3Buttons"))
      ChkEmul3->setChecked( TRUE );
  connect (ChkEmul3, SIGNAL(toggled (bool)),SLOT(slotemulActive(bool)));


  TimeOut = new QLabel(this);
  TimeOut -> setText(klocale->translate("Timeout"));
  TimeOut -> setGeometry(210,320,50,20);
  TimeOut -> setEnabled(ChkEmul3->isChecked() ? TRUE : FALSE);

  TimeOutVal = new QSpinBox(this);
  TimeOutVal -> setValue( fichier->readNumEntry("Emulate3Timeout",50 ));
  TimeOutVal -> setGeometry(260,320,50,20);
  TimeOutVal -> setEnabled(ChkEmul3->isChecked() ? TRUE : FALSE);

   delete fichier;

}


Inputs::~Inputs(){
}


void Inputs::slotemulActive(bool valeur)
{
  TimeOut    -> setEnabled(valeur ? TRUE : FALSE);
  TimeOutVal -> setEnabled(valeur ? TRUE : FALSE);
}

void Inputs::writeconfig()
{
   KConfig * fichier = new KConfig(NULL,"xfreeconfig");
   fichier->setGroup("Keyboard");
   fichier->writeEntry("XkbLayout",ComboLayout->text(ComboLayout ->currentItem()) );
   fichier->writeEntry("idXkbLayout",ComboLayout ->currentItem());
   fichier->writeEntry("XkbModel",ComboKey->text(ComboKey-> currentItem()));
   fichier->writeEntry("idXkbModel",ComboKey-> currentItem());

   fichier->setGroup("Mouse");
   fichier->writeEntry("Protocol",Mouse[ComboMouse->currentItem()].protocol);
   fichier->writeEntry("idProtocol",ComboMouse->currentItem());
   fichier->writeEntry("Device",ComboDev->text(ComboDev->currentItem()));
   fichier->writeEntry("idDevice",ComboDev->currentItem());
   fichier->writeEntry("Emulate3Buttons",ChkEmul3->isChecked());
   fichier->writeEntry("Emulate3Timeout",TimeOutVal->text());
   fichier->sync();
   delete fichier;
}










