/***************************************************************************
    kuninstallerview.h  -   Header file of class KUninstallerView
    ------------------------------------------------------------------------
    begin                : Wed Mar 10 08:47:08 MET 1999
                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KUNINSTALLERVIEW_H 
#define KUNINSTALLERVIEW_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qwidget.h>
#include <qdir.h>
#include <qcombo.h>
#include <qstring.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qgroupbox.h>
#include <qlineedit.h>
#include <qstrlist.h>

#include <kapp.h>
#include <knewpanner.h>

#include "kuninstalllistview.h"
#include "kappldialog.h"
#include "resource.h"

class KUninstallerApp;

/**
  * This class provides the application view. It shows an application area with a LineEdit
  * for enter the application name, a backup area if the backup feature is enabled and
  * a ListView for displaying the results of the searching.
  * @author Geri House
  */
class KUninstallerView : public QWidget
{
  Q_OBJECT

 public:
  /** Constructor for the main view */
  KUninstallerView(KApplication* a=0, KUninstallerApp *parent = 0);
  /** Destructor for the main view */
  ~KUninstallerView();
  /** Search for the application parts */
  bool search();
  /** Remove found application parts */
  bool remove();
  /** Delete the list entries */
  void wipeOff();
  /** Undos the last removing action */
  void undo();
  /** Stop searching */
  void stop();
  /** Save the view-specific options */
  void saveOptions(KConfig * config);
  /** Read the app-specific options */
  void readOptions(KConfig * config);
  /** Convert the list entries into a printable layout*/
  QStrList *getTextForPrinting();
  /** Overloaded  for change resize*/
  void resizeEvent ( QResizeEvent * );
  /** Converts a float size from float into Ascii representation*/
  QString size2Ascii(float );
  /** If Backup feature is enabled the Backbox will be shown and updated*/
  void showBackupBox();
  /** Remove all application backups*/
  void removeAllBackups();
  /** This method informs if the backup feature is enabled*/
  bool isSaveUninstalling() { return  saveUninstalling; }

 public slots:
  /** Sets the number of selected application items*/
  void setNumberLabel(int );
  /** Sets the size of selected application items*/
  void setSizeLabel(float );

 private slots:
  void updateLabels(KUninstallListItem *);
  void openApplDialog();
  void deleteSelectedBackup();
  void installSelectedBackup();
  void setView(QStrList);

 private:
  int find(QString, bool isRecursive=FALSE, bool completeName=FALSE );
  void setItemLabels(KUninstallListItem *, bool =FALSE);
  bool removeRecursive(KUninstallListItem *, const char* =0);
  void insertItem(QFileInfo f);
  bool removeRecursiveBackup(QString );
  void createTree();
  void removeTree();
  bool move_a_file (QString ,QString );
  int numberOfBackups();

  KUninstallerApp *parentApp;
  QString findPattern;
  KUninstallListView* searchListBox;
  KUnInstallItemList targetLocaleList;
  KUnInstallItemList targetInstallList;
  KUnInstallItemList targetAddList;

  QLineEdit* applicationCombo;
  QComboBox *backupCombo;
  QLabel * numLabel, *sizeLabel;
  QLabel* label_2;
  KNewPanner *panner;
  bool stopped;
  int numberItems;
  float sumSize;
  KApplDialog *dialog;
  QPushButton * applBtn;
  QPushButton *deleteBtn;
  QPushButton *installBtn;
  QGroupBox *group2;
  QString strApplDir;
  QStrList appList;
  int searchingCounter;

  static bool saveUninstalling;
  static QString savePath;
  static int numberBackups;
  static QString addSearchPath;
};

#endif // KUNINSTALLERVIEW_H 




































































































































