/***************************************************************************
    kuninstaller.h  -  Header file of class KUninstallerApp
    ------------------------------------------------------------------------
    begin                : Wed Mar 10 08:47:08 MET 1999
                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KUNINSTALLER_H
#define KUNINSTALLER_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>

// application specific includes
#include "kuninstallerview.h"
#include "resource.h"

class  KUninstallerView;

/**
  * This Class is the base class for the application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class KUninstallerView is
  * created which creates the view.
  * @author Geri House
  */
class KUninstallerApp : public KTMainWindow 
{
  Q_OBJECT

public:
  /** construtor */
  KUninstallerApp(); 
  /** destructor */
  ~KUninstallerApp();
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  void initView();
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  /** overloaded for Message box on last window exit */
  bool queryExit();
  /** overloaded  for change resize*/
  void resizeEvent( QResizeEvent *e);

 public slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** open a new application window */
  void slotFileNewWindow();
  /** print the actual file */
  void slotFilePrint();
  /** close the current window */
  void slotFileCloseWindow();
  /** exits the application */
  void slotFileQuit();
  /** toggle the toolbar*/
  void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);
  
  /** Starts the Searching for appication parts */
  void slotSearch();
  /** Removes the selected appication parts */
  void slotRemove();
  /** Refreshes the View for new searching */
  void slotNew();
  /** Stops the Searching*/
  void slotStop();
  /** Undos the last deleting action if the backup feature is enabled*/
  void slotUndo();
  /** Configuration of the application*/
  void slotConfigure();
  /** Deleting all application backups*/
  void slotBackup();

private:
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** edit_menu contains all items of the menubar entry "Edit" */
  QPopupMenu *edit_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  KUninstallerView *view;
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */
  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition tool_bar_pos;
};
 
#endif // KUNINSTALLER_H
 
 
 
 
 
 
 
 












































































