/***************************************************************************
    kappldialog.cpp  -  Source file of class KApplDialog
    					This is the Dialog for all applications found in the
    					KDE directories
    -----------------------------------------------------------------------
    begin                : Thu Mar 18 1999                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qdir.h>
#include <qfileinfo.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qcursor.h>
#include <qlabel.h>
#include <qtooltip.h>
#include <qheader.h>
#include <qfiledialog.h>

#include <kapp.h>
#include <kmsgbox.h>
#include <kiconloader.h>
#include <ksimpleconfig.h>
#include <klocale.h>

#include "kappldialog.h"
#include "kappldialogitem.h"

KApplDialog::KApplDialog(QWidget * parent, const char * name, bool modal)
:QDialog(parent,name,modal) {
  	KConfig *config = kapp->getConfig();
  	config->setGroup("APPLDIALOG");
  	QSize size=config->readSizeEntry("Size");
  	if (size.isEmpty()==TRUE)
			resize(450,400);
	else
		resize(size);	
	QLabel *label1 = new QLabel(this, "Label");
	label1->setGeometry(10,10,200,25);
	label1->setText(i18n("KDE Application List:"));
	
	listBox = new KApplListBox(this, "listBox");
    listBox->addColumn( i18n("Name") );
    listBox->setColumnWidth(0,100);
    listBox->addColumn( i18n("Comment") );
    listBox->setColumnWidthMode(1,QListView::Maximum);
    listBox->header()->hide();
    listBox->setMultiSelection(TRUE);

    QToolTip::add(listBox, i18n("Select the KDE Applications you wan't to remove"));
		
	backBtn = new QPushButton(this, "back");
    backBtn->setPixmap(kapp->getIconLoader()->loadIcon("back.xpm"));
    QToolTip::add(backBtn, i18n("Go back to Application"));
    backBtn->setEnabled(FALSE);

	forwardBtn = new QPushButton(this, "forward");
    forwardBtn->setPixmap(kapp->getIconLoader()->loadIcon("forward.xpm"));
    QToolTip::add(forwardBtn, i18n("Not found in the List ?"));

    connect(backBtn,SIGNAL(clicked()), this, SLOT(closeWithSelection()));
    connect(forwardBtn,SIGNAL(clicked()), this, SLOT(openFileDialog()));
    connect(listBox,SIGNAL(doubleClicked ( QListViewItem *)), this, SLOT(doubleClickEvent(QListViewItem *)));
}

KApplDialog::~KApplDialog(){
}

void KApplDialog::doubleClickEvent(QListViewItem *item) {
	QCheckListItem *checkItem = (QCheckListItem*)item;
	if (checkItem!=0)
		if (checkItem->parent()!=0) {
			if (checkItem->type()!= QCheckListItem::Controller)
				closeWithSelection();
		}
}

void KApplDialog::closeWithSelection() {
	KAppList appList = listBox->getAppList();
	if (appList.isEmpty()==FALSE) {
		KApplDialogItem *diaItem= appList.first();
		QStrList newStrList;
		while (diaItem!=0) {
			QFileInfo f=diaItem->getFileInfo();
			KSimpleConfig kconfig(f.absFilePath(), true);					
	  		kconfig.setGroup("KDE Desktop Entry");
			QString str= diaItem->text(0);
			str.remove(0,1); //remove trailing blank
	  		QString name=kconfig.readEntry("Exec",str);
	  		QString newStr=name.left(name.find(' '));
	  		newStrList.append(newStr);
	  		diaItem=appList.next();
	  	}	
	  	emit setApplName(newStrList);
  		
  		KConfig *config = kapp->getConfig();
   		config->setGroup("APPLDIALOG");
  		config->writeEntry("Size",size());
	
	  	accept();
	}
	else
		reject();
}

void KApplDialog::insertApplications() {
	backBtn->setEnabled(FALSE);
	listBox->clear();
	listBox->clearAppList();
	// the user applications
	QString dirStr=kapp->localkdedir();
  	dirStr+="/share/applnk";
	insertApplications(dirStr, 0);
	// the root Applications
	dirStr=kapp->kde_appsdir();
	insertApplications(dirStr, 0);
  	backBtn->setEnabled(TRUE);
}

void KApplDialog::insertApplications(QString dirStr, QListViewItem *parentItem) {
	qApp->processEvents();	// for processing pending events
	QDir dir(dirStr);
	QCheckListItem  * newMenue=0;
	if (dir.exists()) {
		if (dir.count()>2) {
			dirStr+="/";
			dirStr+=".directory";
	  		KSimpleConfig kconfig(dirStr, true);					
	  		kconfig.setGroup("KDE Desktop Entry");
	  		QString name=kconfig.readEntry("Name");
	  		if (name.isEmpty()==TRUE)
	  			name=dir.dirName();
			if (parentItem!=0)
				newMenue= new QCheckListItem((QCheckListItem*)parentItem,name);
			else
				newMenue= new QCheckListItem(listBox,name);
			if (newMenue->depth()>2)
				newMenue->setOpen(FALSE);
			else
				newMenue->setOpen(TRUE);
			dir.setFilter(QDir::Dirs |  QDir::Files);
	    	const QFileInfoList *strList = dir.entryInfoList();
			QFileInfo *f=strList->first();
			KApplDialogItem * newItem=0;
			while (f!=0) {
				if (f->fileName()!="." && f->fileName()!="..")  {
	  				if (newMenue!=0 && f->isFile()==TRUE) {
	  					KSimpleConfig kconfig(f->absFilePath(), true);
	  					kconfig.setGroup("KDE Desktop Entry");
	  					QString tmpStr(" ");
	  					tmpStr+=f->baseName();
	  					QString commStr=kconfig.readEntry("Comment");
							newItem= new KApplDialogItem(*f, newMenue, tmpStr, commStr);
	  					QString pixStr = kconfig.readEntry("MiniIcon");
	  					QPixmap pix;
	  					if (pixStr.isEmpty()==FALSE) {
					   			pix=kapp->getIconLoader()->loadApplicationMiniIcon(pixStr);
  						}
  						else {
	  				    	pixStr = kconfig.readEntry("Icon");
	  				    	if (pixStr.isEmpty()==FALSE) {
					   				pix=kapp->getIconLoader()->loadIcon(pixStr);
					   				pix.resize(16,16);
 					  			} 	
 					  			else	
					   				pix=kapp->getIconLoader()->loadApplicationMiniIcon("unknown.xpm");
  						}
  						newItem->setPixmap(0,pix);
					}	
					else if (f->isDir()==TRUE && f->fileName()!="Settings" ){
 							insertApplications(f->absFilePath(),newMenue);
					}
				}	
				f=strList->next();
			}
		}
	}	
				
}

void KApplDialog::resizeEvent ( QResizeEvent * e) {
	listBox->setGeometry(10,40,width()-20,height()-100);
    backBtn->setGeometry(10,height()-40,26,26);
    forwardBtn->setGeometry(width()-36,height()-40,26,26);
    QDialog::resizeEvent(e);	
}


void KApplDialog::openFileDialog() {
    QFileInfo f;
	QString str;
	do {
		str=QFileDialog::getOpenFileName ( 0, 0, this, "Get Application" );
		if (str.isNull()==FALSE) {
			f.setFile(str);
			if (f.isExecutable()==FALSE) {
				KMsgBox::message(this, i18n("Selection error"),
	          		i18n("Your selected file isn't an Executable!"),
	          		KMsgBox::EXCLAMATION);
			}
		}
		else
		    break;
	} while (f.exists()==FALSE || f.isExecutable()==FALSE);	
	if (str.isNull()==FALSE) {
		QStrList *strList = new QStrList(f.fileName());
		emit setApplName(*strList);
		accept();
	}	
}


























































