/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>

#include "devicelist.h"
#include "isapnpdb.h"
#include "isapnpvendors.h"
#include "mainwindow.h"


ISAPnPDataBase          isapnpdb;	// Ugly; execution success depends
ISAPnPVendorDictionary  isapnpvendors;	// on correct order of declarations...
DeviceList              devicelist;


int  main(int argc, char *argv[])
{
  KApplication              *ksysctrl   = new KApplication(argc, argv, "ksysctrl");
  KSystemControlMainWindow  *mainwindow = new KSystemControlMainWindow("mainwindow");
  
  ksysctrl->setTopWidget(mainwindow);
  mainwindow->show();
  
  return ksysctrl->exec();
}

