/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "idedrvscanner.h"


IDEDriveScanner::IDEDriveScanner()
{
  
}


IDEDriveScanner::~IDEDriveScanner()
{
  
}


/*
 * Public methods
 *****************/
 
Device  *IDEDriveScanner::firstDevice()
{
  _drvid = 'a';
    
  return nextDevice();
}


Device  *IDEDriveScanner::nextDevice()
{
  IDEDrive  *drive;
  
  do
  {
    drive = device();
    _drvid++;
  } while (!drive && (_drvid <= 'd')); 
    
  return drive;
}


/*
 * Private methods
 ******************/

IDEDrive  *IDEDriveScanner::device()
{
  QString  path = QString("/proc/ide/hd")+_drvid;
  QString  modelname, media;
  FILE     *idefhd;
  char     buffer[256];
  
  if ((idefhd = fopen((path+"/model").data(), "r")))
  {
    fgets(buffer, sizeof(buffer), idefhd);
    fclose(idefhd);
    
    modelname = QString(buffer).simplifyWhiteSpace();
    
    if ((idefhd = fopen((path+"/media").data(), "r")))
    {
      fgets(buffer, sizeof(buffer), idefhd);
      fclose(idefhd);
    
      media = QString(buffer).simplifyWhiteSpace();
      
      if      (media == "disk")   return new IDEDrive(modelname, IDEDrive::IDEClassDisk);
      else if (media == "floppy") return new IDEDrive(modelname, IDEDrive::IDEClassFloppy);
      else if (media == "cdrom")  return new IDEDrive(modelname, IDEDrive::IDEClassCDROM);
      else                        return new IDEDrive(modelname, IDEDrive::IDEClassUnknown);
    } else perror((path+"/media").data()); 
  }
  
  return 0L;
}





