/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "devicelist.h"
#include "idedrvscanner.h"
#include "isapnpscanner.h"
#include "parportscanner.h"
#include "pciscanner.h"
#include "scsiscanner.h"


DeviceList::DeviceList() : _firstscan(true)
{  
  setAutoDelete(true);
  clear();

  scanDevices();
}


/*
 * Public methods
 *****************/

QList<Conflict>  DeviceList::conflicts(Device *device, QList<Resource> reslist)
{
  QList<Conflict>  conflictlist;
  Device           *dev;
  Resource         *res, *devres;
  
  for (dev = first(); dev; dev = next())
  {
    if (dev != device)	// Well...
    {
      for (res = reslist.first(); res; res = reslist.next())
	for (devres = dev->firstResource(); devres; devres = dev->nextResource())
	  if (*res == *devres) conflictlist.append(new Conflict(dev, res)); 
    }
  }
  
  return conflictlist;
}


void  DeviceList::rescan()
{
  _firstscan = false;

  clear();
  scanDevices();
}


/*
 * Private methods 
 ******************/
 
void  DeviceList::scanDevices()
{
  QList<DeviceScanner>  scanlist;
  DeviceScanner         *scanner;
  Device                *device;
  
  scanlist.setAutoDelete(true);
  scanlist.clear();
  scanlist.append(new PCIScanner());
  scanlist.append(new ISAPnPScanner());
  scanlist.append(new SCSIScanner(!_firstscan));
  scanlist.append(new IDEDriveScanner());
  scanlist.append(new ParallelPortScanner());
  
  for (scanner = scanlist.first(); scanner; scanner = scanlist.next())
    for (device = scanner->firstDevice(); device; device = scanner->nextDevice())
      append(device);
}


