/***************************************************************************
                          khealthcare.h  -  description                              
                             -------------------                                         
    begin                : Tue Aug 24 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHEALTHCARE_H
#define KHEALTHCARE_H

#include <kapp.h>
#include "sensors.h"

class KConfig;
class KHChip;
class KHDisplayWidget;
class KHDockWidget;
class KHFeatureProfile;

/**
  *@author Ruediger Anlauf
  */

class KHealthCare : public KApplication  {

Q_OBJECT

public: 
	KHealthCare( int argc, char* argv[] );
	~KHealthCare();
	void showGui();
	void showDocking();
	void processSessionConfig();
	sensors_chip_name detectChip( bool display_message );

protected:
	KHFeatureProfile *createProfile( sensors_chip_name chipname );

protected:
	KHDisplayWidget *gui;
	KHChip *ioObj;
	KHDockWidget *dockwidget;
	KConfig *conf;
	sensors_chip_name chipname;
	KHFeatureProfile *profile;

protected slots:
  /**  */
  void setDocking( int enabled );
};

#endif





















