/***************************************************************************
                          khdisplayitem.h  -  description                              
                             -------------------                                         
    begin                : Sun Sep 26 1999                                           
    copyright            : (C) 1999 by Ruediger Anlauf                         
    email                : Ruediger.Anlauf@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KHDISPLAYITEM_H
#define KHDISPLAYITEM_H

#include <sensorid.h>
#include "khdisplaybase.h"

class QSpinBox;
class QLCDNumber;
class QLabel;
class QGridLayout;
class KHDisplayWidget;

/**
  *@author Ruediger Anlauf
  */

class KHDisplayItem : public KHDisplayBase {

public:
	KHDisplayItem( int NumDig, int loboxLoLim, int loboxHiLim, int loboxSteps,
								 int hiboxLoLim, int hiboxHiLim, int hiboxSteps,
								 SensorId sid, QWidget *Parent = 0 );
	~KHDisplayItem();
  /**  */
  QSpinBox * hibox();
  /**  */
  QSpinBox * lobox();
  /**  */
  QLCDNumber * lcd();
  /**  */
  QLabel *label();
  /**  */
  QString name();

protected:
	static int itemNr;
	static int xPos;
	static int yPos;
	QSpinBox *Lobox;
	QSpinBox *Hibox;
	QLCDNumber *Lcd;
  /**  */
	QLabel *Label;
	QString Name;
};

#endif





























