#include "vartable.moc"


// -- class VarRow implementation

VarRow::VarRow()
{
}

VarRow::VarRow(QString name, QString value)
{
  _name  = name;
  _value = value;
}

QString VarRow::line()
{
  QString tmp;

  tmp = _name + "=" + _value;
  return tmp;
}

void VarRow::paint(QPainter *p, int col, int width)
{
  QString tmp;
  int     fontpos = 0;

  switch (col)
  {
    case 0: tmp = _name;
            break;

    case 1: tmp = _value;
            break;
  }

  p->drawText(3, fontpos, width, p->fontMetrics().lineSpacing(),
              AlignLeft, tmp);
}

// -- class CronTable implementation

VarTable::VarTable(QWidget *parent, const char *name)
 : KRowTable(SelectRow, parent, name)
{
  setCellHeight(fontMetrics().lineSpacing());
  setNumCols(2);
}

void VarTable::addItem(QString name, QString value)
{
  VarRow *newRow = new VarRow(name, value);

  setNumRows(numRows() + 1);
  insertRow(newRow, numRows() - 1);
  if (isUpdatesEnabled())
    repaint();
}

void VarTable::addItem(VarRow *row)
{
  setNumRows(numRows() + 1);
  insertRow(row, numRows() - 1);
  if (isUpdatesEnabled())
    repaint();
}

void VarTable::clear()
{
  setTopCell(0);
  setNumRows(0);

  if (isUpdatesEnabled())
    updateScrollBars();
}

void VarTable::setCurrentItem(int row)
{
  setCurrentRow(row, -1);
}

void VarTable::mousePressEvent(QMouseEvent *e)
{
  if (e->button() == LeftButton)
    setCurrentRow(findRow(e->pos().y()), -1);
 
  if (e->button() == RightButton)
  {
    setCurrentRow(findRow(e->pos().y()), -1);
    emit rightClick();
  }
}

void VarTable::mouseDoubleClickEvent(QMouseEvent *)
{
  emit doubleClick();
}
