#include "crontable.moc"


QString mystrtok(char *_line = 0, bool rest = FALSE)
{
  static char *line;
  QString     tmp;

  if (rest)  { tmp = line; return tmp; }
  if (_line) { line = _line; }

  while (*line != ' ' && *line != '\t')
    tmp += *line++;

  while (*line == ' ' || *line == '\t')
    line++;

  return tmp;
}

// -- class CronRow implementation

CronRow::CronRow()
{
}

CronRow::CronRow(QString line, QString _comment, bool syscron)
{
  if (line.left(2) == "#\\")
  {
    line = line.right(line.length() - 2);
    enabled = FALSE;
  }
  else
    enabled = TRUE;

  minute   = mystrtok(line.data());
  hour     = mystrtok();
  DOM      = mystrtok();
  month    = mystrtok();
  DOW      = mystrtok();
  if (syscron) user = mystrtok();
  command  = mystrtok(0, TRUE);
  comment  = _comment;

  isedited = FALSE;
}

QString CronRow::line(bool syscron)
{
  QString tmp;

  if (comment.length() > 0)
    tmp = "# " + comment + "\n";

  if (!enabled)
    tmp = tmp + "#\\";

  tmp = tmp + minute + "\t" + hour + "\t" + DOM + "\t" + month + "\t" \
        + DOW + "\t";
  if (syscron) tmp += user + "\t";
  tmp += command;
  
  return tmp;
}

void CronRow::paint(QPainter *p, int col, int width)
{
  QString tmp;
  int     fontpos = 0;

  switch (col)
  {
    case 0: if (enabled) tmp = "+";
            break;

    case 1: tmp = hour;
            break;

    case 2: tmp = minute;
            break;

    case 3: tmp = DOM;
	    break;
	 
    case 4: tmp = month;
	    break;

    case 5: tmp = DOW;
	    break;

    case 6: tmp = user;
	    break;

    case 7: tmp = command;
	    break;
  }

  p->drawText(3, fontpos, width, p->fontMetrics().lineSpacing(),
              AlignLeft, tmp);
}

// -- class CronTable implementation

CronTable::CronTable(QWidget *parent, const char *name)
 : KRowTable (SelectRow, parent, name)
{
  setCellHeight(fontMetrics().lineSpacing());
  setNumCols(8);
}

void CronTable::addItem(QString line, QString comment)
{
  CronRow *newRow = new CronRow(line, comment, syscron);
  if (!syscron) newRow->setUser(user);
  setNumRows(numRows() + 1);
  insertRow(newRow, numRows() - 1);

  if (isUpdatesEnabled())
    repaint();
}

void CronTable::addItem(CronRow *row)
{
  setNumRows(numRows() + 1);
  insertRow(row, numRows() - 1);
  if (isUpdatesEnabled())
    repaint();
}

void CronTable::clear()
{
  setTopCell(0);
  setNumRows(0);

  if (isUpdatesEnabled())
    updateScrollBars();
}

void CronTable::setCurrentItem(int row)
{
  setCurrentRow(row, -1);
}

void CronTable::mousePressEvent(QMouseEvent *e)
{
  if (e->button() == LeftButton)
  {
    int prow = findRow(e->y());
    int pcol = findCol(e->x());

    setCurrentRow(prow, -1);

    if (prow != -1 && pcol == 0)
    {
      CronRow *row = (CronRow *) getRow(prow);
      row->setEnabled(!row->isEnabled());
      updateCell(prow, pcol, FALSE);
      emit changeState();
    }
  }
}

void CronTable::mouseDoubleClickEvent(QMouseEvent *e)
{
  if (e->button() == LeftButton)
    emit doubleClick();
}

void CronTable::keyPressEvent(QKeyEvent * e)
{
  if (e->key() == Key_Space)
  {
    CronRow *row = (CronRow *) selectedRow();
    if (row)
    {
      row->setEnabled(!row->isEnabled());
      updateCell(currentRow(), 0, FALSE);
      emit changeState();
    }
  }
}
