/*
    Copyright (C) 2017-2018 Laurent Montel <montel@kde.org>

    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This library is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
    License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to the
    Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#ifndef TRANSPORTPLUGINMANAGER_H
#define TRANSPORTPLUGINMANAGER_H

#include <QObject>
#include "kmailtransport_private_export.h"
namespace MailTransport {
class TransportAbstractPlugin;
class TransportPluginManagerPrivate;
class KMAILTRANSPORT_TESTS_EXPORT TransportPluginManager : public QObject
{
    Q_OBJECT
public:
    explicit TransportPluginManager(QObject *parent = nullptr);
    ~TransportPluginManager();

    static TransportPluginManager *self();

    MailTransport::TransportAbstractPlugin *plugin(const QString &identifier);
    QVector<MailTransport::TransportAbstractPlugin *> pluginsList() const;

Q_SIGNALS:
    void updatePluginList();

private:
    TransportPluginManagerPrivate *const d;
};
}

#endif // TRANSPORTPLUGINMANAGER_H
