/*
   Copyright (C) 2012-2016 Montel Laurent <montel@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#include "logwidget.h"

#include "Libkdepim/CustomLogWidget"

#include <QHBoxLayout>

LogWidget::LogWidget(QWidget *parent)
    : QWidget(parent)
{
    QHBoxLayout *layout = new QHBoxLayout;
    mCustomLogWidget = new KPIM::CustomLogWidget;
    layout->addWidget(mCustomLogWidget);
    setLayout(layout);
}

LogWidget::~LogWidget()
{

}

void LogWidget::clear()
{
    mCustomLogWidget->clear();
}

void LogWidget::addInfoLogEntry(const QString &log)
{
    mCustomLogWidget->addInfoLogEntry(log);
}

void LogWidget::addErrorLogEntry(const QString &log)
{
    mCustomLogWidget->addErrorLogEntry(log);
}

void LogWidget::addTitleLogEntry(const QString &log)
{
    mCustomLogWidget->addTitleLogEntry(log);
}

QString LogWidget::toHtml() const
{
    return mCustomLogWidget->toHtml();
}

QString LogWidget::toPlainText() const
{
    return mCustomLogWidget->toPlainText();
}

bool LogWidget::isEmpty() const
{
    return mCustomLogWidget->isEmpty();
}

void LogWidget::addEndLineLogEntry()
{
    mCustomLogWidget->addEndLineLogEntry();
}
