/*
*   Copyright (C) 2008 Nicola Gigante <nicola.gigante@gmail.com>
*   Copyright (C) 2009 Dario Freddi <drf@kde.org>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU Lesser General Public License as published by
*   the Free Software Foundation; either version 2.1 of the License, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU Lesser General Public License
*   along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
*/

#ifndef BACKENDS_MANAGER_H
#define BACKENDS_MANAGER_H

#include "AuthBackend.h"
#include "HelperProxy.h"
#include <kdecore_export.h>

namespace KAuth
{

class KDECORE_EXPORT BackendsManager
{
    static AuthBackend *auth;
    static HelperProxy *helper;

    BackendsManager();
public:
    static AuthBackend *authBackend();
    static HelperProxy *helperProxy();

private:
    static void init();
    static QList<QObject*> retrieveInstancesIn(const QString &path);
};

} // namespace Auth

#endif
