//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  This job is used to writing back items to the Akonadi storage, after
    ///  the user has changed them in any way.
    ///  For performance reasons either the full item (including the full payload)
    ///  can written back or only the meta data of the item.
    ///  Example:
    ///  @code
    ///  // Fetch item with unique id 125
    ///  Akonadi.ItemFetchJob fetchJob = new Akonadi.ItemFetchJob( Akonadi.Item( 125 ) );
    ///  if ( fetchJob.Exec() ) {
    ///    Akonadi.Item item = fetchJob.Items().first();
    ///    // Set a custom flag
    ///    item.setFlag( "\GotIt" );
    ///    // Store back modified item
    ///    Akonadi.ItemModifyJob modifyJob = new Akonadi.ItemModifyJob( item );
    ///    if ( modifyJob.Exec() )
    ///      qDebug() << "Item modified successfully";
    ///    else
    ///      qDebug() << "Error occurred";
    ///  } else {
    ///    qDebug() << "Error occurred";
    ///  }
    ///  @endcode
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> Job that modifies an existing item in the Akonadi storage. </short>
    [SmokeClass("Akonadi::ItemModifyJob")]
    public class ItemModifyJob : Akonadi.Job, IDisposable {
        protected ItemModifyJob(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ItemModifyJob), this);
        }
        /// <remarks>
        ///  Creates a new item modify job.
        /// <param> name="item" The modified item object to store.
        /// </param><param> name="parent" The parent object.
        ///      </param></remarks>        <short>    Creates a new item modify job.</short>
        public ItemModifyJob(Akonadi.Item item, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemModifyJob##", "ItemModifyJob(const Akonadi::Item&, QObject*)", typeof(void), typeof(Akonadi.Item), item, typeof(QObject), parent);
        }
        public ItemModifyJob(Akonadi.Item item) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemModifyJob#", "ItemModifyJob(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
        }
        /// <remarks>
        ///  Sets whether the payload of the modified item shall be
        ///  omitted from transmission to the Akonadi storage.
        ///  The default is <code>false</code>, however it can be set for
        ///  performance reasons.
        ///      </remarks>        <short>    Sets whether the payload of the modified item shall be  omitted from transmission to the Akonadi storage.</short>
        public void SetIgnorePayload(bool ignore) {
            interceptor.Invoke("setIgnorePayload$", "setIgnorePayload(bool)", typeof(void), typeof(bool), ignore);
        }
        /// <remarks>
        ///  Returns whether the payload of the modified item shall be
        ///  omitted from transmission to the Akonadi storage.
        ///      </remarks>        <short>    Returns whether the payload of the modified item shall be  omitted from transmission to the Akonadi storage.</short>
        public bool IgnorePayload() {
            return (bool) interceptor.Invoke("ignorePayload", "ignorePayload() const", typeof(bool));
        }
        /// <remarks>
        ///  Disables the check of the revision number.
        ///  @note If disabled, no conflict detection is available.
        ///      </remarks>        <short>    Disables the check of the revision number.</short>
        public void DisableRevisionCheck() {
            interceptor.Invoke("disableRevisionCheck", "disableRevisionCheck()", typeof(void));
        }
        /// <remarks>
        ///  Returns the modified and stored item including the changed revision number.
        ///      </remarks>        <short>    Returns the modified and stored item including the changed revision number.</short>
        public Akonadi.Item Item() {
            return (Akonadi.Item) interceptor.Invoke("item", "item() const", typeof(Akonadi.Item));
        }
        [SmokeMethod("doStart()")]
        protected override void DoStart() {
            interceptor.Invoke("doStart", "doStart()", typeof(void));
        }
        [SmokeMethod("doHandleResponse(const QByteArray&, const QByteArray&)")]
        protected override void DoHandleResponse(QByteArray tag, QByteArray data) {
            interceptor.Invoke("doHandleResponse##", "doHandleResponse(const QByteArray&, const QByteArray&)", typeof(void), typeof(QByteArray), tag, typeof(QByteArray), data);
        }
        ~ItemModifyJob() {
            interceptor.Invoke("~ItemModifyJob", "~ItemModifyJob()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~ItemModifyJob", "~ItemModifyJob()", typeof(void));
        }
        protected new IItemModifyJobSignals Emit {
            get { return (IItemModifyJobSignals) Q_EMIT; }
        }
    }

    public interface IItemModifyJobSignals : Akonadi.IJobSignals {
    }
}
