# this file is included by kdelibs/CMakeLists.txt and contains the cmake code
# which creates the KDEPlatformProfile.cmake file, which is installed by kdelibs

######## write profile file which will be installed #########

# Desktop profile (default profile)
if (KDE_PLATFORM_PROFILE STREQUAL "Desktop" OR NOT KDE_PLATFORM_PROFILE)
    set(KDE_PLATFORM_PROFILE "Desktop")
    set(KDE_PLATFORM_FEATURE_BINARY_COMPATIBLE_FEATURE_REDUCTION FALSE)
    set(KDE_PLATFORM_FEATURE_BINARY_INCOMPATIBLE_FEATURE_REDUCTION FALSE)
    set(KDE_PLATFORM_FEATURE_KIO_INPROCESS FALSE)
    set(KDE_PLATFORM_FEATURE_DISABLE_DEPRECATED FALSE)
endif (KDE_PLATFORM_PROFILE STREQUAL "Desktop" OR NOT KDE_PLATFORM_PROFILE)

# Tablet profile
if (KDE_PLATFORM_PROFILE STREQUAL "Tablet")
    set(KDE_PLATFORM_PROFILE "Tablet")
    set(KDE_PLATFORM_FEATURE_BINARY_COMPATIBLE_FEATURE_REDUCTION TRUE)
    set(KDE_PLATFORM_FEATURE_BINARY_INCOMPATIBLE_FEATURE_REDUCTION FALSE)
    set(KDE_PLATFORM_FEATURE_KIO_INPROCESS FALSE)
    set(KDE_PLATFORM_FEATURE_DISABLE_DEPRECATED FALSE)
    message(STATUS "KDE Platform Profile: TABLET")
endif (KDE_PLATFORM_PROFILE STREQUAL "Tablet")

# Mobile profile
if (KDE_PLATFORM_PROFILE STREQUAL "Mobile")
    set(KDE_PLATFORM_PROFILE "Mobile")
    set(KDE_PLATFORM_FEATURE_BINARY_COMPATIBLE_FEATURE_REDUCTION TRUE)
    set(KDE_PLATFORM_FEATURE_BINARY_INCOMPATIBLE_FEATURE_REDUCTION TRUE)
    set(KDE_PLATFORM_FEATURE_KIO_INPROCESS TRUE)
    set(KDE_PLATFORM_FEATURE_DISABLE_DEPRECATED TRUE)
    message(STATUS "KDE Platform Profile: MOBILE. Please be aware that this version of the KDE platform is BINARY INCOMPATIBLE to standard KDE. At this time no binary compatiblity is guaranteed even within the mobile target.")
endif (KDE_PLATFORM_PROFILE STREQUAL "Mobile")


# Writing the profile file
file(WRITE ${CMAKE_CURRENT_BINARY_DIR}/KDEPlatformProfile.cmake
"# this file was generated during the kdelibs build process
set(KDE_PLATFORM_PROFILE \"${KDE_PLATFORM_PROFILE}\")
set(KDE_PLATFORM_FEATURE_BINARY_COMPATIBLE_FEATURE_REDUCTION ${KDE_PLATFORM_FEATURE_BINARY_COMPATIBLE_FEATURE_REDUCTION})
set(KDE_PLATFORM_FEATURE_BINARY_INCOMPATIBLE_FEATURE_REDUCTION ${KDE_PLATFORM_FEATURE_BINARY_INCOMPATIBLE_FEATURE_REDUCTION})
set(KDE_PLATFORM_FEATURE_KIO_INPROCESS ${KDE_PLATFORM_FEATURE_KIO_INPROCESS})
set(KDE_PLATFORM_FEATURE_DISABLE_DEPRECATED ${KDE_PLATFORM_FEATURE_DISABLE_DEPRECATED})
")

