//////////////////////////////////////////////////////////////////////////////
// phasestyleconfig.h
// -------------------
// Config dialog for Phase widget style
// -------------------
// Copyright (c) 2004-2007 David Johnson <david@usermode.org>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//////////////////////////////////////////////////////////////////////////////

#ifndef PHASESTYLECONFIG_H
#define PHASESTYLECONFIG_H

#include <QWidget>
#include "ui_styledialog.h"

class PhaseStyleConfig : public QWidget, private Ui::StyleDialog
{
    Q_OBJECT
public:
    PhaseStyleConfig(QWidget* parent);
    ~PhaseStyleConfig();

signals:
    void changed(bool);

public slots:
    void save();
    void defaults();

protected slots:
    void updateChanged();

private:
    bool oldgradients;
    bool oldhighlights;
};

#endif // PHASESTYLECONFIG_H
