//Auto-generated by kalyptus. DO NOT EDIT.
namespace QImageBlitz {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    [SmokeClass("Blitz")]
    public class Blitz : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected Blitz(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Blitz), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Blitz() {
            staticInterceptor = new SmokeInvocation(typeof(Blitz), null);
        }
        public enum GradientType {
            VerticalGradient = 0,
            HorizontalGradient = 1,
            DiagonalGradient = 2,
            CrossDiagonalGradient = 3,
            PyramidGradient = 4,
            RectangleGradient = 5,
            PipeCrossGradient = 6,
            EllipticGradient = 7,
        }
        public enum RGBChannel {
            Grayscale = 0,
            Brightness = 1,
            Red = 2,
            Green = 3,
            Blue = 4,
            Alpha = 5,
            All = 6,
        }
        public enum EffectQuality {
            Low = 0,
            High = 1,
        }
        public enum ScaleFilterType {
            UndefinedFilter = 0,
            PointFilter = 1,
            BoxFilter = 2,
            TriangleFilter = 3,
            HermiteFilter = 4,
            HanningFilter = 5,
            HammingFilter = 6,
            BlackmanFilter = 7,
            GaussianFilter = 8,
            QuadraticFilter = 9,
            CubicFilter = 10,
            CatromFilter = 11,
            MitchellFilter = 12,
            LanczosFilter = 13,
            BesselFilter = 14,
            SincFilter = 15,
        }
        public enum ModulationType {
            Intensity = 0,
            Saturation = 1,
            HueShift = 2,
            Contrast = 3,
        }
        public Blitz() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Blitz", "Blitz()", typeof(void));
        }
        ~Blitz() {
            interceptor.Invoke("~Blitz", "~Blitz()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~Blitz", "~Blitz()", typeof(void));
        }
        /// <remarks>
        ///  Inverts an image. If the machine supports MMX this can do two pixels
        ///  at a time, otherwise it's the same as QImage.InvertPixels().
        /// <param> name="img" The image to invert.
        /// </param><param> name="mode" If to invert the alpha channel or not.
        /// </param></remarks>        <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Inverts an image.</short>
        public static bool Invert(QImage img, QImage.InvertMode mode) {
            return (bool) staticInterceptor.Invoke("invert#$", "invert(QImage&, QImage::InvertMode)", typeof(bool), typeof(QImage), img, typeof(QImage.InvertMode), mode);
        }
        public static bool Invert(QImage img) {
            return (bool) staticInterceptor.Invoke("invert#", "invert(QImage&)", typeof(bool), typeof(QImage), img);
        }
        /// <remarks>
        ///  Grayscales an image.
        /// <param> name="img" The image to grayscale.
        /// </param><param> name="reduceDepth" If true the result will be an 8bit palette image.
        /// </param></remarks>        <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Grayscales an image.</short>
        public static bool Grayscale(QImage img, bool reduceDepth) {
            return (bool) staticInterceptor.Invoke("grayscale#$", "grayscale(QImage&, bool)", typeof(bool), typeof(QImage), img, typeof(bool), reduceDepth);
        }
        public static bool Grayscale(QImage img) {
            return (bool) staticInterceptor.Invoke("grayscale#", "grayscale(QImage&)", typeof(bool), typeof(QImage), img);
        }
        /// <remarks>
        ///  A fast smoothscale method with MMX support.
        /// <param> name="img" The image to smoothscale.
        /// </param><param> name="sz" The size to scale to.
        /// </param><param> name="aspectRatio" What aspect ratio to use, if any.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    A fast smoothscale method with MMX support.</short>
        public static QImage SmoothScale(QImage img, QSize sz, Qt.AspectRatioMode aspectRatio) {
            return (QImage) staticInterceptor.Invoke("smoothScale##$", "smoothScale(QImage&, const QSize&, Qt::AspectRatioMode)", typeof(QImage), typeof(QImage), img, typeof(QSize), sz, typeof(Qt.AspectRatioMode), aspectRatio);
        }
        public static QImage SmoothScale(QImage img, QSize sz) {
            return (QImage) staticInterceptor.Invoke("smoothScale##", "smoothScale(QImage&, const QSize&)", typeof(QImage), typeof(QImage), img, typeof(QSize), sz);
        }
        public static QImage SmoothScale(QImage img, int dw, int dh, Qt.AspectRatioMode aspectRatio) {
            return (QImage) staticInterceptor.Invoke("smoothScale#$$$", "smoothScale(QImage&, int, int, Qt::AspectRatioMode)", typeof(QImage), typeof(QImage), img, typeof(int), dw, typeof(int), dh, typeof(Qt.AspectRatioMode), aspectRatio);
        }
        public static QImage SmoothScale(QImage img, int dw, int dh) {
            return (QImage) staticInterceptor.Invoke("smoothScale#$$", "smoothScale(QImage&, int, int)", typeof(QImage), typeof(QImage), img, typeof(int), dw, typeof(int), dh);
        }
        /// <remarks>
        ///  Smoothscales an image using a high-quality filter.
        /// <param> name="img" The image to smoothscale.
        /// </param><param> name="sz" The size to scale to.
        /// </param><param> name="blur" A blur factor. Values greater than 1.0 blur while values
        ///  less than 1.0 sharpen.
        /// </param><param> name="filter" The filter type.
        /// </param><param> name="aspectRatio" What aspect ratio to use, if any.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Smoothscales an image using a high-quality filter.</short>
        public static QImage SmoothScaleFilter(QImage img, QSize sz, float blur, Blitz.ScaleFilterType filter, Qt.AspectRatioMode aspectRatio) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter##$$$", "smoothScaleFilter(QImage&, const QSize&, float, Blitz::ScaleFilterType, Qt::AspectRatioMode)", typeof(QImage), typeof(QImage), img, typeof(QSize), sz, typeof(float), blur, typeof(Blitz.ScaleFilterType), filter, typeof(Qt.AspectRatioMode), aspectRatio);
        }
        public static QImage SmoothScaleFilter(QImage img, QSize sz, float blur, Blitz.ScaleFilterType filter) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter##$$", "smoothScaleFilter(QImage&, const QSize&, float, Blitz::ScaleFilterType)", typeof(QImage), typeof(QImage), img, typeof(QSize), sz, typeof(float), blur, typeof(Blitz.ScaleFilterType), filter);
        }
        public static QImage SmoothScaleFilter(QImage img, QSize sz, float blur) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter##$", "smoothScaleFilter(QImage&, const QSize&, float)", typeof(QImage), typeof(QImage), img, typeof(QSize), sz, typeof(float), blur);
        }
        public static QImage SmoothScaleFilter(QImage img, QSize sz) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter##", "smoothScaleFilter(QImage&, const QSize&)", typeof(QImage), typeof(QImage), img, typeof(QSize), sz);
        }
        public static QImage SmoothScaleFilter(QImage img, int dwX, int dwY, float blur, Blitz.ScaleFilterType filter, Qt.AspectRatioMode aspectRatio) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter#$$$$$", "smoothScaleFilter(QImage&, int, int, float, Blitz::ScaleFilterType, Qt::AspectRatioMode)", typeof(QImage), typeof(QImage), img, typeof(int), dwX, typeof(int), dwY, typeof(float), blur, typeof(Blitz.ScaleFilterType), filter, typeof(Qt.AspectRatioMode), aspectRatio);
        }
        public static QImage SmoothScaleFilter(QImage img, int dwX, int dwY, float blur, Blitz.ScaleFilterType filter) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter#$$$$", "smoothScaleFilter(QImage&, int, int, float, Blitz::ScaleFilterType)", typeof(QImage), typeof(QImage), img, typeof(int), dwX, typeof(int), dwY, typeof(float), blur, typeof(Blitz.ScaleFilterType), filter);
        }
        public static QImage SmoothScaleFilter(QImage img, int dwX, int dwY, float blur) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter#$$$", "smoothScaleFilter(QImage&, int, int, float)", typeof(QImage), typeof(QImage), img, typeof(int), dwX, typeof(int), dwY, typeof(float), blur);
        }
        public static QImage SmoothScaleFilter(QImage img, int dwX, int dwY) {
            return (QImage) staticInterceptor.Invoke("smoothScaleFilter#$$", "smoothScaleFilter(QImage&, int, int)", typeof(QImage), typeof(QImage), img, typeof(int), dwX, typeof(int), dwY);
        }
        /// <remarks>
        ///  Convolves an image using a convolution matrix, (kernel), and provides
        ///  the basis for many different image filters and effects.
        /// <param> name="img" The image to process.
        /// </param><param> name="matrix_size" The size of one side of the convolution matrix, ie:
        ///  a 3x3 matrix would be 3, not 9.
        /// </param><param> name="matrix" The convolution matrix.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Convolves an image using a convolution matrix, (kernel), and provides  the basis for many different image filters and effects.</short>
        public static QImage Convolve(QImage img, int matrix_size, ref float matrix) {
            StackItem[] stack = new StackItem[4];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(img);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(img);
#endif
            stack[2].s_int = matrix_size;
            stack[3].s_float = matrix;
            staticInterceptor.Invoke("convolve#$$", "convolve(QImage&, int, float*)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
            matrix = stack[3].s_float;
            object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
            ((GCHandle) stack[0].s_class).Free();
#endif
            return (QImage) returnValue;
        }
        /// <remarks>
        ///  Same as above but with a faster integer matrix.
        ///      </remarks>        <short>    Same as above but with a faster integer matrix.</short>
        public static QImage ConvolveInteger(QImage img, int matrix_size, ref int matrix, int divisor) {
            StackItem[] stack = new StackItem[5];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(img);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(img);
#endif
            stack[2].s_int = matrix_size;
            stack[3].s_int = matrix;
            stack[4].s_int = divisor;
            staticInterceptor.Invoke("convolveInteger#$$$", "convolveInteger(QImage&, int, int*, int)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
            matrix = stack[3].s_int;
            object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
            ((GCHandle) stack[0].s_class).Free();
#endif
            return (QImage) returnValue;
        }
        public static QImage ConvolveInteger(QImage img, int matrix_size, ref int matrix) {
            StackItem[] stack = new StackItem[4];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(img);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(img);
#endif
            stack[2].s_int = matrix_size;
            stack[3].s_int = matrix;
            staticInterceptor.Invoke("convolveInteger#$$", "convolveInteger(QImage&, int, int*)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
            matrix = stack[3].s_int;
            object returnValue = ((GCHandle) stack[0].s_class).Target;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[0].s_class);
#else
            ((GCHandle) stack[0].s_class).Free();
#endif
            return (QImage) returnValue;
        }
        /// <remarks>
        ///  A fast blur algorithm.
        /// <param> name="img" The image to process.
        /// </param><param> name="radius" The radius of the blur. Larger values blur more.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    A fast blur algorithm.</short>
        public static QImage Blur(QImage img, int radius) {
            return (QImage) staticInterceptor.Invoke("blur#$", "blur(QImage&, int)", typeof(QImage), typeof(QImage), img, typeof(int), radius);
        }
        public static QImage Blur(QImage img) {
            return (QImage) staticInterceptor.Invoke("blur#", "blur(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  A high quality gaussian/convolve-based blur.
        /// <param> name="img" The image to process.
        /// </param><param> name="radius" The radius of the gaussian, not counting the center
        ///  pixel. Use 0, (recommended), and an appropriate one will be used.
        /// </param><param> name="sigma" The standard deviation of the gaussian in pixels. Use
        ///  1.0, (recommended), for the default value.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    A high quality gaussian/convolve-based blur.</short>
        public static QImage GaussianBlur(QImage img, float radius, float sigma) {
            return (QImage) staticInterceptor.Invoke("gaussianBlur#$$", "gaussianBlur(QImage&, float, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius, typeof(float), sigma);
        }
        public static QImage GaussianBlur(QImage img, float radius) {
            return (QImage) staticInterceptor.Invoke("gaussianBlur#$", "gaussianBlur(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius);
        }
        public static QImage GaussianBlur(QImage img) {
            return (QImage) staticInterceptor.Invoke("gaussianBlur#", "gaussianBlur(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Detects edges in an image using the Sobel algorithm.
        /// <param> name="img" The image to process.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Detects edges in an image using the Sobel algorithm.</short>
        public static QImage Edge(QImage img) {
            return (QImage) staticInterceptor.Invoke("edge#", "edge(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Detects edges in an image using a convolution matrix.
        /// <param> name="img" The image to process.
        /// </param><param> name="radius" The radius of the gaussian, not counting the center
        ///  pixel. Use 0, (recommended), and an appropriate one will be used.
        /// </param><param> name="quality" Determines if to use a small or large convolution matrix.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Detects edges in an image using a convolution matrix.</short>
        public static QImage ConvolveEdge(QImage img, float radius, Blitz.EffectQuality quality) {
            return (QImage) staticInterceptor.Invoke("convolveEdge#$$", "convolveEdge(QImage&, float, Blitz::EffectQuality)", typeof(QImage), typeof(QImage), img, typeof(float), radius, typeof(Blitz.EffectQuality), quality);
        }
        public static QImage ConvolveEdge(QImage img, float radius) {
            return (QImage) staticInterceptor.Invoke("convolveEdge#$", "convolveEdge(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius);
        }
        public static QImage ConvolveEdge(QImage img) {
            return (QImage) staticInterceptor.Invoke("convolveEdge#", "convolveEdge(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Sharpens an image.
        /// <param> name="img" The image to process.
        /// </param><param> name="radius" The radius of the gaussian, not counting the center
        ///  pixel. Use 0, (recommended), and an appropriate one will be used.
        /// </param><param> name="sigma" The standard deviation of the gaussian in pixels. Use
        ///  1.0, (recommended), for the default value.
        /// </param><param> name="quality" Determines if to use a small or large convolution matrix.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Sharpens an image.</short>
        public static QImage GaussianSharpen(QImage img, float radius, float sigma, Blitz.EffectQuality quality) {
            return (QImage) staticInterceptor.Invoke("gaussianSharpen#$$$", "gaussianSharpen(QImage&, float, float, Blitz::EffectQuality)", typeof(QImage), typeof(QImage), img, typeof(float), radius, typeof(float), sigma, typeof(Blitz.EffectQuality), quality);
        }
        public static QImage GaussianSharpen(QImage img, float radius, float sigma) {
            return (QImage) staticInterceptor.Invoke("gaussianSharpen#$$", "gaussianSharpen(QImage&, float, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius, typeof(float), sigma);
        }
        public static QImage GaussianSharpen(QImage img, float radius) {
            return (QImage) staticInterceptor.Invoke("gaussianSharpen#$", "gaussianSharpen(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius);
        }
        public static QImage GaussianSharpen(QImage img) {
            return (QImage) staticInterceptor.Invoke("gaussianSharpen#", "gaussianSharpen(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  A cheap, fast sharpen.
        /// <param> name="radius" The radius. Larger values sharpen more.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    A cheap, fast sharpen.</short>
        public static QImage Sharpen(QImage img, int radius) {
            return (QImage) staticInterceptor.Invoke("sharpen#$", "sharpen(QImage&, int)", typeof(QImage), typeof(QImage), img, typeof(int), radius);
        }
        public static QImage Sharpen(QImage img) {
            return (QImage) staticInterceptor.Invoke("sharpen#", "sharpen(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Embosses an image.
        /// <param> name="img" The image to process.
        /// </param><param> name="radius" The radius of the gaussian, not counting the center
        ///  pixel. Use 0, (recommended), and an appropriate one will be used.
        /// </param><param> name="sigma" The standard deviation of the gaussian in pixels. Use
        ///  1.0, (recommended), for the default value.
        /// </param><param> name="quality" Determines if to use a small or large convolution matrix.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Embosses an image.</short>
        public static QImage Emboss(QImage img, float radius, float sigma, Blitz.EffectQuality quality) {
            return (QImage) staticInterceptor.Invoke("emboss#$$$", "emboss(QImage&, float, float, Blitz::EffectQuality)", typeof(QImage), typeof(QImage), img, typeof(float), radius, typeof(float), sigma, typeof(Blitz.EffectQuality), quality);
        }
        public static QImage Emboss(QImage img, float radius, float sigma) {
            return (QImage) staticInterceptor.Invoke("emboss#$$", "emboss(QImage&, float, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius, typeof(float), sigma);
        }
        public static QImage Emboss(QImage img, float radius) {
            return (QImage) staticInterceptor.Invoke("emboss#$", "emboss(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius);
        }
        public static QImage Emboss(QImage img) {
            return (QImage) staticInterceptor.Invoke("emboss#", "emboss(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Antialiases an image.
        /// <param> name="img" The image to process.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Antialiases an image.</short>
        public static QImage Antialias(QImage img) {
            return (QImage) staticInterceptor.Invoke("antialias#", "antialias(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Minimizes speckle noise in the source image using the 8 hull
        ///  algorithm.
        /// <param> name="img" The image to process.
        /// </param></remarks>        <return> A reference to the image for convenience.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Minimizes speckle noise in the source image using the 8 hull  algorithm.</short>
        public static QImage Despeckle(QImage img) {
            return (QImage) staticInterceptor.Invoke("despeckle#", "despeckle(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  High quality, fast HSV contrast.
        /// <param> name="img" The image to process.
        /// </param><param> name="sharpen" If true sharpness is increase, (spiffed). Otherwise
        ///  it is decreased, (dulled).
        /// </param><param> name="weight" How much to spiff or dull.
        /// </param></remarks>        <return> A reference to the image for convenience.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    High quality, fast HSV contrast.</short>
        public static QImage Contrast(QImage img, bool sharpen, int weight) {
            return (QImage) staticInterceptor.Invoke("contrast#$$", "contrast(QImage&, bool, int)", typeof(QImage), typeof(QImage), img, typeof(bool), sharpen, typeof(int), weight);
        }
        public static QImage Contrast(QImage img, bool sharpen) {
            return (QImage) staticInterceptor.Invoke("contrast#$", "contrast(QImage&, bool)", typeof(QImage), typeof(QImage), img, typeof(bool), sharpen);
        }
        /// <remarks>
        ///  Performs histogram equalization.
        /// <param> name="img" The image to equalize.
        /// </param></remarks>        <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Performs histogram equalization.</short>
        public static bool Equalize(QImage img) {
            return (bool) staticInterceptor.Invoke("equalize#", "equalize(QImage&)", typeof(bool), typeof(QImage), img);
        }
        /// <remarks>
        ///  Normalizes the pixel values to span the full range of color values.
        ///  This is a contrast enhancement technique.
        /// <param> name="img" The image to normalize
        /// </param></remarks>        <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Normalizes the pixel values to span the full range of color values.</short>
        public static bool Normalize(QImage img) {
            return (bool) staticInterceptor.Invoke("normalize#", "normalize(QImage&)", typeof(bool), typeof(QImage), img);
        }
        /// <remarks>
        ///  Either brighten or dim the image by a specified percent. For example,
        ///  0.50 will modify the colors by 50%.
        /// <param> name="img" The image to process.
        /// </param><param> name="percent" The percent value. Use a negative value to dim.
        /// </param></remarks>        <return> A reference to the image for convenience.
        /// </return>
        ///         <author> Benjamin Roe (ben@benroe.com)
        ///      </author>
        ///         <short>    Either brighten or dim the image by a specified percent.</short>
        public static QImage Intensity(QImage img, float percent) {
            return (QImage) staticInterceptor.Invoke("intensity#$", "intensity(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), percent);
        }
        /// <remarks>
        ///  Modifies the intensity of an image's RGB channel.
        /// <param> name="img" The image to process.
        /// </param><param> name="percent" Percent value. Use a negative value to dim.
        /// </param><param> name="channel" Which channel(s) should be modified. Only Red, Green,
        ///  and Blue are valid.
        /// </param></remarks>        <return> A reference to the image for convenience.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Modifies the intensity of an image's RGB channel.</short>
        public static QImage ChannelIntensity(QImage img, float percent, Blitz.RGBChannel channel) {
            return (QImage) staticInterceptor.Invoke("channelIntensity#$$", "channelIntensity(QImage&, float, Blitz::RGBChannel)", typeof(QImage), typeof(QImage), img, typeof(float), percent, typeof(Blitz.RGBChannel), channel);
        }
        /// <remarks>
        ///  Desaturate an image evenly.
        /// <param> name="img" The image to process.
        /// </param><param> name="desat" A value between 0 and 1 setting the degree of desaturation
        /// </param></remarks>        <return> A reference to the image for convenience.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Desaturate an image evenly.</short>
        public static QImage Desaturate(QImage img, float desat) {
            return (QImage) staticInterceptor.Invoke("desaturate#$", "desaturate(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), desat);
        }
        public static QImage Desaturate(QImage img) {
            return (QImage) staticInterceptor.Invoke("desaturate#", "desaturate(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Fade an image to a certain background color. The number of colors will
        ///  not be changed.
        /// <param> name="img" The image to process.
        /// </param><param> name="val" The strength of the effect. 0 <= val <= 1.
        /// </param><param> name="color" The background color.
        /// </param></remarks>        <return> A reference to the image for convenience.
        ///      </return>
        ///         <short>    Fade an image to a certain background color.</short>
        public static QImage Fade(QImage img, float val, QColor color) {
            return (QImage) staticInterceptor.Invoke("fade#$#", "fade(QImage&, float, const QColor&)", typeof(QImage), typeof(QImage), img, typeof(float), val, typeof(QColor), color);
        }
        /// <remarks>
        ///  This recolors a pixmap. The most dark color will become color a,
        ///  the most bright one color b, and in between.
        /// <param> name="img" The image to process.
        /// </param><param> name="ca" Color a
        /// </param><param> name="cb" Color b
        ///      </param></remarks>        <short>    This recolors a pixmap.</short>
        public static QImage Flatten(QImage img, QColor ca, QColor cb) {
            return (QImage) staticInterceptor.Invoke("flatten###", "flatten(QImage&, const QColor&, const QColor&)", typeof(QImage), typeof(QImage), img, typeof(QColor), ca, typeof(QColor), cb);
        }
        /// <remarks>
        ///  Thresholds an image based on a given channel and threshold value.
        /// <param> name="img" The image to process.
        /// </param><param> name="thresholdValue" The value that separates "on" colors from "off"
        ///  ones.
        /// </param><param> name="channel" The channel to use when thresholding.
        /// </param><param> name="aboveColor" The color to use for values at or above the threshold.
        /// </param><param> name="belowColor" The color to use for values below the threshold.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Thresholds an image based on a given channel and threshold value.</short>
        public static QImage Threshold(QImage img, ushort thresholdValue, Blitz.RGBChannel channel, uint aboveColor, uint belowColor) {
            return (QImage) staticInterceptor.Invoke("threshold#$$$$", "threshold(QImage&, unsigned char, Blitz::RGBChannel, unsigned int, unsigned int)", typeof(QImage), typeof(QImage), img, typeof(ushort), thresholdValue, typeof(Blitz.RGBChannel), channel, typeof(uint), aboveColor, typeof(uint), belowColor);
        }
        public static QImage Threshold(QImage img, ushort thresholdValue, Blitz.RGBChannel channel, uint aboveColor) {
            return (QImage) staticInterceptor.Invoke("threshold#$$$", "threshold(QImage&, unsigned char, Blitz::RGBChannel, unsigned int)", typeof(QImage), typeof(QImage), img, typeof(ushort), thresholdValue, typeof(Blitz.RGBChannel), channel, typeof(uint), aboveColor);
        }
        public static QImage Threshold(QImage img, ushort thresholdValue, Blitz.RGBChannel channel) {
            return (QImage) staticInterceptor.Invoke("threshold#$$", "threshold(QImage&, unsigned char, Blitz::RGBChannel)", typeof(QImage), typeof(QImage), img, typeof(ushort), thresholdValue, typeof(Blitz.RGBChannel), channel);
        }
        public static QImage Threshold(QImage img, ushort thresholdValue) {
            return (QImage) staticInterceptor.Invoke("threshold#$", "threshold(QImage&, unsigned char)", typeof(QImage), typeof(QImage), img, typeof(ushort), thresholdValue);
        }
        public static QImage Threshold(QImage img) {
            return (QImage) staticInterceptor.Invoke("threshold#", "threshold(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Swirls the image by a specified amount
        /// <param> name="img" The image to process.
        /// </param><param> name="degrees" The tightness of the swirl.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Swirls the image by a specified amount </short>
        public static QImage Swirl(QImage img, float degrees) {
            return (QImage) staticInterceptor.Invoke("swirl#$", "swirl(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), degrees);
        }
        public static QImage Swirl(QImage img) {
            return (QImage) staticInterceptor.Invoke("swirl#", "swirl(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Implodes an image by a specified percent.
        /// <param> name="img" The QImage to process.
        /// </param><param> name="amount" The extent of the implosion.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Implodes an image by a specified percent.</short>
        public static QImage Implode(QImage img, float amount) {
            return (QImage) staticInterceptor.Invoke("implode#$", "implode(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), amount);
        }
        public static QImage Implode(QImage img) {
            return (QImage) staticInterceptor.Invoke("implode#", "implode(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Modifies the pixels along a sine wave.
        /// <param> name="img" The image to process.
        /// </param><param> name="amplitude" The amplitude of the sine wave.
        /// </param><param> name="frequency" The frequency of the sine wave.
        /// </param><param> name="background" An RGBA value to use for the background. After the
        ///  effect some pixels may be "empty". This value is used for those pixels.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Modifies the pixels along a sine wave.</short>
        public static QImage Wave(QImage img, float amplitude, float frequency, uint background) {
            return (QImage) staticInterceptor.Invoke("wave#$$$", "wave(QImage&, float, float, unsigned int)", typeof(QImage), typeof(QImage), img, typeof(float), amplitude, typeof(float), frequency, typeof(uint), background);
        }
        public static QImage Wave(QImage img, float amplitude, float frequency) {
            return (QImage) staticInterceptor.Invoke("wave#$$", "wave(QImage&, float, float)", typeof(QImage), typeof(QImage), img, typeof(float), amplitude, typeof(float), frequency);
        }
        public static QImage Wave(QImage img, float amplitude) {
            return (QImage) staticInterceptor.Invoke("wave#$", "wave(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), amplitude);
        }
        public static QImage Wave(QImage img) {
            return (QImage) staticInterceptor.Invoke("wave#", "wave(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Produces an oil painting effect.
        /// <param> name="img" The image to process.
        /// </param><param> name="radius" The radius of the gaussian, not counting the center
        ///  pixel. Use 0, (recommended), and an appropriate one will be used.
        /// </param><param> name="quality" Determines if to use a small or large convolution matrix.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Produces an oil painting effect.</short>
        public static QImage OilPaint(QImage img, float radius, Blitz.EffectQuality quality) {
            return (QImage) staticInterceptor.Invoke("oilPaint#$$", "oilPaint(QImage&, float, Blitz::EffectQuality)", typeof(QImage), typeof(QImage), img, typeof(float), radius, typeof(Blitz.EffectQuality), quality);
        }
        public static QImage OilPaint(QImage img, float radius) {
            return (QImage) staticInterceptor.Invoke("oilPaint#$", "oilPaint(QImage&, float)", typeof(QImage), typeof(QImage), img, typeof(float), radius);
        }
        public static QImage OilPaint(QImage img) {
            return (QImage) staticInterceptor.Invoke("oilPaint#", "oilPaint(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Produces a "charcoal" image effect.
        /// <param> name="img" The image to process.
        /// </param></remarks>        <return> The processed image. The original is not changed.
        /// </return>
        ///         <author> Daniel M. Duley (mosfet)
        ///      </author>
        ///         <short>    Produces a "charcoal" image effect.</short>
        public static QImage Charcoal(QImage img) {
            return (QImage) staticInterceptor.Invoke("charcoal#", "charcoal(QImage&)", typeof(QImage), typeof(QImage), img);
        }
        /// <remarks>
        ///  Create a gradient from color a to color b of the specified type.
        /// <param> name="size" The desired size of the gradient.
        /// </param><param> name="ca" Color a
        /// </param><param> name="cb" Color b
        /// </param><param> name="type" The type of gradient.
        /// </param></remarks>        <return> The gradient.
        ///      </return>
        ///         <short>    Create a gradient from color a to color b of the specified type.</short>
        public static QImage Gradient(QSize size, QColor ca, QColor cb, Blitz.GradientType type) {
            return (QImage) staticInterceptor.Invoke("gradient###$", "gradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType)", typeof(QImage), typeof(QSize), size, typeof(QColor), ca, typeof(QColor), cb, typeof(Blitz.GradientType), type);
        }
        /// <remarks>
        ///  Creates an 8bit grayscale gradient suitable for use as an alpha channel
        ///  using QImage.SetAlphaChannel().
        /// <param> name="size" The desired size of the gradient.
        /// </param><param> name="ca" The grayscale start value.
        /// </param><param> name="cb" The grayscale end value.
        /// </param><param> name="type" The type of gradient.
        /// </param></remarks>        <return> The gradient.
        ///      </return>
        ///         <short>    Creates an 8bit grayscale gradient suitable for use as an alpha channel  using QImage.SetAlphaChannel().</short>
        public static QImage GrayGradient(QSize size, ushort ca, ushort cb, Blitz.GradientType type) {
            return (QImage) staticInterceptor.Invoke("grayGradient#$$$", "grayGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType)", typeof(QImage), typeof(QSize), size, typeof(ushort), ca, typeof(ushort), cb, typeof(Blitz.GradientType), type);
        }
        /// <remarks>
        ///  Create an unbalanced gradient. An unbalanced gradient is a gradient
        ///  where the transition from color a to color b is not linear, but in this
        ///  case exponential.
        /// <param> name="size" The desired size of the gradient.
        /// </param><param> name="ca" Color a
        /// </param><param> name="cb" Color b
        /// </param><param> name="type" The type of gradient.
        /// </param><param> name="xfactor" The x decay length. Use a value between -200 and 200.
        /// </param><param> name="yfactor" The y decay length.
        /// </param></remarks>        <return> The gradient.
        ///      </return>
        ///         <short>    Create an unbalanced gradient.</short>
        public static QImage UnbalancedGradient(QSize size, QColor ca, QColor cb, Blitz.GradientType type, int xfactor, int yfactor) {
            return (QImage) staticInterceptor.Invoke("unbalancedGradient###$$$", "unbalancedGradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType, int, int)", typeof(QImage), typeof(QSize), size, typeof(QColor), ca, typeof(QColor), cb, typeof(Blitz.GradientType), type, typeof(int), xfactor, typeof(int), yfactor);
        }
        public static QImage UnbalancedGradient(QSize size, QColor ca, QColor cb, Blitz.GradientType type, int xfactor) {
            return (QImage) staticInterceptor.Invoke("unbalancedGradient###$$", "unbalancedGradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType, int)", typeof(QImage), typeof(QSize), size, typeof(QColor), ca, typeof(QColor), cb, typeof(Blitz.GradientType), type, typeof(int), xfactor);
        }
        public static QImage UnbalancedGradient(QSize size, QColor ca, QColor cb, Blitz.GradientType type) {
            return (QImage) staticInterceptor.Invoke("unbalancedGradient###$", "unbalancedGradient(const QSize&, const QColor&, const QColor&, Blitz::GradientType)", typeof(QImage), typeof(QSize), size, typeof(QColor), ca, typeof(QColor), cb, typeof(Blitz.GradientType), type);
        }
        /// <remarks>
        ///  Creates an 8bit grayscale gradient suitable for use as an alpha channel
        ///  using QImage.SetAlphaChannel().
        /// <param> name="size" The desired size of the gradient.
        /// </param><param> name="type" The type of gradient.
        /// </param><param> name="ca" The grayscale start value.
        /// </param><param> name="cb" The grayscale end value.
        /// </param><param> name="xfactor" The x decay length. Use a value between -200 and 200.
        /// </param><param> name="yfactor" The y decay length.
        /// </param></remarks>        <return> The gradient.
        ///      </return>
        ///         <short>    Creates an 8bit grayscale gradient suitable for use as an alpha channel  using QImage.SetAlphaChannel().</short>
        public static QImage GrayUnbalancedGradient(QSize size, ushort ca, ushort cb, Blitz.GradientType type, int xfactor, int yfactor) {
            return (QImage) staticInterceptor.Invoke("grayUnbalancedGradient#$$$$$", "grayUnbalancedGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType, int, int)", typeof(QImage), typeof(QSize), size, typeof(ushort), ca, typeof(ushort), cb, typeof(Blitz.GradientType), type, typeof(int), xfactor, typeof(int), yfactor);
        }
        public static QImage GrayUnbalancedGradient(QSize size, ushort ca, ushort cb, Blitz.GradientType type, int xfactor) {
            return (QImage) staticInterceptor.Invoke("grayUnbalancedGradient#$$$$", "grayUnbalancedGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType, int)", typeof(QImage), typeof(QSize), size, typeof(ushort), ca, typeof(ushort), cb, typeof(Blitz.GradientType), type, typeof(int), xfactor);
        }
        public static QImage GrayUnbalancedGradient(QSize size, ushort ca, ushort cb, Blitz.GradientType type) {
            return (QImage) staticInterceptor.Invoke("grayUnbalancedGradient#$$$", "grayUnbalancedGradient(const QSize&, unsigned char, unsigned char, Blitz::GradientType)", typeof(QImage), typeof(QSize), size, typeof(ushort), ca, typeof(ushort), cb, typeof(Blitz.GradientType), type);
        }
        /// <remarks>
        ///  Modulate the image with a color channel of another image.
        /// <param> name="img" The QImage to modulate and result.
        /// </param><param> name="modImg" The QImage to use for modulation.
        /// </param><param> name="reverse" Invert the meaning of image/modImage; result is image!
        /// </param><param> name="type" The modulation Type to use.
        /// </param><param> name="factor" The modulation amplitude; with 0 no effect [-200;200].
        /// </param><param> name="channel" The RBG channel of image2 to use for modulation.
        /// </param></remarks>        <return> Returns the image(), provided for convenience.
        ///      </return>
        ///         <short>    Modulate the image with a color channel of another image.</short>
        public static QImage Modulate(QImage img, QImage modImg, bool reverse, Blitz.ModulationType type, int factor, Blitz.RGBChannel channel) {
            return (QImage) staticInterceptor.Invoke("modulate##$$$$", "modulate(QImage&, QImage&, bool, Blitz::ModulationType, int, Blitz::RGBChannel)", typeof(QImage), typeof(QImage), img, typeof(QImage), modImg, typeof(bool), reverse, typeof(Blitz.ModulationType), type, typeof(int), factor, typeof(Blitz.RGBChannel), channel);
        }
    }
}
