/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2003 by Andreas Zehender
    email                : zehender@kde.org
    copyright            : (C) 2002 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#include "pmsettingsdialog.h"

//#define KPM_WITH_OBJECT_LIBRARY

#include "pmpovraysettings.h"
#include "pmcolorsettings.h"
#include "pmgridsettings.h"
#include "pmobjectsettings.h"
#include "pmpreviewsettings.h"
#include "pmlayoutsettings.h"
#ifdef  KPM_WITH_OBJECT_LIBRARY
#include "pmobjectlibrarysettings.h"
#endif
#include "pmpluginsettings.h"
#include "pmopenglsettings.h"

#include "pmrendermanager.h"
#include "pmdebug.h"

#include <kvbox.h>
#include <q3listview.h>
#include <QList>
#include <QResizeEvent>
#include <klocale.h>
#include <kconfig.h>
#include <kicon.h>


PMSettingsDialogPage::PMSettingsDialogPage( QWidget* parent )
      : QWidget( parent )
{
}

QSize PMSettingsDialog::s_size = QSize( 640, 400 );

PMSettingsDialog::PMSettingsDialog( PMPart* part, QWidget* parent )
      : KPageDialog( parent)
{
   setCaption( i18n( "Configure" ) );
   setButtons( Ok | Apply | Cancel | Default );
   setDefaultButton( Ok );
   setFaceType( KPageDialog::List );
	PMSettingsDialogPage* page;

   m_pPart = part;

	page = new PMPovraySettings( );
	KPageWidgetItem* ipovray = addPage( page, i18n( "Povray" ) );
	ipovray->setIcon( KIcon( "pmconfigureopengl" ) );
	ipovray->setHeader( i18n( "Povray Options" ) );
	m_pages.push_back( PMRegisteredSettingsPage( ipovray, page ) );
	
	page = new PMOpenGLSettings( );
	KPageWidgetItem* igl = addPage( page, i18n( "OpenGL" ) );
	igl->setIcon( KIcon( "pmconfigurepovray" ) );
	igl->setHeader( i18n( "OpenGL Display Settings" ) );
	m_pages.push_back( PMRegisteredSettingsPage( igl, page ) );

	page = new PMColorSettings( );
	KPageWidgetItem* icolor = addPage( page, i18n( "Colors" ) );
	icolor->setIcon( KIcon( "pmconfiguregraphicalview" ) );
	icolor->setHeader( i18n( "Color Settings" ) );
	m_pages.push_back( PMRegisteredSettingsPage( icolor, page ) );

	page = new PMGridSettings( );
	KPageWidgetItem* igrid = addPage( page, i18n( "Grid" ) );
	igrid->setIcon( KIcon( "pmconfiguregrid" ) );
	igrid->setHeader( i18n( "Grid Settings" ) );
	m_pages.push_back( PMRegisteredSettingsPage( igrid, page ) );

	page = new PMObjectSettings( );
	KPageWidgetItem* iobjects = addPage( page, i18n( "Objects" ) );
	iobjects->setIcon( KIcon( "pmconfigureobjects" ) );
	iobjects->setHeader( i18n( "Display Settings for Objects" ) );
	m_pages.push_back( PMRegisteredSettingsPage( iobjects, page ) );

	page = new PMPreviewSettings( );
	KPageWidgetItem* ipreview = addPage( page, i18n( "Texture Preview" ) );
	ipreview->setIcon( KIcon( "pmconfiguretexturepreview" ) );
	ipreview->setHeader( i18n( "Display Settings for Texture Previews" ) );
	m_pages.push_back( PMRegisteredSettingsPage( ipreview, page ) );

	page = new PMLayoutSettings( );
	KPageWidgetItem* ilayout = addPage( page, i18n( "View Layout" ) );
	ilayout->setIcon( KIcon( "pmconfigureviewlayout" ) );
	ilayout->setHeader( i18n( "Display Settings for View layouts" ) );
	m_pages.push_back( PMRegisteredSettingsPage( ilayout, page ) );

#ifdef KPM_WITH_OBJECT_LIBRARY
	page = new PMObjectLibrarySettings( );
	KPageWidgetItem* ilibrary = addPage( page, i18n( "Object Library" ) );
	ilibrary->setIcon( KIcon( "pmconfigureobjectlibrary" ) );
	ilibrary->setHeader( i18n( "Display Settings for Texture Previews" ) );
	m_pages.push_back( PMRegisteredSettingsPage( ilibrary, page ) );
#endif

#ifdef KPM_WITH_PLUGINS
	page = new PMPluginSettings( );
	KPageWidgetItem* iplugins = addPage( page, i18n( "Plugins" ) );
	iplugins->setIcon( KIcon( "pmconfigureplugins" ) );
	iplugins->setHeader( i18n( "Plugin Settings" ) );
	m_pages.push_back( PMRegisteredSettingsPage( iplugins, page ) );
#endif

   displaySettings( );

   resize( s_size );
   connect(this,SIGNAL(okClicked()),this,SLOT(slotOk()));
   connect(this,SIGNAL(cancelClicked()),this,SLOT(slotCancel()));
   connect(this,SIGNAL(applyClicked()),this,SLOT(slotApply()));
   connect(this,SIGNAL(defaultClicked()),this,SLOT(slotDefault()));
}

void PMSettingsDialog::displaySettings( )
{
   QList<PMRegisteredSettingsPage>::const_iterator it;
   for( it = m_pages.constBegin( ); it != m_pages.constEnd( ); ++it )
      ( *it ).page->displaySettings( );
}

void PMSettingsDialog::slotCancel( )
{
   QDialog::reject( );
}

void PMSettingsDialog::slotApply( )
{
   if( validateData( ) )
      saveSettings( );
}

void PMSettingsDialog::slotOk( )
{
   if( validateData( ) )
   {
      saveSettings( );
      QDialog::accept( );
   }
}

void PMSettingsDialog::slotDefault( )
{
	KPageWidgetItem* current = currentPage();
   PMSettingsDialogPage* page = 0;
   QList<PMRegisteredSettingsPage>::const_iterator it;
   for( it = m_pages.constBegin( ); it != m_pages.constEnd( ) && !page; ++it )
      if( ( *it ).topPage == current )
         page = ( *it ).page;
   if( page )
      page->displayDefaults( );
}

bool PMSettingsDialog::validateData( )
{
   bool valid = true;
   QList<PMRegisteredSettingsPage>::const_iterator it;
   for( it = m_pages.constBegin( ); it != m_pages.constEnd( ) && valid; ++it )
      valid = ( *it ).page->validateData( );
   return valid;
}

void PMSettingsDialog::saveSettings( )
{
   m_repaint = false;

   QList<PMRegisteredSettingsPage>::const_iterator it;
   for( it = m_pages.constBegin( ); it != m_pages.constEnd( ); ++it )
      ( *it ).page->applySettings( );

   if( m_repaint )
   {
      PMRenderManager* rm = PMRenderManager::theManager( );
      rm->slotRenderingSettingsChanged( );
   }
}

void PMSettingsDialog::saveConfig( KConfig* cfg )
{
   KConfigGroup cfgcg( cfg, "Appearance" );
   cfgcg.writeEntry( "SettingsDialogSize", s_size );
}

void PMSettingsDialog::restoreConfig( KConfig* cfg )
{
   KConfigGroup cfgcg( cfg, "Appearance" );

   QSize defaultSize( 640, 400 );
   s_size = cfgcg.readEntry<QSize>( "SettingsDialogSize", defaultSize );
}

void PMSettingsDialog::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}

void PMSettingsDialog::slotRepaint( )
{
   m_repaint = true;
}

#include "pmsettingsdialog.moc"
