//Auto-generated by kalyptus. DO NOT EDIT.
namespace KIO {
    using Kimono;
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Text;
    /// <remarks> See <see cref="ISlaveSignals"></see> for signals emitted by Slave
    /// </remarks>
    [SmokeClass("KIO::Slave")]
    public class Slave : KIO.SlaveInterface {
        protected Slave(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Slave), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Slave() {
            staticInterceptor = new SmokeInvocation(typeof(Slave), null);
        }
        public Slave(string protocol, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Slave$#", "Slave(const QString&, QObject*)", typeof(void), typeof(string), protocol, typeof(QObject), parent);
        }
        public Slave(string protocol) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Slave$", "Slave(const QString&)", typeof(void), typeof(string), protocol);
        }
        public void SetPID(int arg1) {
            interceptor.Invoke("setPID$", "setPID(pid_t)", typeof(void), typeof(int), arg1);
        }
        public int Slave_pid() {
            return (int) interceptor.Invoke("slave_pid", "slave_pid()", typeof(int));
        }
        /// <remarks>
        ///  Force termination
        /// 	 </remarks>        <short>    Force termination 	 </short>
        public void Kill() {
            interceptor.Invoke("kill", "kill()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> true if the slave survived the last mission.
        ///          </return>
        ///         <short>   </short>
        public bool IsAlive() {
            return (bool) interceptor.Invoke("isAlive", "isAlive()", typeof(bool));
        }
        /// <remarks>
        ///  Set host for url
        /// <param> name="host" to connect to.
        /// </param><param> name="port" to connect to.
        /// </param><param> name="user" to login as
        /// </param><param> name="passwd" to login with
        ///          </param></remarks>        <short>    Set host for url </short>
        [SmokeMethod("setHost(const QString&, unsigned short, const QString&, const QString&)")]
        public virtual void SetHost(string host, ushort port, string user, string passwd) {
            interceptor.Invoke("setHost$$$$", "setHost(const QString&, unsigned short, const QString&, const QString&)", typeof(void), typeof(string), host, typeof(ushort), port, typeof(string), user, typeof(string), passwd);
        }
        /// <remarks>
        ///  Clear host info.
        ///          </remarks>        <short>    Clear host info.</short>
        public void ResetHost() {
            interceptor.Invoke("resetHost", "resetHost()", typeof(void));
        }
        /// <remarks>
        ///  Configure slave
        ///          </remarks>        <short>    Configure slave          </short>
        [SmokeMethod("setConfig(const KIO::MetaData&)")]
        public virtual void SetConfig(KIO.MetaData config) {
            interceptor.Invoke("setConfig#", "setConfig(const KIO::MetaData&)", typeof(void), typeof(KIO.MetaData), config);
        }
        /// <remarks>
        ///  The protocol this slave handles.
        /// </remarks>        <return> name of protocol handled by this slave, as seen by the user
        ///          </return>
        ///         <short>    The protocol this slave handles.</short>
        public string Protocol() {
            return (string) interceptor.Invoke("protocol", "protocol()", typeof(string));
        }
        public void SetProtocol(string protocol) {
            interceptor.Invoke("setProtocol$", "setProtocol(const QString&)", typeof(void), typeof(string), protocol);
        }
        /// <remarks>
        ///  The actual protocol used to handle the request.
        ///  This method will return a different protocol than
        ///  the one obtained by using protocol() if a
        ///  proxy-server is used for the given protocol.  This
        ///  usually means that this method will return "http"
        ///  when the actuall request was to retrieve a resource
        ///  from an "ftp" server by going through a proxy server.
        /// </remarks>        <return> the actual protocol (io-slave) that handled the request
        ///          </return>
        ///         <short>    The actual protocol used to handle the request.</short>
        public string SlaveProtocol() {
            return (string) interceptor.Invoke("slaveProtocol", "slaveProtocol()", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> Host this slave is (was?) connected to
        ///          </return>
        ///         <short>   </short>
        public string Host() {
            return (string) interceptor.Invoke("host", "host()", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> port this slave is (was?) connected to
        ///          </return>
        ///         <short>   </short>
        public ushort Port() {
            return (ushort) interceptor.Invoke("port", "port()", typeof(ushort));
        }
        /// <remarks>
        /// </remarks>        <return> User this slave is (was?) logged in as
        ///          </return>
        ///         <short>   </short>
        public string User() {
            return (string) interceptor.Invoke("user", "user()", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> Passwd used to log in
        ///          </return>
        ///         <short>   </short>
        public string Passwd() {
            return (string) interceptor.Invoke("passwd", "passwd()", typeof(string));
        }
        /// <remarks>
        ///  Suspends the operation of the attached kioslave.
        /// 	 </remarks>        <short>    Suspends the operation of the attached kioslave.</short>
        [SmokeMethod("suspend()")]
        public virtual void Suspend() {
            interceptor.Invoke("suspend", "suspend()", typeof(void));
        }
        /// <remarks>
        ///  Resumes the operation of the attached kioslave.
        /// 	 </remarks>        <short>    Resumes the operation of the attached kioslave.</short>
        [SmokeMethod("resume()")]
        public virtual void Resume() {
            interceptor.Invoke("resume", "resume()", typeof(void));
        }
        /// <remarks>
        ///  Tells whether the kioslave is suspended.
        /// </remarks>        <return> true if the kioslave is suspended.
        /// 	 </return>
        ///         <short>    Tells whether the kioslave is suspended.</short>
        [SmokeMethod("suspended()")]
        public virtual bool Suspended() {
            return (bool) interceptor.Invoke("suspended", "suspended()", typeof(bool));
        }
        /// <remarks>
        ///  Sends the given command to the kioslave.
        /// <param> name="cmd" command id
        /// </param><param> name="arr" byte array containing data
        /// 	 </param></remarks>        <short>    Sends the given command to the kioslave.</short>
        [SmokeMethod("send(int, const QByteArray&)")]
        public virtual void Send(int cmd, QByteArray arr) {
            interceptor.Invoke("send$#", "send(int, const QByteArray&)", typeof(void), typeof(int), cmd, typeof(QByteArray), arr);
        }
        [SmokeMethod("send(int)")]
        public virtual void Send(int cmd) {
            interceptor.Invoke("send$", "send(int)", typeof(void), typeof(int), cmd);
        }
        /// <remarks>
        ///  Puts the kioslave associated with <code>url</code> at halt, and return it to klauncher, in order
        ///  to let another application connect to it and finish the job.
        ///  This is for the krunner case: type a URL in krunner, it will start downloading
        ///  to find the mimetype (KRun), and then hold the slave, publish the held slave using,
        ///  this method, and the final application can continue the same download by requesting
        ///  the same URL.
        /// 	 </remarks>        <short>    Puts the kioslave associated with <code>url</code> at halt, and return it to klauncher, in order  to let another application connect to it and finish the job.</short>
        [SmokeMethod("hold(const KUrl&)")]
        public virtual void Hold(KUrl url) {
            interceptor.Invoke("hold#", "hold(const KUrl&)", typeof(void), typeof(KUrl), url);
        }
        /// <remarks>
        /// </remarks>        <return> The time this slave has been idle.
        /// 	 </return>
        ///         <short>   </short>
        public int IdleTime() {
            return (int) interceptor.Invoke("idleTime", "idleTime()", typeof(int));
        }
        /// <remarks>
        ///  Marks this slave as idle.
        /// 	 </remarks>        <short>    Marks this slave as idle.</short>
        public void SetIdle() {
            interceptor.Invoke("setIdle", "setIdle()", typeof(void));
        }
        public bool IsConnected() {
            return (bool) interceptor.Invoke("isConnected", "isConnected()", typeof(bool));
        }
        public void SetConnected(bool c) {
            interceptor.Invoke("setConnected$", "setConnected(bool)", typeof(void), typeof(bool), c);
        }
        public void Ref() {
            interceptor.Invoke("ref", "ref()", typeof(void));
        }
        public void Deref() {
            interceptor.Invoke("deref", "deref()", typeof(void));
        }
        [Q_SLOT("void accept()")]
        public void Accept() {
            interceptor.Invoke("accept", "accept()", typeof(void));
        }
        [Q_SLOT("void gotInput()")]
        public void GotInput() {
            interceptor.Invoke("gotInput", "gotInput()", typeof(void));
        }
        [Q_SLOT("void timeout()")]
        public void Timeout() {
            interceptor.Invoke("timeout", "timeout()", typeof(void));
        }
        /// <remarks>
        ///  Creates a new slave.
        /// <param> name="protocol" the protocol
        /// </param><param> name="url" is the url
        /// </param><param> name="error" is the error code on failure and undefined else.
        /// </param><param> name="error_text" is the error text on failure and undefined else.
        /// </param></remarks>        <return> 0 on failure, or a pointer to a slave otherwise.
        /// 	 </return>
        ///         <short>    Creates a new slave.</short>
        public static KIO.Slave CreateSlave(string protocol, KUrl url, ref int error, StringBuilder error_text) {
            StackItem[] stack = new StackItem[5];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(protocol);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(protocol);
#endif
#if DEBUG
            stack[2].s_class = (IntPtr) DebugGCHandle.Alloc(url);
#else
            stack[2].s_class = (IntPtr) GCHandle.Alloc(url);
#endif
            stack[3].s_int = error;
#if DEBUG
            stack[4].s_class = (IntPtr) DebugGCHandle.Alloc(error_text);
#else
            stack[4].s_class = (IntPtr) GCHandle.Alloc(error_text);
#endif
            staticInterceptor.Invoke("createSlave$#$$", "createSlave(const QString&, const KUrl&, int&, QString&)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).Free();
#endif
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[2].s_class);
#else
            ((GCHandle) stack[2].s_class).Free();
#endif
            error = stack[3].s_int;
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[4].s_class);
#else
            ((GCHandle) stack[4].s_class).Free();
#endif
            return (KIO.Slave) Enum.ToObject(typeof(KIO.Slave), stack[0].s_int);
        }
        /// <remarks>
        ///  Requests a slave on hold for ths url, from klauncher, if there is such a job.
        ///  See hold()
        /// 	 </remarks>        <short>    Requests a slave on hold for ths url, from klauncher, if there is such a job.</short>
        public static KIO.Slave HoldSlave(string protocol, KUrl url) {
            return (KIO.Slave) staticInterceptor.Invoke("holdSlave$#", "holdSlave(const QString&, const KUrl&)", typeof(KIO.Slave), typeof(string), protocol, typeof(KUrl), url);
        }
        protected new ISlaveSignals Emit {
            get { return (ISlaveSignals) Q_EMIT; }
        }
    }

    public interface ISlaveSignals : KIO.ISlaveInterfaceSignals {
        [Q_SIGNAL("void slaveDied(KIO::Slave*)")]
        void SlaveDied(KIO.Slave slave);
    }
}
