//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano.Server {
    using Soprano;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \class DBusExportIterator dbusexportiterator.h Soprano/Server/DBusExportIterator
    ///  \brief Exports a %Soprano Iterator via D-Bus.
    ///  The DBusExportIterator can be used to export a single iterator via
    ///  D-Bus. This may be useful in case one does not want to expose
    ///  the complete Model API but restrict access via custom methods
    ///  that return %Soprano Iterators.
    ///  The most common usage is probably as a fire-and-forget class:
    ///  <pre>
    ///  void myDbusMethod( QDBusMessage m ) {
    ///     Soprano.StatementIterator it = model.ListStatements();
    ///     Soprano.Server.DBusExportIterator dbusIt = new Soprano.Server.DBusExportIterator( it, this );
    ///     dbusIt.SetDeleteOnClose( true );
    ///     dbusIt.RegisterIterator( myFancyDBusObjectPath, m.service() );
    ///     return myFancyDBusObjectPath;
    ///  }
    ///  </pre>
    ///  This is a class for advanced usage. In most situations using
    ///  DBusExportModel or even ServerCore.RegisterAsDBusObject
    ///  is probably enough.
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///  \sa \ref soprano_server_dbus
    ///  \since 2.1
    ///          </remarks>        <short>    \class DBusExportIterator dbusexportiterator.</short>
    [SmokeClass("Soprano::Server::DBusExportIterator")]
    public class DBusExportIterator : QObject, Soprano.Error.IErrorCache, IDisposable {
        protected DBusExportIterator(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(DBusExportIterator), this);
        }
        // Error lastError(); >>>> NOT CONVERTED
        // void setError(const Error& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Create a new instance to export a StatementIterator
        ///              </remarks>        <short>    Create a new instance to export a StatementIterator              </short>
        public DBusExportIterator(Soprano.StatementIterator it, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DBusExportIterator##", "DBusExportIterator(Soprano::StatementIterator, QObject*)", typeof(void), typeof(Soprano.StatementIterator), it, typeof(QObject), parent);
        }
        public DBusExportIterator(Soprano.StatementIterator it) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DBusExportIterator#", "DBusExportIterator(Soprano::StatementIterator)", typeof(void), typeof(Soprano.StatementIterator), it);
        }
        /// <remarks>
        ///  Create a new instance to export a NodeIterator
        ///              </remarks>        <short>    Create a new instance to export a NodeIterator              </short>
        public DBusExportIterator(Soprano.NodeIterator it, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DBusExportIterator##", "DBusExportIterator(Soprano::NodeIterator, QObject*)", typeof(void), typeof(Soprano.NodeIterator), it, typeof(QObject), parent);
        }
        public DBusExportIterator(Soprano.NodeIterator it) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DBusExportIterator#", "DBusExportIterator(Soprano::NodeIterator)", typeof(void), typeof(Soprano.NodeIterator), it);
        }
        /// <remarks>
        ///  Create a new instance to export a QueryResultIterator
        ///              </remarks>        <short>    Create a new instance to export a QueryResultIterator              </short>
        public DBusExportIterator(Soprano.QueryResultIterator it, QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DBusExportIterator##", "DBusExportIterator(Soprano::QueryResultIterator, QObject*)", typeof(void), typeof(Soprano.QueryResultIterator), it, typeof(QObject), parent);
        }
        public DBusExportIterator(Soprano.QueryResultIterator it) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("DBusExportIterator#", "DBusExportIterator(Soprano::QueryResultIterator)", typeof(void), typeof(Soprano.QueryResultIterator), it);
        }
        /// <remarks>
        ///  \return The used StatementIterator or an invalid one if
        ///  this DBusExportIterator does not export a StatementIterator.
        ///              </remarks>        <short>    \return The used StatementIterator or an invalid one if  this DBusExportIterator does not export a StatementIterator.</short>
        public Soprano.StatementIterator StatementIterator() {
            return (Soprano.StatementIterator) interceptor.Invoke("statementIterator", "statementIterator() const", typeof(Soprano.StatementIterator));
        }
        /// <remarks>
        ///  \return The used NodeIterator or an invalid one if
        ///  this DBusExportIterator does not export a NodeIterator.
        ///              </remarks>        <short>    \return The used NodeIterator or an invalid one if  this DBusExportIterator does not export a NodeIterator.</short>
        public Soprano.NodeIterator NodeIterator() {
            return (Soprano.NodeIterator) interceptor.Invoke("nodeIterator", "nodeIterator() const", typeof(Soprano.NodeIterator));
        }
        /// <remarks>
        ///  \return The used QueryResultIterator or an invalid one if
        ///  this DBusExportIterator does not export a QueryResultIterator.
        ///              </remarks>        <short>    \return The used QueryResultIterator or an invalid one if  this DBusExportIterator does not export a QueryResultIterator.</short>
        public Soprano.QueryResultIterator QueryResultIterator() {
            return (Soprano.QueryResultIterator) interceptor.Invoke("queryResultIterator", "queryResultIterator() const", typeof(Soprano.QueryResultIterator));
        }
        /// <remarks>
        ///  The path this iterator is exported on.
        ///  This is an empty string if the iterator is not exported.
        ///              </remarks>        <short>    The path this iterator is exported on.</short>
        public string DbusObjectPath() {
            return (string) interceptor.Invoke("dbusObjectPath", "dbusObjectPath() const", typeof(string));
        }
        /// <remarks>
        ///  The DBusExportIterator instance can delete itself once the 
        ///  iterator is closed. The default value is false, i.e. 
        ///  the creator has to delete the instance.
        ///  \sa setDeleteOnClose, Iterator.Close
        ///              </remarks>        <short>    The DBusExportIterator instance can delete itself once the   iterator is closed.</short>
        public bool DeleteOnClose() {
            return (bool) interceptor.Invoke("deleteOnClose", "deleteOnClose() const", typeof(bool));
        }
        /// <remarks>
        ///  Set if the iterator should delete itself
        ///  once it has been closed. The default value is false,
        ///  i.e. the creator has to delete the instance.
        ///  \warning This only works if the iterator is closed
        ///  from the outside, i.e. by the D-Bus client.
        ///  \sa deleteOnClose
        ///              </remarks>        <short>    Set if the iterator should delete itself  once it has been closed.</short>
        [Q_SLOT("void setDeleteOnClose(bool)")]
        public void SetDeleteOnClose(bool deleteOnClose) {
            interceptor.Invoke("setDeleteOnClose$", "setDeleteOnClose(bool)", typeof(void), typeof(bool), deleteOnClose);
        }
        /// <remarks>
        ///  Register the iterator under the given D-Bus object path.
        ///  \sa QDBusConnection.RegisterObject
        ///  \param dbusObjectPath The D-Bus object path to register the iterator under.
        ///  \param dbusClient The optional D-Bus client which uses the iterator, i.e. which called
        ///  the method that triggered the creation of the iterator. If set, the iterator
        ///  will be closed once the client dies. In combination with setDeleteOnClose
        ///  this class can thus be used in a fire-and-forget manner.
        ///              </remarks>        <short>    Register the iterator under the given D-Bus object path.</short>
        [Q_SLOT("bool registerIterator(QString, QString)")]
        public bool RegisterIterator(string dbusObjectPath, string dbusClient) {
            return (bool) interceptor.Invoke("registerIterator$$", "registerIterator(const QString&, const QString&)", typeof(bool), typeof(string), dbusObjectPath, typeof(string), dbusClient);
        }
        [Q_SLOT("bool registerIterator(QString)")]
        public bool RegisterIterator(string dbusObjectPath) {
            return (bool) interceptor.Invoke("registerIterator$", "registerIterator(const QString&)", typeof(bool), typeof(string), dbusObjectPath);
        }
        /// <remarks>
        ///  Unregister the iterator from D-Bus.
        ///  \sa QDBusConnection.UnregisterObject
        ///              </remarks>        <short>    Unregister the iterator from D-Bus.</short>
        [Q_SLOT("void unregisterIterator()")]
        public void UnregisterIterator() {
            interceptor.Invoke("unregisterIterator", "unregisterIterator()", typeof(void));
        }
        ~DBusExportIterator() {
            interceptor.Invoke("~DBusExportIterator", "~DBusExportIterator()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~DBusExportIterator", "~DBusExportIterator()", typeof(void));
        }
        /// <remarks>
        ///  Get the last error that occured in the current thread.
        ///              </remarks>        <short>    Get the last error that occured in the current thread.</short>
        /// <remarks>
        ///  Reset the error for the current thread to no error.
        ///              </remarks>        <short>    Reset the error for the current thread to no error.</short>
        protected void ClearError() {
            interceptor.Invoke("clearError", "clearError() const", typeof(void));
        }
        /// <remarks>
        ///  Set the last occured error. This method is const to allow setting
        ///  of errors in all types of methods. The last error is as such a 
        ///  mutable property.
        ///              </remarks>        <short>    Set the last occured error.</short>
        /// <remarks>
        ///  Convenience method to set simple string error messages with a default
        ///  error code ErrorUnknown.
        ///              </remarks>        <short>    Convenience method to set simple string error messages with a default  error code ErrorUnknown.</short>
        protected void SetError(string errorMessage, int code) {
            interceptor.Invoke("setError$$", "setError(const QString&, int) const", typeof(void), typeof(string), errorMessage, typeof(int), code);
        }
        protected void SetError(string errorMessage) {
            interceptor.Invoke("setError$", "setError(const QString&) const", typeof(void), typeof(string), errorMessage);
        }
        protected new IDBusExportIteratorSignals Emit {
            get { return (IDBusExportIteratorSignals) Q_EMIT; }
        }
    }

    public interface IDBusExportIteratorSignals : IQObjectSignals {
    }
}
