//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    /// <remarks>
    ///  Applies effects to icons.
    ///  This class applies effects to icons depending on their state and
    ///  group. For example, it can be used to make all disabled icons
    ///  in a toolbar gray.
    /// </remarks>        <short>    Applies effects to icons.</short>
    ///         <see> KIcon</see>
    [SmokeClass("KIconEffect")]
    public class KIconEffect : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KIconEffect(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KIconEffect), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static KIconEffect() {
            staticInterceptor = new SmokeInvocation(typeof(KIconEffect), null);
        }
        /// <remarks>
        ///  This is the enumeration of all possible icon effects.
        ///  Note that 'LastEffect' is no valid icon effect but only
        ///  used internally to check for invalid icon effects.
        /// 
        /// <li>
        /// NoEffect: Don't apply any icon effect
        /// </li>
        /// 
        /// <li>
        /// ToGray: Tints the icon gray
        /// </li>
        /// 
        /// <li>
        /// Colorize: Tints the icon with an other color
        /// </li>
        /// 
        /// <li>
        /// ToGamma: Change the gamma value of the icon
        /// </li>
        /// 
        /// <li>
        /// DeSaturate: Reduce the saturation of the icon
        /// </li>
        /// 
        /// <li>
        /// ToMonochrome: Produces a monochrome icon
        ///      
        /// </li></remarks>        <short>    This is the enumeration of all possible icon effects.</short>
        public enum Effects {
            NoEffect = 0,
            ToGray = 1,
            Colorize = 2,
            ToGamma = 3,
            DeSaturate = 4,
            ToMonochrome = 5,
            LastEffect = 6,
        }
        /// <remarks>
        ///  Create a new KIconEffect.
        ///    </remarks>        <short>    Create a new KIconEffect.</short>
        public KIconEffect() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KIconEffect", "KIconEffect()", typeof(void));
        }
        /// <remarks>
        ///  Rereads configuration.
        ///      </remarks>        <short>    Rereads configuration.</short>
        public void Init() {
            interceptor.Invoke("init", "init()", typeof(void));
        }
        /// <remarks>
        ///  Tests whether an effect has been configured for the given icon group.
        /// <param> name="group" the group to check, see KIconLoader.Group
        /// </param><param> name="state" the state to check, see KIconLoader.States
        /// </param></remarks>        <return> true if an effect is configured for the given <code>group</code>
        ///  in <code>state</code>, otherwise false.
        /// </return>
        ///         <short>    Tests whether an effect has been configured for the given icon group.</short>
        ///         <see> KIconLoader.Group</see>
        ///         <see> KIconLoader.States</see>
        public bool HasEffect(int group, int state) {
            return (bool) interceptor.Invoke("hasEffect$$", "hasEffect(int, int) const", typeof(bool), typeof(int), group, typeof(int), state);
        }
        /// <remarks>
        ///  Returns a fingerprint for the effect by encoding
        ///  the given <code>group</code> and <code>state</code> into a string. This
        ///  is useful for caching.
        /// <param> name="group" the group, see KIconLoader.Group
        /// </param><param> name="state" the state, see KIconLoader.States
        /// </param></remarks>        <return> the fingerprint of the given <code>group</code>+<code>state</code>
        ///      </return>
        ///         <short>    Returns a fingerprint for the effect by encoding  the given <code>group</code> and <code>state</code> into a string.</short>
        public string Fingerprint(int group, int state) {
            return (string) interceptor.Invoke("fingerprint$$", "fingerprint(int, int) const", typeof(string), typeof(int), group, typeof(int), state);
        }
        /// <remarks>
        ///  Applies an effect to an image. The effect to apply depends on the
        ///  <code>group</code> and <code>state</code> parameters, and is configured by the user.
        /// <param> name="src" The image.
        /// </param><param> name="group" The group for the icon, see KIconLoader.Group
        /// </param><param> name="state" The icon's state, see KIconLoader.States
        /// </param></remarks>        <return> An image with the effect applied.
        ///      </return>
        ///         <short>    Applies an effect to an image.</short>
        public QImage Apply(QImage src, int group, int state) {
            return (QImage) interceptor.Invoke("apply#$$", "apply(const QImage&, int, int) const", typeof(QImage), typeof(QImage), src, typeof(int), group, typeof(int), state);
        }
        /// <remarks>
        ///  Applies an effect to an image.
        /// <param> name="src" The image.
        /// </param><param> name="effect" The effect to apply, one of KIconEffect.Effects.
        /// </param><param> name="value" Strength of the effect. 0 <= <code>value</code> <= 1.
        /// </param><param> name="rgb" Color parameter for effects that need one.
        /// </param><param> name="trans" Add Transparency if trans = true.
        /// </param></remarks>        <return> An image with the effect applied.
        ///      </return>
        ///         <short>    Applies an effect to an image.</short>
        public QImage Apply(QImage src, int effect, float value, QColor rgb, bool trans) {
            return (QImage) interceptor.Invoke("apply#$$#$", "apply(const QImage&, int, float, const QColor&, bool) const", typeof(QImage), typeof(QImage), src, typeof(int), effect, typeof(float), value, typeof(QColor), rgb, typeof(bool), trans);
        }
        public QImage Apply(QImage src, int effect, float value, QColor rgb, QColor rgb2, bool trans) {
            return (QImage) interceptor.Invoke("apply#$$##$", "apply(const QImage&, int, float, const QColor&, const QColor&, bool) const", typeof(QImage), typeof(QImage), src, typeof(int), effect, typeof(float), value, typeof(QColor), rgb, typeof(QColor), rgb2, typeof(bool), trans);
        }
        /// <remarks>
        ///  Applies an effect to a pixmap.
        /// <param> name="src" The pixmap.
        /// </param><param> name="group" The group for the icon, see KIconLoader.Group
        /// </param><param> name="state" The icon's state, see KIconLoader.States
        /// </param></remarks>        <return> A pixmap with the effect applied.
        ///      </return>
        ///         <short>    Applies an effect to a pixmap.</short>
        public QPixmap Apply(QPixmap src, int group, int state) {
            return (QPixmap) interceptor.Invoke("apply#$$", "apply(const QPixmap&, int, int) const", typeof(QPixmap), typeof(QPixmap), src, typeof(int), group, typeof(int), state);
        }
        /// <remarks>
        ///  Applies an effect to a pixmap.
        /// <param> name="src" The pixmap.
        /// </param><param> name="effect" The effect to apply, one of KIconEffect.Effects.
        /// </param><param> name="value" Strength of the effect. 0 <= <code>value</code> <= 1.
        /// </param><param> name="rgb" Color parameter for effects that need one.
        /// </param><param> name="trans" Add Transparency if trans = true.
        /// </param></remarks>        <return> A pixmap with the effect applied.
        ///      </return>
        ///         <short>    Applies an effect to a pixmap.</short>
        public QPixmap Apply(QPixmap src, int effect, float value, QColor rgb, bool trans) {
            return (QPixmap) interceptor.Invoke("apply#$$#$", "apply(const QPixmap&, int, float, const QColor&, bool) const", typeof(QPixmap), typeof(QPixmap), src, typeof(int), effect, typeof(float), value, typeof(QColor), rgb, typeof(bool), trans);
        }
        public QPixmap Apply(QPixmap src, int effect, float value, QColor rgb, QColor rgb2, bool trans) {
            return (QPixmap) interceptor.Invoke("apply#$$##$", "apply(const QPixmap&, int, float, const QColor&, const QColor&, bool) const", typeof(QPixmap), typeof(QPixmap), src, typeof(int), effect, typeof(float), value, typeof(QColor), rgb, typeof(QColor), rgb2, typeof(bool), trans);
        }
        /// <remarks>
        ///  Returns an image twice as large, consisting of 2x2 pixels.
        /// <param> name="src" the image.
        /// </param></remarks>        <return> the scaled image.
        ///      </return>
        ///         <short>    Returns an image twice as large, consisting of 2x2 pixels.</short>
        public QImage DoublePixels(QImage src) {
            return (QImage) interceptor.Invoke("doublePixels#", "doublePixels(const QImage&) const", typeof(QImage), typeof(QImage), src);
        }
        ~KIconEffect() {
            interceptor.Invoke("~KIconEffect", "~KIconEffect()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KIconEffect", "~KIconEffect()", typeof(void));
        }
        /// <remarks>
        ///  Tints an image gray.
        /// <param> name="image" The image
        /// </param><param> name="value" Strength of the effect. 0 <= <code>value</code> <= 1
        ///      </param></remarks>        <short>    Tints an image gray.</short>
        public static void ToGray(QImage image, float value) {
            staticInterceptor.Invoke("toGray#$", "toGray(QImage&, float)", typeof(void), typeof(QImage), image, typeof(float), value);
        }
        /// <remarks>
        ///  Colorizes an image with a specific color.
        /// <param> name="image" The image
        /// </param><param> name="col" The color with which the <code>image</code> is tinted
        /// </param><param> name="value" Strength of the effect. 0 <= <code>value</code> <= 1
        ///      </param></remarks>        <short>    Colorizes an image with a specific color.</short>
        public static void Colorize(QImage image, QColor col, float value) {
            staticInterceptor.Invoke("colorize##$", "colorize(QImage&, const QColor&, float)", typeof(void), typeof(QImage), image, typeof(QColor), col, typeof(float), value);
        }
        /// <remarks>
        ///  Produces a monochrome icon with a given foreground and background color
        /// <param> name="image" The image
        /// </param><param> name="white" The color with which the white parts of <code>image</code> are painted
        /// </param><param> name="black" The color with which the black parts of <code>image</code> are painted
        /// </param><param> name="value" Strength of the effect. 0 <= <code>value</code> <= 1
        ///      </param></remarks>        <short>    Produces a monochrome icon with a given foreground and background color </short>
        public static void ToMonochrome(QImage image, QColor black, QColor white, float value) {
            staticInterceptor.Invoke("toMonochrome###$", "toMonochrome(QImage&, const QColor&, const QColor&, float)", typeof(void), typeof(QImage), image, typeof(QColor), black, typeof(QColor), white, typeof(float), value);
        }
        /// <remarks>
        ///  Desaturates an image.
        /// <param> name="image" The image
        /// </param><param> name="value" Strength of the effect. 0 <= <code>value</code> <= 1
        ///      </param></remarks>        <short>    Desaturates an image.</short>
        public static void DeSaturate(QImage image, float value) {
            staticInterceptor.Invoke("deSaturate#$", "deSaturate(QImage&, float)", typeof(void), typeof(QImage), image, typeof(float), value);
        }
        /// <remarks>
        ///  Changes the gamma value of an image.
        /// <param> name="image" The image
        /// </param><param> name="value" Strength of the effect. 0 <= <code>value</code> <= 1
        ///      </param></remarks>        <short>    Changes the gamma value of an image.</short>
        public static void ToGamma(QImage image, float value) {
            staticInterceptor.Invoke("toGamma#$", "toGamma(QImage&, float)", typeof(void), typeof(QImage), image, typeof(float), value);
        }
        /// <remarks>
        ///  Renders an image semi-transparent.
        /// <param> name="image" The image
        ///      </param></remarks>        <short>    Renders an image semi-transparent.</short>
        public static void SemiTransparent(QImage image) {
            staticInterceptor.Invoke("semiTransparent#", "semiTransparent(QImage&)", typeof(void), typeof(QImage), image);
        }
        /// <remarks>
        ///  Renders a pixmap semi-transparent.
        /// <param> name="pixmap" The pixmap
        ///      </param></remarks>        <short>    Renders a pixmap semi-transparent.</short>
        public static void SemiTransparent(QPixmap pixmap) {
            staticInterceptor.Invoke("semiTransparent#", "semiTransparent(QPixmap&)", typeof(void), typeof(QPixmap), pixmap);
        }
        /// <remarks>
        ///  Overlays an image with an other image.
        /// <param> name="src" The image
        /// </param><param> name="overlay" The image to overlay <code>src</code> with
        ///      </param></remarks>        <short>    Overlays an image with an other image.</short>
        public static void Overlay(QImage src, QImage overlay) {
            staticInterceptor.Invoke("overlay##", "overlay(QImage&, QImage&)", typeof(void), typeof(QImage), src, typeof(QImage), overlay);
        }
    }
}
