/*
 * feedsettingswidget.cpp
 *
 * Copyright (c) 2007 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef FEEDSETTINGSWIDGET_H
#define FEEDSETTINGSWIDGET_H

#include "ui_feedsettings.h"

#include <QWidget>

class KProgressDialog;
class QListWidgetItem;

class FeedSettingsWidget : public QWidget
{
    Q_OBJECT
public:
    FeedSettingsWidget( QWidget *parent );

    QStringList feedUrls() const;

private Q_SLOTS:
    void feedItemChanged();
    void addButtonClicked();
    void removeButtonClicked();
    void feedLoaded( const QUrl &url );

private:
    Ui::FeedSettings ui;
    KProgressDialog *m_downloadMessageBox;
    QString m_addedFeedUrl;
};

#endif // !defined(FEEDSETTINGSWIDGET_H)

