//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  The Constraint enumeration lists the various constraints that Plasma
    ///  objects have managed for them and which they may wish to react to,
    ///  for instance in Applet.ConstraintsUpdated
    ///  </remarks>        <short>    The Constraint enumeration lists the various constraints that Plasma  objects have managed for them and which they may wish to react to,  for instance in Applet.ConstraintsUpdated  </short>
    public enum Constraint {
        NoConstraint = 0,
        FormFactorConstraint = 1,
        LocationConstraint = 2,
        ScreenConstraint = 4,
        SizeConstraint = 8,
        ImmutableConstraint = 16,
        StartupCompletedConstraint = 32,
        AllConstraints = FormFactorConstraint|LocationConstraint|ScreenConstraint|SizeConstraint|ImmutableConstraint,
    }
    /// <remarks>
    ///  The FormFactor enumeration describes how a Plasma.Applet should arrange
    ///  itself. The value is derived from the container managing the Applet
    ///  (e.g. in Plasma, a Corona on the desktop or on a panel).
    /// </remarks>        <short>    The FormFactor enumeration describes how a Plasma.Applet should arrange  itself.</short>
    public enum FormFactor {
        Planar = 0,
        MediaCenter = 1,
        Horizontal = 2,
        Vertical = 3,
    }
    /// <remarks>
    ///  The Direction enumeration describes in which direction, relative to the
    ///  Applet (and its managing container), popup menus, expanders, balloons,
    ///  message boxes, arrows and other such visually associated widgets should
    ///  appear in. This is usually the oposite of the Location.
    /// </remarks>        <short>    The Direction enumeration describes in which direction, relative to the  Applet (and its managing container), popup menus, expanders, balloons,  message boxes, arrows and other such visually associated widgets should  appear in.</short>
    public enum Direction {
        Down = 0,
        Up = 1,
        Left = 2,
        Right = 3,
    }
    /// <remarks>
    ///  The direction of a zoom action.
    ///  </remarks>        <short>    The direction of a zoom action.</short>
    public enum ZoomDirection {
        ZoomIn = 0,
        ZoomOut = 1,
    }
    /// <remarks>
    ///  The Location enumeration describes where on screen an element, such as an
    ///  Applet or its managing container, is positioned on the screen.
    /// </remarks>        <short>    The Location enumeration describes where on screen an element, such as an  Applet or its managing container, is positioned on the screen.</short>
    public enum Location {
        Floating = 0,
        Desktop = 1,
        FullScreen = 2,
        TopEdge = 3,
        BottomEdge = 4,
        LeftEdge = 5,
        RightEdge = 6,
    }
    /// <remarks>
    ///  The position enumeration
    /// </remarks>        <short>    The position enumeration </short>
    public enum Position {
        LeftPositioned = 0,
        RightPositioned = 1,
        TopPositioned = 2,
        BottomPositioned = 3,
        CenterPositioned = 4,
    }
    /// <remarks>
    ///  Flip enumeration
    ///  </remarks>        <short>    Flip enumeration  </short>
    public enum FlipDirection {
        NoFlip = 0,
        HorizontalFlip = 1,
        VerticalFlip = 2,
    }
    /// <remarks>
    ///  Zoom levels that Plasma is aware of...
    /// </remarks>        <short>    Zoom levels that Plasma is aware of.</short>
    public enum ZoomLevel {
        DesktopZoom = 0,
        GroupZoom = 1,
        OverviewZoom = 2,
    }
    /// <remarks>
    ///  Possible timing alignments
    /// </remarks>        <short>    Possible timing alignments </short>
    public enum IntervalAlignment {
        NoAlignment = 0,
        AlignToMinute = 1,
        AlignToHour = 2,
    }
    public enum ItemTypes {
        AppletType = QGraphicsItem.UserType+1,
        LineEditType = QGraphicsItem.UserType+2,
    }
    /// <remarks>
    ///  Defines the immutability of items like applets, corona and containments
    ///  they can be free to modify, locked down by the user or locked down by the system (e.g. kiosk setups)
    ///  </remarks>        <short>    Defines the immutability of items like applets, corona and containments  they can be free to modify, locked down by the user or locked down by the system (e.</short>
    public enum ImmutabilityType {
        Mutable = 1,
        UserImmutable = 2,
        SystemImmutable = 4,
    }
    /// <remarks>
    ///  Defines the aspect ratio used when scaling an applet
    ///  </remarks>        <short>    Defines the aspect ratio used when scaling an applet  </short>
    public enum AspectRatioMode {
        IgnoreAspectRatio = 0,
        KeepAspectRatio = 1,
        Square = 2,
        ConstrainedSquare = 3,
    }
    /// <remarks>
    ///  The ComonentType enumeration refers to the various types of components,
    ///  or plugins, supported by plasma.
    ///  </remarks>        <short>    The ComonentType enumeration refers to the various types of components,  or plugins, supported by plasma.</short>
    public enum ComponentType {
        AppletComponent = 1,
        DataEngineComponent = 2,
        RunnerComponent = 4,
        AnimatorComponent = 8,
        ContainmentComponent = 16,
    }
    public enum MarginEdge {
        TopMargin = 0,
        BottomMargin = 1,
        LeftMargin = 2,
        RightMargin = 3,
    }
    /// <remarks>
    ///  This class provides a generic Icon for the Plasma desktop. An icon, in this
    ///  sense, is not restricted to just an image, but can also contain text. Currently,
    ///  the Icon class is primarily used for desktop items, but is designed to be used
    ///  anywhere an icon is needed in an applet.
    /// </remarks>        <author> Matt Broadstone <mbroadst@gmail.com>
    ///  </author>
    ///         <short>    This class provides a generic Icon for the Plasma desktop.</short>
    [SmokeClass("Plasma")]
    public class Global {
        private static SmokeInvocation staticInterceptor = null;
        static Global() {
            staticInterceptor = new SmokeInvocation(typeof(Global), null);
        }
        /// <remarks>
        /// </remarks>        <return> the scaling factor (0..1) for a ZoomLevel
        /// </return>
        ///         <short>   </short>
        public static double ScalingFactor(Plasma.ZoomLevel level) {
            return (double) staticInterceptor.Invoke("scalingFactor$", "scalingFactor(Plasma::ZoomLevel)", typeof(double), typeof(Plasma.ZoomLevel), level);
        }
        /// <remarks>
        ///  Converts a location to a direction. Handy for figuring out which way to send a popup based on
        ///  location or to point arrows and other directional items.
        /// <param> name="location" the location of the container the element will appear in
        ///  @reutrn the visual direction of the element should be oriented in
        /// </param></remarks>        <short>    Converts a location to a direction.</short>
        public static Plasma.Direction LocationToDirection(Plasma.Location location) {
            return (Plasma.Direction) staticInterceptor.Invoke("locationToDirection$", "locationToDirection(Plasma::Location)", typeof(Plasma.Direction), typeof(Plasma.Location), location);
        }
        /// <remarks>
        ///  @arg types a set of ComponentTypes flags for which to look up the
        ///             language support for
        /// </remarks>        <return> a list of all supported languages for the given type(s).
        /// </return>
        ///         <short>    @arg types a set of ComponentTypes flags for which to look up the             language support for </short>
        public static List<string> KnownLanguages(uint types) {
            return (List<string>) staticInterceptor.Invoke("knownLanguages$", "knownLanguages(Plasma::ComponentTypes)", typeof(List<string>), typeof(uint), types);
        }
        /// <remarks>
        ///  Loads an Applet script engine for the given language.
        /// <param> name="language" the language to load for
        /// </param><param> name="applet" the Plasma.Applet for this script
        /// </param></remarks>        <return> pointer to the AppletScript or 0 on failure; the caller is responsible
        ///          for the return object which will be parented to the Applet
        /// </return>
        ///         <short>    Loads an Applet script engine for the given language.</short>
        public static Plasma.AppletScript LoadScriptEngine(string language, Plasma.Applet applet) {
            return (Plasma.AppletScript) staticInterceptor.Invoke("loadScriptEngine$#", "loadScriptEngine(const QString&, Plasma::Applet*)", typeof(Plasma.AppletScript), typeof(string), language, typeof(Plasma.Applet), applet);
        }
        /// <remarks>
        ///  Loads an DataEngine script engine for the given language.
        /// <param> name="language" the language to load for
        /// </param><param> name="dataEngine" the Plasma.DataEngine for this script;
        /// </param></remarks>        <return> pointer to the DataEngineScript or 0 on failure; the caller is responsible
        ///          for the return object which will be parented to the DataEngine
        /// </return>
        ///         <short>    Loads an DataEngine script engine for the given language.</short>
        public static Plasma.DataEngineScript LoadScriptEngine(string language, Plasma.DataEngine dataEngine) {
            return (Plasma.DataEngineScript) staticInterceptor.Invoke("loadScriptEngine$#", "loadScriptEngine(const QString&, Plasma::DataEngine*)", typeof(Plasma.DataEngineScript), typeof(string), language, typeof(Plasma.DataEngine), dataEngine);
        }
        /// <remarks>
        ///  Loads an Applet script engine for the given language.
        /// <param> name="language" the language to load for
        /// </param><param> name="runner" the Plasma.AbstractRunner for this script
        /// </param></remarks>        <return> pointer to the RunnerScript or 0 on failure; the caller is responsible
        ///          for the return object which will be parented to the AbstractRunner
        /// </return>
        ///         <short>    Loads an Applet script engine for the given language.</short>
        public static Plasma.RunnerScript LoadScriptEngine(string language, Plasma.AbstractRunner runner) {
            return (Plasma.RunnerScript) staticInterceptor.Invoke("loadScriptEngine$#", "loadScriptEngine(const QString&, Plasma::AbstractRunner*)", typeof(Plasma.RunnerScript), typeof(string), language, typeof(Plasma.AbstractRunner), runner);
        }
        /// <remarks>
        ///  Loads an appropriate PackageStructure for the given language and type
        /// <param> name="langauge" the language to load the PackageStructure for
        /// </param><param> name="type" the component type
        /// </param></remarks>        <return> a guarded PackageStructure pointer
        ///  </return>
        ///         <short>    Loads an appropriate PackageStructure for the given language and type </short>
        public static Plasma.PackageStructure PackageStructure(string language, Plasma.ComponentType type) {
            return (Plasma.PackageStructure) staticInterceptor.Invoke("packageStructure$$", "packageStructure(const QString&, Plasma::ComponentType)", typeof(Plasma.PackageStructure), typeof(string), language, typeof(Plasma.ComponentType), type);
        }
    }
}
