/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Sep 1 2003
 */

#include "cppheaderclassdeclarationblock.h"
#include "cppcodegenerator.h"
#include "cppcodegenerationpolicy.h"
#include "cppcodedocumentation.h"
#include "../model_utils.h"
#include "../uml.h"

// Constructors/Destructors
//

CPPHeaderClassDeclarationBlock::CPPHeaderClassDeclarationBlock ( CPPHeaderCodeDocument * parentDoc, const QString &startText, const QString &endText, const QString &comment)
        : OwnedHierarchicalCodeBlock((UMLObject*) parentDoc->getParentClassifier(), (CodeDocument*)parentDoc, startText, endText, comment)
{
    init(parentDoc, comment);
}

CPPHeaderClassDeclarationBlock::~CPPHeaderClassDeclarationBlock ( ) { }

//
// Methods
//

/**
 * load params from the appropriate XMI element node.
 */
void CPPHeaderClassDeclarationBlock::loadFromXMI ( QDomElement & root )
{
    setAttributesFromNode(root);
}

/** set the class attributes from a passed object
 */
void CPPHeaderClassDeclarationBlock::setAttributesFromObject (TextBlock * obj)
{
    HierarchicalCodeBlock::setAttributesFromObject(obj);
}

/**
 * Save the XMI representation of this object
 */
void CPPHeaderClassDeclarationBlock::saveToXMI ( QDomDocument & doc, QDomElement & root ) {
    QDomElement blockElement = doc.createElement( "cppheaderclassdeclarationblock" );

    setAttributesOnNode(doc, blockElement);

    root.appendChild( blockElement );
}

// Accessor methods
//

// Other methods
//

/**
 * update the start and end text for this hierarchicalcodeblock.
 */
void CPPHeaderClassDeclarationBlock::updateContent ( )
{

    CPPHeaderCodeDocument *parentDoc = (CPPHeaderCodeDocument*)getParentDocument();
    UMLClassifier *c = parentDoc->getParentClassifier();
    QString endLine = UMLApp::app()->getCommonPolicy()->getNewLineEndingChars();
    bool isInterface = parentDoc->parentIsInterface(); // a little shortcut
    QString CPPHeaderClassName = CodeGenerator::cleanName(c->getName());
    bool forceDoc = UMLApp::app()->getCommonPolicy()->getCodeVerboseDocumentComments();

    // COMMENT

    //check if class is abstract.. it should have abstract methods
    if(!isInterface && c->getAbstract() && !c->hasAbstractOps())
    {
        getComment()->setText("******************************* Abstract Class ****************************"+endLine
                              +CPPHeaderClassName+" does not have any pure virtual methods, but its author"+endLine
                              +"  defined it as an abstract class, so you should not use it directly."+endLine
                              +"  Inherit from it instead and create only objects from the derived classes"+endLine
                              +"*****************************************************************************");
    } else {
        if(isInterface)
            getComment()->setText("Interface "+CPPHeaderClassName+endLine+c->getDoc());
        else
            getComment()->setText("Class "+CPPHeaderClassName+endLine+c->getDoc());
    }

    if(forceDoc || !c->getDoc().isEmpty())
        getComment()->setWriteOutText(true);
    else
        getComment()->setWriteOutText(false);


    // Now set START/ENDING Text
    QString startText = "";

    /*
    */

    /*
        if(parentDoc->parentIsInterface())
                startText.append("interface ");
        else
    */
    startText.append("class ");

    startText.append(CPPHeaderClassName);

    // write inheritances out
    UMLClassifierList superclasses = c->findSuperClassConcepts();
    int nrof_superclasses = superclasses.count();

    // write out inheritance
    int i = 0;
    if(nrof_superclasses >0)
        startText.append(" : ");
    for (UMLClassifier * concept= superclasses.first(); concept; concept = superclasses.next())
    {
        startText.append(concept->getVisibility().toString() + ' ' +
                         CodeGenerator::cleanName(concept->getName()));
        if(i != (nrof_superclasses-1))
            startText.append(", ");
        i++;
    }

    // Set the header and end text for the hier.codeblock
    setStartText(startText+" {");

    // setEndText("}"); // not needed

}

void CPPHeaderClassDeclarationBlock::init (CPPHeaderCodeDocument *parentDoc, const QString &comment)
{

    setComment(new CPPCodeDocumentation(parentDoc));
    getComment()->setText(comment);

    setEndText("};");

    updateContent();

}


#include "cppheaderclassdeclarationblock.moc"
