package org.kde.koala;
import org.kde.qt.*;
import java.util.ArrayList;

/** {@link BrowserExtension} emits these signals */
public interface BrowserExtensionSignals {

/** 
 Tell the hosting browser that the part opened a new URL (which can be
 queried via {@link KParts#Part}.url().

 This helps the browser to update/create an entry in the history.
 The part may <em>not</em> emit this signal together with {@link BrowserExtension#openURLRequest}.
 Emit {@link BrowserExtension#openURLRequest} if you want the browser to handle a URL the user
 asked to open (from within your part/document). This signal however is
 useful if you want to handle URLs all yourself internally, while still
 telling the hosting browser about new opened URLs, in order to provide
 a proper history functionality to the user.
 An example of usage is a html rendering component which wants to emit
 this signal when a child frame document changed its URL.
 Conclusion: you probably want to use {@link BrowserExtension#openURLRequest} instead
   
*/
	void openURLNotify();

/** 
 Enable or disable a standard action held by the browser.

 See class documentation for the list of standard actions.
   
*/
	void enableAction( String name, boolean enabled );
	void destroyed();

/** 
 URL of an icon for the currently displayed page
   
*/
	void setIconURL( KURL url );

/** 
 Inform the hosting application about the current selection.
 Used when a set of URLs is selected.
   
*/
	void selectionInfo( ArrayList urls );
	void infoMessage( String arg1 );

/** 
 This signal is emitted when openURLRequest is called, after a 0-seconds timer.
 This allows the caller to terminate what it's doing first, before (usually)
 being destroyed. Parts should never use this signal, hosts should only connect
 to this signal.
   
*/
	void openURLRequestDelayed( KURL url, int arg1 );

/** 
 Emit this to make the browser show a standard popup menu
 at the point <code>global</code> for the given <code>url.</code>

 Give as much information
 about this URL as possible, like the <code>mimeType</code> and the file type
 (<code>mode</code>: S_IFREG, S_IFDIR...)
 The GUI described by <code>client</code> is being merged with the popupmenu of the host
   
*/
//	void popupMenu( KXMLGUIClientInterface client, QPoint global, KURL url, String mimeType, mode_t mode = (mode_t)-1 arg1 );

/** 

*/
	void speedProgress( int bytesPerSecond );

/** 
 Ask the hosting browser to open a new window for the given <code>url</code>
 and return a reference to the content part.
 The request for a reference to the part is only fullfilled/processed
 if the serviceType is set in the <code>args</code> . (otherwise the request cannot be
 processed synchroniously.
   
*/
	void createNewWindow( KURL url, URLArgs args, int windowArgs, int part );

/** 
 Ask the host (browser) to open <code>url</code>
 To set a reload, the x and y offsets, the service type etc., fill in the
 appropriate fields in the <code>args</code> structure.
 Hosts should not connect to this signal but to {@link openURLRequestDelayed}.
   
*/
	void openURLRequest( KURL url, int arg1 );

/** 
 Since the part emits the jobid in the {@link BrowserExtension#started} signal,
 progress information is automatically displayed.

 However, if you don't use a {@link KIO#Job} in the part,
 you can use {@link BrowserExtension#loadingProgress} and {@link BrowserExtension#speedProgress}
 to display progress information.
   
*/
	void loadingProgress( int percent );

/** 
 Update the URL shown in the browser's location bar to <code>url.</code>
   
*/
	void setLocationBarURL( String url );
}

