/* This file is part of the KDE libraries
   Copyright (C) 2001 Kurt Granroth <granroth@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef __plugin_babelfish_h
#define __plugin_babelfish_h

#include <kparts/plugin.h>
#include <klibloader.h>

class KURL;

class PluginBabelFish : public KParts::Plugin
{
  Q_OBJECT
public:
  PluginBabelFish( QObject* parent = 0, const char* name = 0 );
  virtual ~PluginBabelFish();

  void translateURL( const QString& lang );

public slots:
  void slotTranslateEN_FR();
  void slotTranslateEN_DE();
  void slotTranslateEN_IT();
  void slotTranslateEN_PT();
  void slotTranslateEN_ES();
  void slotTranslateFR_EN();
  void slotTranslateDE_EN();
  void slotTranslateIT_EN();
  void slotTranslatePT_EN();
  void slotTranslateES_EN();
  void slotTranslateRU_EN();
  void slotTranslateDE_FR();
  void slotTranslateFR_DE();
};

class BabelFishFactory : public KLibFactory
{
  Q_OBJECT
public:
  BabelFishFactory();
  virtual ~BabelFishFactory();

  virtual QObject* createObject( QObject* parent = 0, const char* pname = 0, const char* name = "QObject", const QStringList &args = QStringList() );

  static KInstance *instance();

private:
  static KInstance* s_instance;
};

#endif
