
#include "plugin_katehelloworld.h"
#include "plugin_katehelloworld.moc"

#include <kaction.h>
#include <klocale.h>
#include <kstddirs.h>

extern "C"
{
  void* init_libkatehelloworldplugin()
  {
    KGlobal::locale()->insertCatalogue("katehelloworld"); 
    return new KatePluginFactory;
  }
}

KatePluginFactory::KatePluginFactory()
{
  s_instance = new KInstance( "kate" );
}

KatePluginFactory::~KatePluginFactory()
{
  delete s_instance;
}

QObject* KatePluginFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
  return new KatePluginHelloWorld( parent, name );
}

KInstance* KatePluginFactory::s_instance = 0L;

KatePluginHelloWorld::KatePluginHelloWorld( QObject* parent, const char* name )
    : Kate::Plugin ( parent, name )
{
}

KatePluginHelloWorld::~KatePluginHelloWorld()
{
}

Kate::PluginView *KatePluginHelloWorld::createView (Kate::MainWindow *win)
{
   Kate::PluginView *view = new Kate::PluginView (this, win);

  (void) new KAction ( i18n("Insert Hello World"), 0, this,
                      SLOT( slotInsertHello() ), view->actionCollection(),
                      "edit_insert_helloworld" );

   view->setXML( "plugins/katehelloworld/ui.rc" );

   return view;
}

void KatePluginHelloWorld::slotInsertHello()
{
  Kate::View *kv = myApp->getViewManager()->getActiveView();

  if (kv)
    kv->insertText ("Hello World");
}
