/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class TotemProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN1 = new PatternBuilder().text("$$").number("xx").number("(d+)|").expression("(..)").text("$GPRMC,").number("(dd)(dd)(dd).d+,").expression("([AV]),").number("(d+)(dd.d+),([NS]),").number("(d+)(dd.d+),([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(dd)(dd)(dd)").expression("[^*]*").text("*").number("xx|").number("(d+.d+)|").number("(d+.d+)|").number("(d+.d+)|").number("(d+)|").number("d+|").number("d").number("(ddd)").number("(dddd)|").number("(d+)|").optional().number("x*(xxxx)").number("(xxxx)|").number("(d+)|").number("(d+.d+)|").number("d+|").any().number("xxxx").any().compile();
    private static final Pattern PATTERN2 = new PatternBuilder().text("$$").number("xx").number("(d+)|").expression("(..)").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)|").expression("([AV])|").number("(d+)(dd.d+)|").expression("([NS])|").number("(d+)(dd.d+)|").expression("([EW])|").number("(d+.d+)?|").number("(d+)?|").number("(d+.d+)|").number("(d+)|").number("d").number("(dd)").number("(dd)|").number("(d+)|").number("(xxxx)").number("(xxxx)|").number("(d+)|").number("(d+.d+)|").number("d+|").number("xxxx").any().compile();
    private static final Pattern PATTERN3 = new PatternBuilder().text("$$").number("xx").number("(d+)|").expression("(..)").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").number("(xxxx)").expression("[01]").number("(dd)").number("(dd)").number("(dddd)").number("(dddd)").number("(ddd)").number("(ddd)").number("(xxxx)").number("(xxxx)").expression("([AV])").number("(dd)").number("(ddd)").number("(ddd)").number("(dd.d)").number("(d{7})").number("(dd)(dd.dddd)([NS])").number("(ddd)(dd.dddd)([EW])").number("dddd").number("xxxx").any().compile();
    private static final Pattern PATTERN4 = new PatternBuilder().text("$$").number("dddd").number("(xx)").number("(d+)|").number("(x{8})").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").number("(dd)").number("(dd)").number("(dddd)").groupBegin().groupBegin().number("(dddd)").number("(dddd)").number("(dddd)").groupEnd("?").number("(dddd)").number("(dddd)?").groupEnd("?").number("(xxxx)").number("(xxxx)").groupBegin().number("(dd)").number("(ddd)").groupEnd("?").number("(dd)").number("(dd)").number("(ddd)").number("(ddd)").number("(dd.d)").number("(d{7})").number("(dd)(dd.dddd)([NS])").number("(ddd)(dd.dddd)([EW])").number("dddd").number("xx").any().compile();
    private static final Pattern PATTERN_OBD = new PatternBuilder().text("$$").number("dddd").number("xx").number("(d+)|").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("(-?d+.d+),").number("(-?d+.d+),").expression("[^,]*,").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("|xx").any().compile();

    public TotemProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm123(int value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 16: {
                return "lowBattery";
            }
            case 17: {
                return "overspeed";
            }
            case 48: {
                return "parking";
            }
            case 66: {
                return "geofenceExit";
            }
            case 67: {
                return "geofenceEnter";
            }
        }
        return null;
    }

    private String decodeAlarm4(int value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 2: {
                return "overspeed";
            }
            case 4: {
                return "geofenceExit";
            }
            case 5: {
                return "geofenceEnter";
            }
            case 64: {
                return "shock";
            }
            case 66: {
                return "hardAcceleration";
            }
            case 67: {
                return "hardBraking";
            }
        }
        return null;
    }

    private boolean decode12(Position position, Parser parser, Pattern pattern) {
        if (parser.hasNext()) {
            position.set("alarm", this.decodeAlarm123(Short.parseShort(parser.next(), 16)));
        }
        DateBuilder dateBuilder = new DateBuilder();
        int year = 0;
        int month = 0;
        int day = 0;
        if (pattern == PATTERN2) {
            day = parser.nextInt(0);
            month = parser.nextInt(0);
            year = parser.nextInt(0);
        }
        dateBuilder.setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.setSpeed(parser.nextDouble(0.0));
        position.setCourse(parser.nextDouble(0.0));
        if (pattern == PATTERN1) {
            day = parser.nextInt(0);
            month = parser.nextInt(0);
            year = parser.nextInt(0);
        }
        if (year == 0) {
            return false;
        }
        dateBuilder.setDate(year, month, day);
        position.setTime(dateBuilder.getDate());
        if (pattern == PATTERN1) {
            position.set("pdop", parser.nextDouble());
            position.set("hdop", parser.nextDouble());
            position.set("vdop", parser.nextDouble());
        } else {
            position.set("hdop", parser.nextDouble());
        }
        int io = parser.nextBinInt();
        position.set("status", io);
        if (pattern == PATTERN1) {
            position.set("alarm", BitUtil.check(io, 0) ? "sos" : null);
            position.set("in3", BitUtil.check(io, 4));
            position.set("in4", BitUtil.check(io, 5));
            position.set("in1", BitUtil.check(io, 6));
            position.set("in2", BitUtil.check(io, 7));
            position.set("out1", BitUtil.check(io, 8));
            position.set("out2", BitUtil.check(io, 9));
            position.set("battery", parser.nextDouble(0.0) * 0.01);
        } else {
            int i;
            position.set("antenna", BitUtil.check(io, 0));
            position.set("charge", BitUtil.check(io, 1));
            for (i = 1; i <= 6; ++i) {
                position.set("in" + i, BitUtil.check(io, 1 + i));
            }
            for (i = 1; i <= 4; ++i) {
                position.set("out" + i, BitUtil.check(io, 7 + i));
            }
            position.set("battery", parser.nextDouble(0.0) * 0.1);
        }
        position.set("power", parser.nextDouble(0.0));
        position.set("adc1", parser.next());
        int lac = parser.nextHexInt(0);
        int cid = parser.nextHexInt(0);
        if (lac != 0 && cid != 0) {
            position.setNetwork(new Network(CellTower.fromLacCid(lac, cid)));
        }
        position.set("temp1", parser.next());
        position.set("odometer", parser.nextDouble(0.0) * 1000.0);
        return true;
    }

    private boolean decode3(Position position, Parser parser) {
        if (parser.hasNext()) {
            position.set("alarm", this.decodeAlarm123(Short.parseShort(parser.next(), 16)));
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.set("io1", parser.next());
        position.set("battery", parser.nextDouble(0.0) * 0.1);
        position.set("power", parser.nextDouble(0.0));
        position.set("adc1", parser.next());
        position.set("adc2", parser.next());
        position.set("temp1", parser.next());
        position.set("temp2", parser.next());
        position.setNetwork(new Network(CellTower.fromLacCid(parser.nextHexInt(0), parser.nextHexInt(0))));
        position.setValid(parser.next().equals("A"));
        position.set("sat", parser.nextInt());
        position.setCourse(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        position.set("pdop", parser.nextDouble());
        position.set("odometer", parser.nextInt(0) * 1000);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        return true;
    }

    private boolean decode4(Position position, Parser parser) {
        CellTower cellTower;
        long status = parser.nextHexLong();
        position.set("alarm", BitUtil.check(status, 31) ? "sos" : null);
        position.set("ignition", BitUtil.check(status, 30));
        position.set("alarm", BitUtil.check(status, 29) ? "overspeed" : null);
        position.set("charge", BitUtil.check(status, 28));
        position.set("alarm", BitUtil.check(status, 27) ? "geofenceExit" : null);
        position.set("alarm", BitUtil.check(status, 26) ? "geofenceEnter" : null);
        position.set("out1", BitUtil.check(status, 23));
        position.set("out2", BitUtil.check(status, 22));
        position.set("out3", BitUtil.check(status, 21));
        position.set("out4", BitUtil.check(status, 20));
        position.set("in2", BitUtil.check(status, 19));
        position.set("in3", BitUtil.check(status, 18));
        position.set("in4", BitUtil.check(status, 17));
        position.set("alarm", BitUtil.check(status, 16) ? "shock" : null);
        position.set("alarm", BitUtil.check(status, 14) ? "lowBattery" : null);
        position.set("alarm", BitUtil.check(status, 10) ? "jamming" : null);
        position.setTime(parser.nextDateTime());
        position.set("battery", parser.nextDouble() * 0.1);
        position.set("power", parser.nextDouble());
        position.set("adc1", parser.next());
        position.set("adc2", parser.next());
        position.set("adc3", parser.next());
        position.set("adc4", parser.next());
        position.set("temp1", parser.next());
        if (parser.hasNext()) {
            position.set("temp2", parser.next());
            position.setValid(BitUtil.check(status, 12));
        } else {
            position.setValid(BitUtil.check(status, 14));
        }
        int lac = parser.nextHexInt();
        int cid = parser.nextHexInt();
        if (parser.hasNext(2)) {
            int mnc = parser.nextInt();
            int mcc = parser.nextInt();
            cellTower = CellTower.from(mcc, mnc, lac, cid);
        } else {
            cellTower = CellTower.fromLacCid(lac, cid);
        }
        position.set("sat", parser.nextInt());
        cellTower.setSignalStrength(parser.nextInt());
        position.setNetwork(new Network(cellTower));
        position.setCourse(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble()));
        position.set("hdop", parser.nextDouble());
        position.set("odometer", parser.nextInt() * 1000);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        return true;
    }

    private boolean decodeObd(Position position, Parser parser) {
        position.setValid(true);
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.set("odometer", parser.nextLong());
        position.set("fuelUsed", parser.nextInt());
        position.set("fuelConsumption", parser.nextInt());
        position.set("power", (double)parser.nextInt().intValue() * 0.001);
        position.set("rpm", parser.nextInt());
        position.set("obdSpeed", parser.nextInt());
        parser.nextInt();
        parser.nextInt();
        position.set("coolantTemp", parser.nextInt());
        position.set("intakeTemp", parser.nextInt());
        position.set("engineLoad", parser.nextInt());
        position.set("throttle", parser.nextInt());
        position.set("fuel", parser.nextInt());
        return true;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        DeviceSession deviceSession;
        String sentence = (String)msg;
        Pattern pattern = PATTERN3;
        if (sentence.contains("$Cloud")) {
            pattern = PATTERN_OBD;
        } else if (sentence.charAt(2) == '0') {
            pattern = PATTERN4;
        } else if (sentence.contains("$GPRMC")) {
            pattern = PATTERN1;
        } else {
            int index = sentence.indexOf(124);
            if (index != -1 && sentence.indexOf(124, index + 1) != -1) {
                pattern = PATTERN2;
            }
        }
        Parser parser = new Parser(pattern, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        String type = null;
        if (pattern == PATTERN4) {
            type = parser.next();
            position.set("alarm", this.decodeAlarm4(Integer.parseInt(type, 16)));
        }
        if ((deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next())) == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        boolean result = pattern == PATTERN1 || pattern == PATTERN2 ? this.decode12(position, parser, pattern) : (pattern == PATTERN3 ? this.decode3(position, parser) : (pattern == PATTERN4 ? this.decode4(position, parser) : this.decodeObd(position, parser)));
        if (channel != null) {
            if (type != null) {
                String response = "$$0014" + type + sentence.substring(sentence.length() - 6, sentence.length() - 2);
                response = response + String.format("%02X", Checksum.xor(response)).toUpperCase();
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            } else {
                channel.writeAndFlush((Object)new NetworkMessage("ACK OK\r\n", remoteAddress));
            }
        }
        return result ? position : null;
    }
}

