/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler.extension;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.HKDFAlgorithm;
import de.rub.nds.tlsattacker.core.crypto.HKDFunction;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PWDProtectExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.PWDProtectExtensionParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.PWDProtectExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.PWDProtectExtensionSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.util.Arrays;
import javax.crypto.IllegalBlockSizeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.cryptomator.siv.SivMode;
import org.cryptomator.siv.UnauthenticCiphertextException;

public class PWDProtectExtensionHandler
extends ExtensionHandler<PWDProtectExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public PWDProtectExtensionHandler(TlsContext context) {
        super(context);
    }

    @Override
    public PWDProtectExtensionParser getParser(byte[] message, int pointer) {
        return new PWDProtectExtensionParser(pointer, message);
    }

    public PWDProtectExtensionPreparator getPreparator(PWDProtectExtensionMessage message) {
        return new PWDProtectExtensionPreparator(this.context.getChooser(), message, this.getSerializer(message));
    }

    public PWDProtectExtensionSerializer getSerializer(PWDProtectExtensionMessage message) {
        return new PWDProtectExtensionSerializer(message);
    }

    @Override
    public void adjustTLSExtensionContext(PWDProtectExtensionMessage message) {
        HKDFAlgorithm hkdfAlgorithm;
        if (this.context.getChooser().getConnectionEndType() == ConnectionEndType.CLIENT) {
            this.context.setClientPWDUsername(this.context.getConfig().getDefaultClientPWDUsername());
            return;
        }
        ECCurve curve = ECNamedCurveTable.getParameterSpec((String)this.context.getConfig().getDefaultPWDProtectGroup().getJavaName()).getCurve();
        BigInteger prime = curve.getField().getCharacteristic();
        if (curve.getFieldSize() <= 256) {
            hkdfAlgorithm = HKDFAlgorithm.TLS_HKDF_SHA256;
        } else if (curve.getFieldSize() <= 384) {
            hkdfAlgorithm = HKDFAlgorithm.TLS_HKDF_SHA384;
        } else {
            LOGGER.warn("Missing HKDF algorithm for curves larger than 384 bits");
            return;
        }
        byte[] protectedUsername = (byte[])message.getUsername().getValue();
        BigInteger clientPublicKeyX = new BigInteger(1, Arrays.copyOfRange(protectedUsername, 0, curve.getFieldSize() / 8));
        BigInteger clientPublicKeyYSquared = clientPublicKeyX.pow(3).add(clientPublicKeyX.multiply(curve.getA().toBigInteger())).add(curve.getB().toBigInteger()).mod(prime);
        BigInteger clientPublicKeyY = clientPublicKeyYSquared.modPow(prime.add(BigInteger.ONE).shiftRight(2), prime);
        ECPoint clientPublicKey = curve.createPoint(clientPublicKeyX, clientPublicKeyY);
        BigInteger sharedSecret = clientPublicKey.multiply(this.context.getConfig().getDefaultServerPWDProtectPrivateKey()).normalize().getXCoord().toBigInteger();
        try {
            byte[] key = HKDFunction.expand(hkdfAlgorithm, HKDFunction.extract(hkdfAlgorithm, null, ArrayConverter.bigIntegerToByteArray((BigInteger)sharedSecret)), new byte[0], curve.getFieldSize() / 8);
            byte[] ctrKey = Arrays.copyOfRange(key, 0, key.length / 2);
            byte[] macKey = Arrays.copyOfRange(key, key.length / 2, key.length);
            byte[] encryptedUsername = Arrays.copyOfRange(protectedUsername, curve.getFieldSize() / 8, protectedUsername.length);
            SivMode AES_SIV = new SivMode();
            String username = new String(AES_SIV.decrypt(ctrKey, macKey, encryptedUsername, (byte[][])new byte[0][]));
            this.context.setClientPWDUsername(username);
            LOGGER.debug("Username: " + this.context.getClientPWDUsername());
        }
        catch (CryptoException | IllegalBlockSizeException | UnauthenticCiphertextException e) {
            LOGGER.warn("Failed to decrypt username: " + e.getMessage());
        }
    }
}

