/*
 * Decompiled with CFR 0.152.
 */
package tr.view.actions.screens.columns;

import java.util.Comparator;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.table.TableCellRenderer;
import org.openide.util.NbBundle;
import tr.swing.StyledDate;
import tr.swing.StyledString;
import tr.swing.StyledStringRenderer;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.view.actions.screens.ComparatorActionDate;
import tr.view.actions.screens.ComparatorDefault;
import tr.view.actions.screens.ComparatorDueDate;
import tr.view.actions.screens.ComparatorFollowupDate;
import tr.view.actions.screens.ComparatorIcon;
import tr.view.actions.screens.ComparatorScheduleDate;
import tr.view.actions.screens.ComparatorValues;
import tr.view.actions.screens.ValueIDsProviderEnergy;
import tr.view.actions.screens.ValueIDsProviderPriority;
import tr.view.actions.screens.ValueIDsProviderTime;

public class ActionsColumn
extends ObservableImpl {
    private static final Logger LOG = Logger.getLogger("tr.view.actions");
    public static final byte INDEX_ICON = 0;
    public static final byte INDEX_DONE = 1;
    public static final byte INDEX_DESCR = 2;
    public static final byte INDEX_DELEGATED_TO = 3;
    public static final byte INDEX_CREATED_DATE = 4;
    public static final byte INDEX_DONE_DATE = 5;
    public static final byte INDEX_ACTION_DATE = 6;
    public static final byte INDEX_CONTEXT = 7;
    public static final byte INDEX_TIME = 8;
    public static final byte INDEX_ENERGY = 9;
    public static final byte INDEX_PRIORITY = 10;
    public static final byte INDEX_TOPIC = 11;
    public static final byte INDEX_FROM_ICON = 12;
    public static final byte INDEX_FROM_DESCR = 13;
    public static final byte INDEX_FROM_TOPIC = 14;
    public static final byte INDEX_START_DATE = 15;
    public static final byte INDEX_DUE_DATE = 16;
    public static final byte INDEX_FOLLOWUP_DATE = 17;
    public static final byte INDEX_SCHEDULE_DATE = 18;
    public static final byte INDEX_SCHEDULE_DURATION = 19;
    public static final byte INDEX_PROJECT_PATH = 20;
    public static final byte INDEX_TOP_PROJECT = 21;
    public static final byte[] COLUMN_INDICES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    private static final String[] COLUMN_IDS = new String[]{"icon", "done", "descr", "delegated-to", "created-date", "done-date", "action-date", "context", "time", "energy", "priority", "topic", "from-icon", "from-descr", "from-topic", "start-date", "due-date", "followup-date", "schedule-date", "schedule-duration", "project-path", "top-project"};
    private static final Class[] CLASSES = new Class[]{Icon.class, Boolean.class, StyledString.class, StyledString.class, StyledDate.class, StyledDate.class, StyledDate.class, StyledString.class, StyledString.class, StyledString.class, StyledString.class, StyledString.class, Icon.class, StyledString.class, StyledString.class, StyledDate.class, StyledDate.class, StyledDate.class, StyledDate.class, StyledString.class, StyledString.class, StyledString.class};
    private static final Comparator[] COMPARATORS = new Comparator[]{new ComparatorIcon(), new ComparatorDefault(), new ComparatorDefault(), new ComparatorDefault(), new ComparatorDefault(), new ComparatorDefault(), new ComparatorActionDate(), new ComparatorDefault(), new ComparatorValues(ValueIDsProviderTime.instance), new ComparatorValues(ValueIDsProviderEnergy.instance), new ComparatorValues(ValueIDsProviderPriority.instance), new ComparatorDefault(), new ComparatorIcon(), new ComparatorDefault(), new ComparatorDefault(), new ComparatorDefault(), new ComparatorDueDate(), new ComparatorFollowupDate(), new ComparatorScheduleDate(), null, new ComparatorDefault(), new ComparatorDefault()};
    private static final boolean[] RESIZABLE = new boolean[]{false, false, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true};
    private static final boolean[] DEFAULT_VISIBLE = new boolean[]{false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
    private static final int MAX_WIDTH = Integer.MAX_VALUE;
    private static final int MIN_WIDTH = 1;
    private static final int[] PRE_WIDTHS = new int[]{17, 17, 150, 150, 150, 150, 150, 150, 150, 150, 150, 150, 17, 150, 150, 150, 150, 150, 150, 150, 150, 150};
    private static final int[] MIN_WIDTHS = new int[]{17, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] MAX_WIDTHS = new int[]{17, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private byte index;
    private boolean visible;
    private int width;

    public static ActionsColumn createColumn(byte index) {
        return new ActionsColumn(index);
    }

    private ActionsColumn(byte index) {
        this.index = index;
        this.visible = DEFAULT_VISIBLE[index];
        this.width = this.getPreferredWidth();
    }

    public final byte getColumnIndex() {
        return this.index;
    }

    public final String getColumnID() {
        return COLUMN_IDS[this.index];
    }

    public static final String getColumnID(byte index) {
        return COLUMN_IDS[index];
    }

    public String toString() {
        return this.getName();
    }

    public String getColumnName() {
        if (CLASSES[this.index] == Icon.class || CLASSES[this.index] == Boolean.class) {
            return "";
        }
        return this.getName();
    }

    public String getName() {
        try {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)COLUMN_IDS[this.index]);
        }
        catch (Exception ex) {
            return COLUMN_IDS[this.index];
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.notifyObservers((Observable)this);
        }
    }

    public Class getColumnClass() {
        return CLASSES[this.index];
    }

    public Comparator getColumnComparator() {
        return COMPARATORS[this.index];
    }

    public boolean isResizable() {
        return RESIZABLE[this.index];
    }

    public int getMaximumWidth() {
        return MAX_WIDTHS[this.index] > 0 ? MAX_WIDTHS[this.index] : Integer.MAX_VALUE;
    }

    public int getMinimumWidth() {
        return MIN_WIDTHS[this.index] > 0 ? MIN_WIDTHS[this.index] : 1;
    }

    public int getPreferredWidth() {
        return PRE_WIDTHS[this.index] > 0 ? PRE_WIDTHS[this.index] : this.getMinimumWidth();
    }

    public int getWidth() {
        if (this.isResizable()) {
            return this.width;
        }
        return this.getPreferredWidth();
    }

    public void setWidth(int width) {
        if (this.isResizable() && this.width != width) {
            this.width = width;
            this.notifyObservers((Observable)this);
        }
    }

    public TableCellRenderer getRenderer() {
        if (CLASSES[this.index] == StyledString.class || CLASSES[this.index] == StyledDate.class) {
            return new StyledStringRenderer();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ActionsColumn)) {
            return false;
        }
        ActionsColumn column = (ActionsColumn)((Object)object);
        if (this.index != column.index) {
            return false;
        }
        if (this.visible != column.visible) {
            return false;
        }
        return this.width == column.width;
    }
}

