/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBeans;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;

public class ValuesReduceRule
extends RelRule<Config>
implements TransformationRule {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    protected ValuesReduceRule(Config config) {
        super(config);
        Util.discard(LOGGER);
    }

    @Deprecated
    public ValuesReduceRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String desc) {
        this(Config.EMPTY.withRelBuilderFactory(relBuilderFactory).withDescription(desc).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
        throw new IllegalArgumentException("cannot guess matchHandler");
    }

    private static void matchProjectFilter(ValuesReduceRule rule, RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalFilter filter = (LogicalFilter)call.rel(1);
        LogicalValues values = (LogicalValues)call.rel(2);
        rule.apply(call, project, filter, values);
    }

    private static void matchProject(ValuesReduceRule rule, RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalValues values = (LogicalValues)call.rel(1);
        rule.apply(call, project, null, values);
    }

    private static void matchFilter(ValuesReduceRule rule, RelOptRuleCall call) {
        LogicalFilter filter = (LogicalFilter)call.rel(0);
        LogicalValues values = (LogicalValues)call.rel(1);
        rule.apply(call, null, filter, values);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ((Config)this.config).matchHandler().accept(this, call);
    }

    protected void apply(RelOptRuleCall call, @Nullable LogicalProject project, @Nullable LogicalFilter filter, LogicalValues values) {
        assert (values != null);
        assert (filter != null || project != null);
        RexNode conditionExpr = filter == null ? null : filter.getCondition();
        List<RexNode> projectExprs = project == null ? null : project.getProjects();
        RexBuilder rexBuilder = values.getCluster().getRexBuilder();
        ArrayList<RexNode> reducibleExps = new ArrayList<RexNode>();
        MyRexShuttle shuttle = new MyRexShuttle();
        for (List literalList : values.getTuples()) {
            shuttle.literalList = literalList;
            if (conditionExpr != null) {
                RexNode c = conditionExpr.accept(shuttle);
                reducibleExps.add(c);
            }
            if (projectExprs == null) continue;
            Objects.requireNonNull(project, "project");
            int k = -1;
            for (RexNode projectExpr : projectExprs) {
                ++k;
                RexNode e = projectExpr.accept(shuttle);
                if (RexLiteral.isNullLiteral(e)) {
                    e = rexBuilder.makeAbstractCast(project.getRowType().getFieldList().get(k).getType(), e);
                }
                reducibleExps.add(e);
            }
        }
        int fieldsPerRow = (conditionExpr == null ? 0 : 1) + (projectExprs == null ? 0 : projectExprs.size());
        assert (fieldsPerRow > 0);
        assert (reducibleExps.size() == values.getTuples().size() * fieldsPerRow);
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        ReduceExpressionsRule.reduceExpressions(values, reducibleExps, predicates, false, true);
        int changeCount = 0;
        ImmutableList.Builder tuplesBuilder = ImmutableList.builder();
        for (int row = 0; row < values.getTuples().size(); ++row) {
            ImmutableList valuesList;
            int i = 0;
            if (conditionExpr != null) {
                RexNode reducedValue = (RexNode)reducibleExps.get(row * fieldsPerRow + i);
                ++i;
                if (!reducedValue.isAlwaysTrue()) {
                    ++changeCount;
                    continue;
                }
            }
            if (projectExprs != null) {
                ++changeCount;
                ImmutableList.Builder tupleBuilder = ImmutableList.builder();
                while (i < fieldsPerRow) {
                    RexNode reducedValue = (RexNode)reducibleExps.get(row * fieldsPerRow + i);
                    if (reducedValue instanceof RexLiteral) {
                        tupleBuilder.add((Object)((RexLiteral)reducedValue));
                    } else if (RexUtil.isNullLiteral(reducedValue, true)) {
                        tupleBuilder.add((Object)rexBuilder.makeNullLiteral(reducedValue.getType()));
                    } else {
                        return;
                    }
                    ++i;
                }
                valuesList = tupleBuilder.build();
            } else {
                valuesList = (ImmutableList)values.getTuples().get(row);
            }
            tuplesBuilder.add((Object)valuesList);
        }
        if (changeCount > 0) {
            RelDataType rowType = projectExprs != null ? Objects.requireNonNull(project, "project").getRowType() : values.getRowType();
            LogicalValues newRel = LogicalValues.create(values.getCluster(), rowType, (ImmutableList<ImmutableList<RexLiteral>>)tuplesBuilder.build());
            call.transformTo(newRel);
        } else {
            call.transformTo(values);
        }
        if (filter != null) {
            call.getPlanner().prune(filter);
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config FILTER = EMPTY.withDescription("ValuesReduceRule(Filter)").withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(LogicalValues.class).predicate(Values::isNotEmpty).noInputs())).as(Config.class).withMatchHandler((x$0, x$1) -> ValuesReduceRule.access$400(x$0, x$1));
        public static final Config PROJECT = EMPTY.withDescription("ValuesReduceRule(Project)").withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(LogicalValues.class).predicate(Values::isNotEmpty).noInputs())).as(Config.class).withMatchHandler((x$0, x$1) -> ValuesReduceRule.access$300(x$0, x$1));
        public static final Config PROJECT_FILTER = EMPTY.withDescription("ValuesReduceRule(Project-Filter)").withOperandSupplier(b0 -> b0.operand(LogicalProject.class).oneInput(b1 -> b1.operand(LogicalFilter.class).oneInput(b2 -> b2.operand(LogicalValues.class).predicate(Values::isNotEmpty).noInputs()))).as(Config.class).withMatchHandler((x$0, x$1) -> ValuesReduceRule.access$200(x$0, x$1));

        @Override
        default public ValuesReduceRule toRule() {
            return new ValuesReduceRule(this);
        }

        @ImmutableBeans.Property
        public <R extends RelOptRule> RelRule.MatchHandler<R> matchHandler();

        public <R extends RelOptRule> Config withMatchHandler(RelRule.MatchHandler<R> var1);

        default public Config withOperandFor(Class<? extends RelNode> relClass) {
            return this.withOperandSupplier(b -> b.operand(relClass).anyInputs()).as(Config.class);
        }
    }

    private static class MyRexShuttle
    extends RexShuttle {
        private @Nullable List<RexLiteral> literalList;

        private MyRexShuttle() {
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            Objects.requireNonNull(this.literalList, "literalList");
            return this.literalList.get(inputRef.getIndex());
        }
    }
}

