/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.LSBRadixSorter;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SortedIntDocSet;

public final class DocSetBuilder {
    private final int maxDoc;
    private final int threshold;
    private int[] buffer;
    private int pos;
    private FixedBitSet bitSet;

    public DocSetBuilder(int maxDoc, long costEst) {
        this.maxDoc = maxDoc;
        this.threshold = (maxDoc >>> 7) + 4;
        if (costEst > (long)this.threshold) {
            this.bitSet = new FixedBitSet(maxDoc);
        } else {
            this.buffer = new int[Math.max((int)costEst, 1)];
        }
    }

    private void upgradeToBitSet() {
        assert (this.bitSet == null);
        this.bitSet = new FixedBitSet(this.maxDoc);
        for (int i = 0; i < this.pos; ++i) {
            this.bitSet.set(this.buffer[i]);
        }
        this.buffer = null;
        this.pos = 0;
    }

    private void growBuffer(int minSize) {
        int newSize;
        if (minSize < this.buffer.length) {
            return;
        }
        for (newSize = this.buffer.length; newSize < minSize; newSize <<= 1) {
        }
        newSize = Math.min(newSize, this.threshold);
        int[] newBuffer = new int[newSize];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.pos);
        this.buffer = newBuffer;
    }

    public void add(DocIdSetIterator iter, int base) throws IOException {
        this.grow((int)Math.min(Integer.MAX_VALUE, iter.cost()));
        if (this.bitSet != null) {
            DocSetBuilder.add(this.bitSet, iter, base);
        } else {
            while (true) {
                for (int i = this.pos; i < this.buffer.length; ++i) {
                    int doc = iter.nextDoc();
                    if (doc == Integer.MAX_VALUE) {
                        this.pos = i;
                        return;
                    }
                    this.buffer[i] = doc + base;
                }
                this.pos = this.buffer.length;
                if (this.pos + 1 >= this.threshold) break;
                this.growBuffer(this.pos + 1);
            }
            this.upgradeToBitSet();
            DocSetBuilder.add(this.bitSet, iter, base);
        }
    }

    public static void add(FixedBitSet bitSet, DocIdSetIterator iter, int base) throws IOException {
        int doc = iter.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            bitSet.set(doc + base);
            doc = iter.nextDoc();
        }
    }

    public int add(TermsEnum te, int base) throws IOException {
        BytesRef term;
        PostingsEnum postings = null;
        int termCount = 0;
        while ((term = te.next()) != null) {
            ++termCount;
            postings = te.postings(postings, 0);
            this.add((DocIdSetIterator)postings, base);
        }
        return termCount;
    }

    public void grow(int numDocs) {
        if (this.bitSet == null) {
            long newLength = this.pos + numDocs;
            if (newLength < (long)this.threshold) {
                this.growBuffer((int)newLength);
            } else {
                this.upgradeToBitSet();
            }
        }
    }

    public void add(int doc) {
        if (this.bitSet != null) {
            this.bitSet.set(doc);
        } else {
            if (this.pos >= this.buffer.length) {
                if (this.pos + 1 >= this.threshold) {
                    this.upgradeToBitSet();
                    this.bitSet.set(doc);
                    return;
                }
                this.growBuffer(this.pos + 1);
            }
            this.buffer[this.pos++] = doc;
        }
    }

    private static int dedup(int[] arr, int length, FixedBitSet acceptDocs) {
        int pos = 0;
        int previous = -1;
        for (int i = 0; i < length; ++i) {
            int value = arr[i];
            if (value == previous || acceptDocs != null && !acceptDocs.get(value)) continue;
            arr[pos++] = value;
            previous = value;
        }
        return pos;
    }

    public DocSet build(FixedBitSet filter) {
        if (this.bitSet != null) {
            if (filter != null) {
                this.bitSet.and(filter);
            }
            return new BitDocSet(this.bitSet);
        }
        LSBRadixSorter sorter = new LSBRadixSorter();
        sorter.sort(PackedInts.bitsRequired((long)(this.maxDoc - 1)), this.buffer, this.pos);
        int l = DocSetBuilder.dedup(this.buffer, this.pos, filter);
        assert (l <= this.pos);
        return new SortedIntDocSet(this.buffer, l);
    }

    public DocSet buildUniqueInOrder(FixedBitSet filter) {
        if (this.bitSet != null) {
            if (filter != null) {
                this.bitSet.and(filter);
            }
            return new BitDocSet(this.bitSet);
        }
        int l = this.pos;
        if (filter != null) {
            l = DocSetBuilder.dedup(this.buffer, this.pos, filter);
        }
        return new SortedIntDocSet(this.buffer, l);
    }
}

