/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.apache.commons.exec.OS;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SolrPaths {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Set<String> loggedOnce = new ConcurrentSkipListSet<String>();

    private SolrPaths() {
    }

    @Deprecated
    public static Path locateSolrHome() {
        String prop;
        String home = null;
        try {
            InitialContext c = new InitialContext();
            home = (String)c.lookup("java:comp/env/solr/home");
            SolrPaths.logOnceInfo("home_using_jndi", "Using JNDI solr.home: " + home);
        }
        catch (NoInitialContextException e) {
            log.debug("JNDI not configured for solr (NoInitialContextEx)");
        }
        catch (NamingException e) {
            log.debug("No /solr/home in JNDI");
        }
        catch (RuntimeException ex) {
            log.warn("Odd RuntimeException while testing for JNDI: ", (Throwable)ex);
        }
        if (home == null && (home = System.getProperty(prop = "solr.solr.home")) != null) {
            SolrPaths.logOnceInfo("home_using_sysprop", "Using system property " + prop + ": " + home);
        }
        if (home == null) {
            home = "solr/";
            SolrPaths.logOnceInfo("home_default", "solr home defaulted to '" + home + "' (could not find system property or JNDI)");
        }
        return Paths.get(home, new String[0]);
    }

    public static String normalizeDir(String path) {
        return path != null && !path.endsWith("/") && !path.endsWith("\\") ? path + File.separator : path;
    }

    private static void logOnceInfo(String key, String msg) {
        if (!loggedOnce.contains(key)) {
            loggedOnce.add(key);
            log.info(msg);
        }
    }

    public static void assertPathAllowed(Path pathToAssert, Set<Path> allowPaths) throws SolrException {
        if (pathToAssert == null) {
            return;
        }
        if (OS.isFamilyWindows() && pathToAssert.toString().startsWith("\\\\")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path " + pathToAssert + " disallowed. UNC paths not supported. Please use drive letter instead.");
        }
        Path path = Paths.get(pathToAssert.toString(), new String[0]).normalize();
        if (path.startsWith("..")) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path " + pathToAssert + " disallowed due to path traversal..");
        }
        if (!path.isAbsolute()) {
            return;
        }
        if (allowPaths.contains(Paths.get("_ALL_", new String[0]))) {
            return;
        }
        if (allowPaths.stream().noneMatch(p -> path.startsWith(Paths.get(p.toString(), new String[0])))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Path " + path + " must be relative to SOLR_HOME, SOLR_DATA_HOME coreRootDirectory. Set system property 'solr.allowPaths' to add other allowed paths.");
        }
    }
}

