from _typeshed import StrPath
from typing import Any, BinaryIO, Callable, List, Optional, Protocol, Union, overload

class _ReadableBinary(Protocol):
    def tell(self) -> int: ...
    def read(self, size: int) -> bytes: ...
    def seek(self, offset: int) -> Any: ...

@overload
def what(file: Union[StrPath, _ReadableBinary], h: None = ...) -> Optional[str]: ...
@overload
def what(file: Any, h: bytes) -> Optional[str]: ...

tests: List[Callable[[bytes, Optional[BinaryIO]], Optional[str]]]
