/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cwm.unattended.util;

import com.jetbrains.cwm.unattended.util.UnattendedHostPerProjectStatus;
import com.jetbrains.cwm.unattended.util.UnattendedHostStatus;
import com.jetbrains.rd.platform.util.NetworkUtilsKt;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bJ\u001e\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(J2\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010.J\u001e\u00100\u001a\u00020\b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u00101\u001a\u00020\bJ\u001e\u00102\u001a\u00020\b2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002042\u0006\u00106\u001a\u000207R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u000e\u0010\u000e\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0006R\u000e\u0010\u0012\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u000e\u0010\u0015\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0006R\u000e\u0010\u001a\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u000e\u0010\u001d\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0006R\u000e\u0010 \u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/cwm/unattended/util/UnattendedHostConstants;", "", "()V", "controlLinkPrefixRegex", "Lkotlin/text/Regex;", "getControlLinkPrefixRegex", "()Lkotlin/text/Regex;", "controlLinkPrefixText", "", "controlPortRegex", "getControlPortRegex", "controlPortText", "currentlyRunningVersionRegex", "getCurrentlyRunningVersionRegex", "currentlyRunningVersionText", "dashes", "jreRuntimeVersionRegex", "getJreRuntimeVersionRegex", "jreRuntimeVersionText", "listeningPortRegex", "getListeningPortRegex", "listeningPortText", "noProjectsOpen", "notRunningInUnattendedMode", "permaLinkPrefixRegex", "getPermaLinkPrefixRegex", "permaLinkPrefixText", "projectPathRegex", "getProjectPathRegex", "projectPathText", "unattendedHostPIDRegex", "getUnattendedHostPIDRegex", "unattendedHostPIDText", "parseStatusText", "Lcom/jetbrains/cwm/unattended/util/UnattendedHostStatus;", "statusText", "renderCommonText", "appVersion", "runtimeVersion", "currentPid", "", "renderPerProjectDefault", "projectName", "projectPath", "joinToken", "permaLink", "Ljava/net/URI;", "joinLink", "renderPerProjectSsh", "sshLink", "renderUnattendedText", "unattendedMode", "", "isProjectOpen", "controlPort", "", "intellij.cwm.unattended.util"})
public final class UnattendedHostConstants {
    @NotNull
    public static final String notRunningInUnattendedMode = "Not running in unattended mode";
    @NotNull
    public static final String noProjectsOpen = "No projects open";
    @NotNull
    public static final String currentlyRunningVersionText = "Currently running version: ";
    @NotNull
    private static final Regex currentlyRunningVersionRegex;
    @NotNull
    public static final String jreRuntimeVersionText = "Runtime running version: ";
    @NotNull
    private static final Regex jreRuntimeVersionRegex;
    @NotNull
    public static final String controlPortText = "Control port: ";
    @NotNull
    private static final Regex controlPortRegex;
    @NotNull
    public static final String permaLinkPrefixText = "Permanent link for ";
    @NotNull
    private static final Regex permaLinkPrefixRegex;
    @NotNull
    public static final String controlLinkPrefixText = "Control link for ";
    @NotNull
    private static final Regex controlLinkPrefixRegex;
    @NotNull
    public static final String projectPathText = "Project path for ";
    @NotNull
    private static final Regex projectPathRegex;
    @NotNull
    public static final String unattendedHostPIDText = "Unattended host PID: ";
    @NotNull
    private static final Regex unattendedHostPIDRegex;
    @NotNull
    public static final String listeningPortText = "Direct connection listening port for ";
    @NotNull
    private static final Regex listeningPortRegex;
    @NotNull
    public static final String dashes = "------";
    @NotNull
    public static final UnattendedHostConstants INSTANCE;

    @NotNull
    public final Regex getCurrentlyRunningVersionRegex() {
        return currentlyRunningVersionRegex;
    }

    @NotNull
    public final Regex getJreRuntimeVersionRegex() {
        return jreRuntimeVersionRegex;
    }

    @NotNull
    public final Regex getControlPortRegex() {
        return controlPortRegex;
    }

    @NotNull
    public final Regex getPermaLinkPrefixRegex() {
        return permaLinkPrefixRegex;
    }

    @NotNull
    public final Regex getControlLinkPrefixRegex() {
        return controlLinkPrefixRegex;
    }

    @NotNull
    public final Regex getProjectPathRegex() {
        return projectPathRegex;
    }

    @NotNull
    public final Regex getUnattendedHostPIDRegex() {
        return unattendedHostPIDRegex;
    }

    @NotNull
    public final Regex getListeningPortRegex() {
        return listeningPortRegex;
    }

    @NotNull
    public final String renderCommonText(@NotNull String appVersion, @NotNull String runtimeVersion, long currentPid) {
        StringBuilder statusInfo;
        Intrinsics.checkNotNullParameter((Object)appVersion, (String)"appVersion");
        Intrinsics.checkNotNullParameter((Object)runtimeVersion, (String)"runtimeVersion");
        StringBuilder stringBuilder = statusInfo = new StringBuilder();
        String string = currentlyRunningVersionText + appVersion;
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = statusInfo;
        string = jreRuntimeVersionText + runtimeVersion;
        bl = false;
        StringBuilder stringBuilder4 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        stringBuilder3 = stringBuilder4;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = statusInfo;
        string = unattendedHostPIDText + currentPid;
        bl = false;
        StringBuilder stringBuilder5 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        stringBuilder3 = stringBuilder5;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        String string2 = statusInfo.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"statusInfo.toString()");
        return string2;
    }

    @NotNull
    public final String renderUnattendedText(boolean unattendedMode, boolean isProjectOpen, int controlPort) {
        StringBuilder statusInfo = new StringBuilder();
        if (unattendedMode) {
            StringBuilder stringBuilder = statusInfo;
            String string = controlPortText + controlPort;
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        } else if (isProjectOpen) {
            StringBuilder stringBuilder = statusInfo;
            String string = notRunningInUnattendedMode;
            boolean bl = false;
            StringBuilder stringBuilder4 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            StringBuilder stringBuilder5 = stringBuilder4;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
        } else {
            StringBuilder stringBuilder = statusInfo;
            String string = noProjectsOpen;
            boolean bl = false;
            StringBuilder stringBuilder6 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
            StringBuilder stringBuilder7 = stringBuilder6;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
        }
        String string = statusInfo.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"statusInfo.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderPerProjectDefault(@NotNull String projectName, @NotNull String projectPath, @NotNull String joinToken, @Nullable URI permaLink, @Nullable URI joinLink) {
        StringBuilder statusInfo;
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)joinToken, (String)"joinToken");
        StringBuilder stringBuilder = statusInfo = new StringBuilder();
        Object object = dashes;
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = statusInfo;
        object = projectPathText + projectName + ": " + projectPath;
        bl = false;
        StringBuilder stringBuilder4 = stringBuilder.append((String)object);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        stringBuilder3 = stringBuilder4;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        if (permaLink != null) {
            stringBuilder = statusInfo;
            object = permaLinkPrefixText + projectName + ": " + permaLink;
            bl = false;
            StringBuilder stringBuilder5 = stringBuilder.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder3 = stringBuilder5;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        if (joinLink != null) {
            void it;
            stringBuilder = statusInfo;
            object = MapsKt.toMutableMap((Map)NetworkUtilsKt.getFragmentParameters((URI)joinLink));
            bl = false;
            boolean bl3 = false;
            Object object2 = object;
            URI uRI = joinLink;
            StringBuilder stringBuilder6 = new StringBuilder().append(controlLinkPrefixText).append(projectName).append(": ");
            boolean bl4 = false;
            it.put("jt", joinToken);
            Unit unit = Unit.INSTANCE;
            object = stringBuilder6.append(NetworkUtilsKt.newURIWithFragmentParameters((URI)uRI, (Map)object)).toString();
            bl = false;
            StringBuilder stringBuilder7 = stringBuilder.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
            StringBuilder stringBuilder8 = stringBuilder7;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append('\\n')");
        }
        String string = statusInfo.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"statusInfo.toString()");
        return string;
    }

    @NotNull
    public final String renderPerProjectSsh(@NotNull String projectName, @NotNull String projectPath, @NotNull String sshLink) {
        StringBuilder statusInfo;
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)sshLink, (String)"sshLink");
        StringBuilder stringBuilder = statusInfo = new StringBuilder();
        String string = dashes;
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = statusInfo;
        string = projectPathText + projectName + ": " + projectPath;
        bl = false;
        StringBuilder stringBuilder4 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        stringBuilder3 = stringBuilder4;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        stringBuilder = statusInfo;
        string = controlLinkPrefixText + projectName + ": " + sshLink;
        bl = false;
        StringBuilder stringBuilder5 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        stringBuilder3 = stringBuilder5;
        bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        String string2 = statusInfo.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"statusInfo.toString()");
        return string2;
    }

    @NotNull
    public final UnattendedHostStatus parseStatusText(@NotNull String statusText) throws IllegalStateException {
        Intrinsics.checkNotNullParameter((Object)statusText, (String)"statusText");
        Object object = Regex.find$default((Regex)currentlyRunningVersionRegex, (CharSequence)statusText, (int)0, (int)2, null);
        if (object == null || (object = object.getGroupValues()) == null || (object = (String)object.get(1)) == null) {
            String string = "Failed to parse version";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object version = object;
        Object object2 = Regex.find$default((Regex)jreRuntimeVersionRegex, (CharSequence)statusText, (int)0, (int)2, null);
        if (object2 == null || (object2 = object2.getGroupValues()) == null || (object2 = (String)object2.get(1)) == null) {
            String string = "Failed to parse runtime version";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object runtimeVersion = object2;
        Object object3 = Regex.find$default((Regex)controlPortRegex, (CharSequence)statusText, (int)0, (int)2, null);
        if (object3 == null || (object3 = object3.getGroupValues()) == null || (object3 = (String)object3.get(1)) == null || (object3 = StringsKt.toIntOrNull((String)object3)) == null) {
            String string = "Failed to parse control port";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        int controlPort = (Integer)object3;
        Object object4 = Regex.find$default((Regex)unattendedHostPIDRegex, (CharSequence)statusText, (int)0, (int)2, null);
        if (object4 == null || (object4 = object4.getGroupValues()) == null || (object4 = (String)object4.get(1)) == null || (object4 = StringsKt.toLongOrNull((String)object4)) == null) {
            String string = "Failed to parse current pid";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        long currentPid = (Long)object4;
        boolean isNotUnattendedMode = StringsKt.contains$default((CharSequence)statusText, (CharSequence)notRunningInUnattendedMode, (boolean)false, (int)2, null);
        if (StringsKt.contains$default((CharSequence)statusText, (CharSequence)noProjectsOpen, (boolean)false, (int)2, null) || isNotUnattendedMode) {
            return new UnattendedHostStatus(currentPid, (String)version, (String)runtimeVersion, controlPort, !isNotUnattendedMode, null, 32, null);
        }
        List perProjectStatuses = StringsKt.split$default((CharSequence)statusText, (String[])new String[]{dashes}, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Map statuses = new LinkedHashMap();
        for (String perProjectStatus : perProjectStatuses) {
            Object object5 = Regex.find$default((Regex)controlLinkPrefixRegex, (CharSequence)perProjectStatus, (int)0, (int)2, null);
            if (object5 == null || (object5 = object5.getGroupValues()) == null || (object5 = (String)object5.get(1)) == null) {
                String string = "Failed to parse join link";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object projectName = object5;
            Object object6 = Regex.find$default((Regex)controlLinkPrefixRegex, (CharSequence)perProjectStatus, (int)0, (int)2, null);
            if (object6 == null || (object6 = object6.getGroupValues()) == null || (object6 = (String)object6.get(2)) == null) {
                String string = "Failed to parse join link";
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object joinLink = object6;
            Object object7 = Regex.find$default((Regex)projectPathRegex, (CharSequence)perProjectStatus, (int)0, (int)2, null);
            if (object7 == null || (object7 = object7.getGroupValues()) == null || (object7 = (String)object7.get(1)) == null) {
                String string = "Failed to parse project path";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object projectPath = object7;
            if (StringsKt.startsWith$default((String)joinLink, (String)"ssh://", (boolean)false, (int)2, null)) {
                statuses.put(projectName, new UnattendedHostPerProjectStatus((String)projectPath, (String)joinLink, null, 4, null));
                continue;
            }
            Object object8 = Regex.find$default((Regex)permaLinkPrefixRegex, (CharSequence)perProjectStatus, (int)0, (int)2, null);
            if (object8 == null || (object8 = object8.getGroupValues()) == null || (object8 = (String)object8.get(1)) == null) {
                String string = "Failed to parse perma link";
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Object permaLink = object8;
            statuses.put(projectName, new UnattendedHostPerProjectStatus((String)projectPath, (String)joinLink, (String)permaLink));
        }
        return new UnattendedHostStatus(currentPid, (String)version, (String)runtimeVersion, controlPort, !isNotUnattendedMode, statuses);
    }

    private UnattendedHostConstants() {
    }

    static {
        UnattendedHostConstants unattendedHostConstants;
        INSTANCE = unattendedHostConstants = new UnattendedHostConstants();
        currentlyRunningVersionRegex = new Regex("Currently running version: ([^\\r\\n]*)");
        jreRuntimeVersionRegex = new Regex("Runtime running version: ([^\\r\\n]*)");
        controlPortRegex = new Regex("Control port: ([^\\r\\n]*)");
        permaLinkPrefixRegex = new Regex("Permanent link for [^:]*:\\s*([^\\r\\n]*)");
        controlLinkPrefixRegex = new Regex("Control link for ([^:]*):\\s*([^\\r\\n]*)");
        projectPathRegex = new Regex("Project path for [^:]*:\\s*([^\\r\\n]*)");
        unattendedHostPIDRegex = new Regex("Unattended host PID: ([^\\r\\n]*)");
        listeningPortRegex = new Regex("Direct connection listening port for ([^\\r\\n]*)");
    }
}

