/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.list;

import circlet.code.api.CodeReviewRecord;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.space.vcs.review.SpaceReviewDataKeys;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/space/vcs/review/list/SpaceReviewOpenInBrowserAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.space"})
public final class SpaceReviewOpenInBrowserAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setIcon(AllIcons.Ide.External_link_arrow);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Ref ref = (Ref)e.getData(SpaceReviewDataKeys.getSELECTED_REVIEW_IN_LIST$intellij_space());
        if (ref == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"e.getData(SELECTED_REVIEW_IN_LIST) ?: return");
        Ref selectedReviewRecordRef = ref;
        CodeReviewRecord review = (CodeReviewRecord)RefResolveKt.resolve((Ref)selectedReviewRecordRef);
        String reviewLink = SpaceUrls.INSTANCE.review(review.getProject(), review.getNumber());
        BrowserUtil.browse((String)reviewLink);
    }

    public SpaceReviewOpenInBrowserAction() {
        super(SpaceBundle.messagePointer("action.go.to.review.text", new Object[0]));
    }
}

