/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.list;

import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TeamDirectoryKt;
import circlet.code.api.CodeReviewDiscussionCounter;
import circlet.code.api.CodeReviewListItem;
import circlet.code.api.CodeReviewParticipant;
import circlet.code.api.CodeReviewParticipantRole;
import circlet.code.api.CodeReviewParticipants;
import circlet.code.api.CodeReviewRecord;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import com.intellij.collaboration.ui.codereview.OpenReviewButton;
import com.intellij.collaboration.ui.codereview.OpenReviewButtonViewModel;
import com.intellij.icons.AllIcons;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.ui.SpaceAvatarProvider;
import com.intellij.space.ui.SpaceAvatarUtils;
import com.intellij.space.utils.DateUtilitiesKt;
import com.intellij.space.vcs.review.ReviewUiSpec;
import com.intellij.space.vcs.review.details.participants.ParticipantStatusBadgeKind;
import com.intellij.space.vcs.review.details.participants.ParticipantStatusBadgeParams;
import com.intellij.space.vcs.review.details.participants.SpaceReviewParticipantColorsKt;
import com.intellij.space.vcs.review.details.participants.SpaceReviewParticipantStatusKt;
import com.intellij.space.vcs.review.list.SpaceReviewListCellRendererKt;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J8\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\"2\u0006\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/space/vcs/review/list/SpaceReviewListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcirclet/code/api/CodeReviewListItem;", "Ljavax/swing/JPanel;", "avatarProvider", "Lcom/intellij/space/ui/SpaceAvatarProvider;", "openButtonViewModel", "Lcom/intellij/collaboration/ui/codereview/OpenReviewButtonViewModel;", "(Lcom/intellij/space/ui/SpaceAvatarProvider;Lcom/intellij/collaboration/ui/codereview/OpenReviewButtonViewModel;)V", "authorAvatar", "Lcom/intellij/ui/SimpleColoredComponent;", "commentIcon", "Ljavax/swing/Icon;", "getCommentIcon", "()Ljavax/swing/Icon;", "commentsLabel", "emptyAvatar", "Lcom/intellij/util/ui/EmptyIcon;", "Lorg/jetbrains/annotations/NotNull;", "firstReviewLabel", "infoLabel", "openCodeReviewButton", "secondReviewLabel", "titleLabel", "configureMemberLabel", "", "label", "profile", "Lcirclet/client/api/TD_MemberProfile;", "status", "Lcom/intellij/space/vcs/review/details/participants/ParticipantStatusBadgeParams;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.space"})
public final class SpaceReviewListCellRenderer
extends JPanel
implements ListCellRenderer<CodeReviewListItem> {
    private final SimpleColoredComponent titleLabel;
    private final SimpleColoredComponent infoLabel;
    private final EmptyIcon emptyAvatar;
    private final SimpleColoredComponent authorAvatar;
    private final SimpleColoredComponent commentsLabel;
    private final SimpleColoredComponent firstReviewLabel;
    private final SimpleColoredComponent secondReviewLabel;
    private final JPanel openCodeReviewButton;
    private final SpaceAvatarProvider avatarProvider;
    private final OpenReviewButtonViewModel openButtonViewModel;

    private final Icon getCommentIcon() {
        Icon icon = AllIcons.Ide.Notification.NoEvents;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"AllIcons.Ide.Notification.NoEvents");
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends CodeReviewListItem> list, @NotNull CodeReviewListItem value, int index, boolean isSelected, boolean cellHasFocus) {
        CodeReviewParticipant codeReviewParticipant;
        CodeReviewParticipant it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List it2;
        boolean bl;
        boolean bl2;
        List list2;
        Object object;
        TD_MemberProfile author;
        String title2;
        CodeReviewRecord review;
        List authors2;
        boolean bl3;
        List reviewers2;
        Color secondaryTextColor;
        Color primaryTextColor;
        block20: {
            String createdAt2;
            String key;
            block19: {
                List list3;
                Object element$iv$iv3;
                List list4;
                Iterable<Object> destination$iv$iv;
                List participants;
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.setBackground(ListUiUtil.WithTallRow.INSTANCE.background(list, isSelected, list.hasFocus()));
                primaryTextColor = ListUiUtil.WithTallRow.INSTANCE.foreground(isSelected, list.hasFocus());
                secondaryTextColor = ListUiUtil.WithTallRow.INSTANCE.secondaryForeground(list, isSelected);
                List list5 = participants = ((CodeReviewParticipants)RefResolveKt.resolve((Ref)value.getParticipants())).getParticipants();
                if (list5 != null) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = list5;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        CodeReviewParticipant it3 = (CodeReviewParticipant)element$iv$iv2;
                        boolean bl4 = false;
                        if (!(it3.getRole() == CodeReviewParticipantRole.Reviewer)) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    list4 = (List)destination$iv$iv;
                } else {
                    list4 = null;
                }
                reviewers2 = list4;
                List list6 = participants;
                if (list6 != null) {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = list6;
                    boolean $i$f$filter = false;
                    destination$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        CodeReviewParticipant it4 = (CodeReviewParticipant)element$iv$iv3;
                        bl3 = false;
                        if (!(it4.getRole() == CodeReviewParticipantRole.Author)) continue;
                        destination$iv$iv2.add(element$iv$iv3);
                    }
                    list3 = (List)destination$iv$iv2;
                } else {
                    list3 = null;
                }
                authors2 = list3;
                review = (CodeReviewRecord)RefResolveKt.resolve((Ref)value.getReview());
                title2 = review.getTitle();
                Ref ref = review.getCreatedBy();
                author = ref != null ? (TD_MemberProfile)RefResolveKt.resolve((Ref)ref) : null;
                String string = review.getKey();
                if (string == null) {
                    string = "";
                }
                key = string;
                createdAt2 = DateUtilitiesKt.formatPrettyDateTime(review.getCreatedAt());
                object = author;
                if (object == null) break block19;
                element$iv$iv3 = object;
                boolean it4 = false;
                bl3 = false;
                Object it5 = element$iv$iv3;
                boolean bl5 = false;
                object = SpaceBundle.message("review.by.author.at.time", key, TeamDirectoryKt.englishFullName(it5), createdAt2);
                if (object != null) break block20;
            }
            object = SpaceBundle.message("review.at.time", key, createdAt2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"author?.let { SpaceBundl\u2026at.time\", key, createdAt)");
        Object info = object;
        CharSequence it4 = new StringBuilder();
        bl3 = false;
        boolean bl6 = false;
        StringBuilder $this$apply = it4;
        boolean bl7 = false;
        $this$apply.append(title2).append("<br/>");
        $this$apply.append((String)info).append("<br/>");
        List list7 = authors2;
        if (list7 != null) {
            list2 = list7;
            bl2 = false;
            bl = false;
            it2 = list2;
            boolean bl8 = false;
            $this$apply.append("<br/>");
            $this$apply.append(SpaceBundle.message("review.details.authors.label", it2.size())).append("<br/>");
            $this$forEach$iv = authors2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CodeReviewParticipant)element$iv;
                boolean bl9 = false;
                $this$apply.append(TeamDirectoryKt.englishFullName((TD_MemberProfile)((TD_MemberProfile)RefResolveKt.resolve((Ref)it.getUser())))).append("<br/>");
            }
        }
        List list8 = reviewers2;
        if (list8 != null) {
            list2 = list8;
            bl2 = false;
            bl = false;
            it2 = list2;
            boolean bl10 = false;
            $this$apply.append("<br/>");
            $this$apply.append(SpaceBundle.message("review.details.reviewers.label", it2.size())).append("<br/>");
            $this$forEach$iv = reviewers2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CodeReviewParticipant)element$iv;
                boolean bl11 = false;
                $this$apply.append(TeamDirectoryKt.englishFullName((TD_MemberProfile)((TD_MemberProfile)RefResolveKt.resolve((Ref)it.getUser())))).append("<br/>");
            }
        }
        it4 = it4.toString();
        bl3 = false;
        bl6 = false;
        CharSequence it6 = it4;
        boolean bl12 = false;
        String string = XmlStringUtil.wrapInHtml((CharSequence)it6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026ringUtil.wrapInHtml(it) }");
        String fullToolTipText = string;
        it4 = this.titleLabel;
        bl3 = false;
        bl6 = false;
        $this$apply = it4;
        boolean bl13 = false;
        $this$apply.clear();
        $this$apply.append(title2);
        $this$apply.setForeground(primaryTextColor);
        $this$apply.setToolTipText(fullToolTipText);
        it4 = this.infoLabel;
        bl3 = false;
        bl6 = false;
        $this$apply = it4;
        boolean bl14 = false;
        $this$apply.clear();
        $this$apply.append((String)info);
        $this$apply.setForeground(secondaryTextColor);
        $this$apply.setToolTipText(fullToolTipText);
        Function1<CodeReviewParticipant, ParticipantStatusBadgeParams> $fun$getParticipantStatus$3 = new Function1<CodeReviewParticipant, ParticipantStatusBadgeParams>(review, reviewers2){
            final /* synthetic */ CodeReviewRecord $review;
            final /* synthetic */ List $reviewers;

            @Nullable
            public final ParticipantStatusBadgeParams invoke(@Nullable CodeReviewParticipant participant) {
                ParticipantStatusBadgeParams participantStatusBadgeParams;
                CodeReviewParticipant codeReviewParticipant = participant;
                if (codeReviewParticipant != null) {
                    CodeReviewParticipant codeReviewParticipant2 = codeReviewParticipant;
                    boolean bl = false;
                    boolean bl2 = false;
                    CodeReviewParticipant it = codeReviewParticipant2;
                    boolean bl3 = false;
                    List list = this.$reviewers;
                    if (list == null) {
                        boolean bl4 = false;
                        list = CollectionsKt.emptyList();
                    }
                    participantStatusBadgeParams = SpaceReviewParticipantStatusKt.getParticipantStatusBadgeParams(this.$review, it, list);
                } else {
                    participantStatusBadgeParams = null;
                }
                return participantStatusBadgeParams;
            }
            {
                this.$review = codeReviewRecord;
                this.$reviewers = list;
                super(1);
            }
        };
        List list9 = authors2;
        if (list9 != null) {
            Object v11;
            block18: {
                Iterable iterable = list9;
                boolean bl15 = false;
                Iterable iterable2 = iterable;
                boolean bl16 = false;
                for (Object t : iterable2) {
                    it2 = (CodeReviewParticipant)t;
                    boolean bl17 = false;
                    if (!Intrinsics.areEqual((Object)((TD_MemberProfile)RefResolveKt.resolve((Ref)it2.getUser())), (Object)author)) continue;
                    v11 = t;
                    break block18;
                }
                v11 = null;
            }
            codeReviewParticipant = v11;
        } else {
            codeReviewParticipant = null;
        }
        CodeReviewParticipant authorParticipant = codeReviewParticipant;
        this.configureMemberLabel(this.authorAvatar, author, $fun$getParticipantStatus$3.invoke(authorParticipant));
        Object object2 = this.commentsLabel;
        boolean bl18 = false;
        boolean bl19 = false;
        SimpleColoredComponent $this$apply2 = object2;
        boolean bl20 = false;
        $this$apply2.clear();
        $this$apply2.setIcon(this.getCommentIcon());
        $this$apply2.append(String.valueOf(((CodeReviewDiscussionCounter)RefResolveKt.resolve((Ref)value.getDiscussionCount())).getCounter().getTotal()));
        object2 = this.firstReviewLabel;
        bl18 = false;
        bl19 = false;
        $this$apply2 = object2;
        boolean bl21 = false;
        List list10 = reviewers2;
        Object firstReviewer = list10 != null ? (CodeReviewParticipant)CollectionsKt.firstOrNull((List)list10) : null;
        CodeReviewParticipant codeReviewParticipant2 = firstReviewer;
        this.configureMemberLabel(this.firstReviewLabel, codeReviewParticipant2 != null && (codeReviewParticipant2 = codeReviewParticipant2.getUser()) != null ? (TD_MemberProfile)RefResolveKt.resolve((Ref)codeReviewParticipant2) : null, $fun$getParticipantStatus$3.invoke(firstReviewer));
        object2 = this.secondReviewLabel;
        bl18 = false;
        bl19 = false;
        $this$apply2 = object2;
        boolean bl22 = false;
        List list11 = reviewers2;
        Object secondReviewer = list11 != null ? (CodeReviewParticipant)SpaceReviewListCellRendererKt.access$secondOrNull(list11) : null;
        CodeReviewParticipant codeReviewParticipant3 = secondReviewer;
        this.configureMemberLabel(this.secondReviewLabel, codeReviewParticipant3 != null && (codeReviewParticipant3 = codeReviewParticipant3.getUser()) != null ? (TD_MemberProfile)RefResolveKt.resolve((Ref)codeReviewParticipant3) : null, $fun$getParticipantStatus$3.invoke(secondReviewer));
        object2 = this.openCodeReviewButton;
        bl18 = false;
        bl19 = false;
        $this$apply2 = object2;
        boolean bl23 = false;
        $this$apply2.setVisible(index == this.openButtonViewModel.getHoveredRowIndex());
        $this$apply2.setOpaque(this.openButtonViewModel.isButtonHovered());
        return this;
    }

    private final void configureMemberLabel(SimpleColoredComponent label2, TD_MemberProfile profile2, ParticipantStatusBadgeParams status) {
        if (profile2 != null) {
            Icon icon = this.avatarProvider.getIcon(profile2);
            Object object = status;
            Color outlineColor = object != null && (object = object.getKind()) != null ? SpaceReviewParticipantColorsKt.getBorderColor((ParticipantStatusBadgeKind)((Object)object)) : null;
            label2.setIcon(SpaceAvatarUtils.INSTANCE.outlineCircleIcon(icon, outlineColor));
            label2.setToolTipText(TeamDirectoryKt.englishFullName((TD_MemberProfile)profile2));
        } else {
            label2.setIcon((Icon)this.emptyAvatar);
            label2.setToolTipText("");
        }
    }

    public SpaceReviewListCellRenderer(@NotNull SpaceAvatarProvider avatarProvider, @NotNull OpenReviewButtonViewModel openButtonViewModel) {
        SimpleColoredComponent $this$apply;
        Intrinsics.checkNotNullParameter((Object)avatarProvider, (String)"avatarProvider");
        Intrinsics.checkNotNullParameter((Object)openButtonViewModel, (String)"openButtonViewModel");
        super(null);
        this.avatarProvider = avatarProvider;
        this.openButtonViewModel = openButtonViewModel;
        SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
        boolean bl = false;
        boolean bl2 = false;
        SimpleColoredComponent simpleColoredComponent2 = simpleColoredComponent;
        SpaceReviewListCellRenderer spaceReviewListCellRenderer = this;
        boolean bl3 = false;
        $this$apply.setOpaque(false);
        Unit unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.titleLabel = simpleColoredComponent;
        simpleColoredComponent = new SimpleColoredComponent();
        bl = false;
        bl2 = false;
        $this$apply = simpleColoredComponent;
        spaceReviewListCellRenderer = this;
        boolean bl4 = false;
        $this$apply.setFont((Font)JBUI.Fonts.smallFont());
        $this$apply.setOpaque(false);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.infoLabel = simpleColoredComponent;
        EmptyIcon emptyIcon = EmptyIcon.create((int)(JBUI.scale((int)ReviewUiSpec.INSTANCE.getAvatarSizeIntValue().get()) + 2 * SpaceAvatarUtils.INSTANCE.getOUTLINE_WIDTH()));
        Intrinsics.checkNotNullExpressionValue((Object)emptyIcon, (String)"EmptyIcon.create(JBUI.sc\u2026t()) + 2 * OUTLINE_WIDTH)");
        this.emptyAvatar = emptyIcon;
        simpleColoredComponent = new SimpleColoredComponent();
        bl = false;
        bl2 = false;
        $this$apply = simpleColoredComponent;
        spaceReviewListCellRenderer = this;
        boolean bl5 = false;
        $this$apply.setIcon((Icon)this.emptyAvatar);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.authorAvatar = simpleColoredComponent;
        simpleColoredComponent = new SimpleColoredComponent();
        bl = false;
        bl2 = false;
        $this$apply = simpleColoredComponent;
        spaceReviewListCellRenderer = this;
        boolean bl6 = false;
        $this$apply.setIcon(this.getCommentIcon());
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.commentsLabel = simpleColoredComponent;
        simpleColoredComponent = new SimpleColoredComponent();
        bl = false;
        bl2 = false;
        $this$apply = simpleColoredComponent;
        spaceReviewListCellRenderer = this;
        boolean bl7 = false;
        $this$apply.setIcon((Icon)this.emptyAvatar);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.firstReviewLabel = simpleColoredComponent;
        simpleColoredComponent = new SimpleColoredComponent();
        bl = false;
        bl2 = false;
        $this$apply = simpleColoredComponent;
        spaceReviewListCellRenderer = this;
        boolean bl8 = false;
        $this$apply.setIcon((Icon)this.emptyAvatar);
        unit = Unit.INSTANCE;
        spaceReviewListCellRenderer.secondReviewLabel = simpleColoredComponent;
        this.openCodeReviewButton = OpenReviewButton.createOpenReviewButton$default((OpenReviewButton)OpenReviewButton.INSTANCE, null, (int)1, null);
        String zero = "0";
        String gap = JBUI.scale((int)8) + "px";
        String gapTop = JBUI.scale((int)5) + "px";
        this.setLayout((LayoutManager)new MigLayout(new LC().gridGap(zero, zero).insets(zero, zero, zero, zero).fillX()));
        Component component2 = (Component)this.authorAvatar;
        CC cC = new CC().gapAfter(zero).gapBefore(gap).gapBottom(gap).gapTop(gap);
        Intrinsics.checkNotNullExpressionValue((Object)cC, (String)"CC()\n      .gapAfter(zer\u2026m(gap)\n      .gapTop(gap)");
        this.add(component2, SpaceReviewListCellRendererKt.access$center(cC).spanY(2).shrinkPrioX(100));
        this.add((Component)this.titleLabel, new CC().gapTop(gapTop).growX().pushX().minWidth("0px").spanX(2).shrinkPrioX(15).gapAfter(gap));
        Component component3 = (Component)this.commentsLabel;
        CC cC2 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC2, (String)"CC()\n      .spanY(2)");
        this.add(component3, SpaceReviewListCellRendererKt.access$center(cC2).gapAfter(gap).shrinkPrioX(100));
        Component component4 = (Component)this.firstReviewLabel;
        CC cC3 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC3, (String)"CC()\n      .spanY(2)");
        this.add(component4, SpaceReviewListCellRendererKt.access$center(cC3).gapAfter(gap).shrinkPrioX(10));
        Component component5 = (Component)this.secondReviewLabel;
        CC cC4 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC4, (String)"CC()\n      .spanY(2)");
        this.add(component5, SpaceReviewListCellRendererKt.access$center(cC4).gapAfter(gap).shrinkPrioX(9));
        Component component6 = this.openCodeReviewButton;
        CC cC5 = new CC().spanY(2);
        Intrinsics.checkNotNullExpressionValue((Object)cC5, (String)"CC()\n      .spanY(2)");
        this.add(component6, SpaceReviewListCellRendererKt.access$center(cC5).shrinkPrioX(1000).growY().minWidth("pref").wrap());
        this.add((Component)this.infoLabel, new CC().gapBottom(gapTop).skip(1).gapAfter(gap).growX().pushX().minWidth("0px"));
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"this.components");
        Component[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        Component[] componentArray2 = $this$forEach$iv;
        int n = componentArray2.length;
        for (int i = 0; i < n; ++i) {
            Component element$iv;
            Component it = element$iv = componentArray2[i];
            boolean bl9 = false;
            UIUtil.setNotOpaqueRecursively((Component)it);
        }
    }
}

