/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review.details;

import circlet.code.api.CodeReviewServiceKt;
import circlet.code.api.MergeRequestBranch;
import circlet.code.api.MergeRequestBranchPair;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.review.details.MergeRequestBranchInfo;
import com.intellij.space.vcs.review.details.MergeRequestDetailsVm;
import com.intellij.space.vcs.review.details.SpaceReviewCheckoutBranchActionKt;
import git4idea.GitLocalBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.fetch.GitFetchSupport;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J.\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002JF\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/space/vcs/review/details/SpaceReviewCheckoutBranchAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkoutLocalBranch", "project", "Lcom/intellij/openapi/project/Project;", "detailsVm", "Lcom/intellij/space/vcs/review/details/MergeRequestDetailsVm;", "localBranch", "Lgit4idea/GitLocalBranch;", "gitRepositories", "", "Lgit4idea/repo/GitRepository;", "checkoutRemoteBranch", "gitRepository", "repoInfo", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "sourceBranchInfo", "Lcirclet/code/api/MergeRequestBranch;", "options", "Lgit4idea/branch/GitNewBranchOptions;", "update", "intellij.space"})
public final class SpaceReviewCheckoutBranchAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MergeRequestDetailsVm detailsVm = SpaceReviewCheckoutBranchActionKt.access$getMergeRequestVm(e);
        if (detailsVm == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        SpaceRepoInfo repoInfo2 = (SpaceRepoInfo)detailsVm.getRepoInfo().getValue();
        if (repoInfo2 == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        GitLocalBranch localBranch = ((MergeRequestBranchInfo)detailsVm.getMergeRequestBranchInfo().getValue()).getLocalBranch();
        if (localBranch != null && Intrinsics.areEqual((Object)repoInfo2.getRepository().getCurrentBranchName(), (Object)localBranch.getName())) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        MergeRequestDetailsVm mergeRequestDetailsVm = SpaceReviewCheckoutBranchActionKt.access$getMergeRequestVm(e);
        if (mergeRequestDetailsVm == null) {
            return;
        }
        MergeRequestDetailsVm detailsVm = mergeRequestDetailsVm;
        SpaceRepoInfo spaceRepoInfo = (SpaceRepoInfo)detailsVm.getRepoInfo().getValue();
        if (spaceRepoInfo == null) {
            return;
        }
        SpaceRepoInfo repoInfo2 = spaceRepoInfo;
        GitRepository gitRepository = repoInfo2.getRepository();
        List gitRepositories = CollectionsKt.listOf((Object)gitRepository);
        MergeRequestBranchPair branchPair2 = (MergeRequestBranchPair)detailsVm.getBranchPair().getValue();
        MergeRequestBranch mergeRequestBranch = branchPair2.getSourceBranchInfo();
        if (mergeRequestBranch == null) {
            return;
        }
        MergeRequestBranch sourceBranchInfo = mergeRequestBranch;
        SpaceStatsCounterCollector.CHECKOUT_BRANCH.log();
        GitLocalBranch localBranch = ((MergeRequestBranchInfo)detailsVm.getMergeRequestBranchInfo().getValue()).getLocalBranch();
        if (localBranch != null) {
            this.checkoutLocalBranch(project2, detailsVm, localBranch, gitRepositories);
        } else {
            GitStandardRemoteBranch remoteBranch = new GitStandardRemoteBranch(repoInfo2.getRemote(), CodeReviewServiceKt.getSourceBranchName((MergeRequestBranchPair)branchPair2));
            GitNewBranchOptions gitNewBranchOptions = GitBranchUtil.getNewBranchNameFromUser((Project)project2, (Collection)gitRepositories, (String)SpaceBundle.message("review.checkout.action.checkout.dialog.title", remoteBranch.getName()), (String)CodeReviewServiceKt.getSourceBranchName((MergeRequestBranchPair)branchPair2), (boolean)false);
            if (gitNewBranchOptions == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)gitNewBranchOptions, (String)"GitBranchUtil.getNewBran\u2026\n        false) ?: return");
            GitNewBranchOptions options = gitNewBranchOptions;
            if (options.shouldCheckout()) {
                this.checkoutRemoteBranch(project2, detailsVm, gitRepository, repoInfo2, sourceBranchInfo, options, gitRepositories);
            } else {
                new Task.Backgroundable(project2, gitRepository, repoInfo2, options, sourceBranchInfo, detailsVm, project2, SpaceBundle.message("review.checkout.action.progress.title.creating.branch", detailsVm.getReviewKey()), true){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ GitRepository $gitRepository;
                    final /* synthetic */ SpaceRepoInfo $repoInfo;
                    final /* synthetic */ GitNewBranchOptions $options;
                    final /* synthetic */ MergeRequestBranch $sourceBranchInfo;
                    final /* synthetic */ MergeRequestDetailsVm $detailsVm;

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        Git git = Git.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
                        Git git2 = git;
                        GitFetchSupport.fetchSupport((Project)this.$project).fetch(this.$gitRepository, this.$repoInfo.getRemote()).throwExceptionIfFailed();
                        new GitBranchWorker(this.$project, git2, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, git2, indicator)).createBranch(this.$options.getName(), MapsKt.mapOf((Pair)TuplesKt.to((Object)this.$gitRepository, (Object)this.$sourceBranchInfo.getRef())));
                        this.$gitRepository.update();
                    }
                    {
                        this.$project = $captured_local_variable$0;
                        this.$gitRepository = $captured_local_variable$1;
                        this.$repoInfo = $captured_local_variable$2;
                        this.$options = $captured_local_variable$3;
                        this.$sourceBranchInfo = $captured_local_variable$4;
                        this.$detailsVm = $captured_local_variable$5;
                        super($super_call_param$6, $super_call_param$7, $super_call_param$8);
                    }
                }.queue();
            }
        }
    }

    private final void checkoutRemoteBranch(Project project, MergeRequestDetailsVm detailsVm, GitRepository gitRepository, SpaceRepoInfo repoInfo2, MergeRequestBranch sourceBranchInfo, GitNewBranchOptions options, List<? extends GitRepository> gitRepositories) {
        new Task.Backgroundable(project, gitRepository, repoInfo2, sourceBranchInfo, options, gitRepositories, detailsVm, project, SpaceBundle.message("review.checkout.action.progress.title.checking.out.branch", detailsVm.getReviewKey()), true){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitRepository $gitRepository;
            final /* synthetic */ SpaceRepoInfo $repoInfo;
            final /* synthetic */ MergeRequestBranch $sourceBranchInfo;
            final /* synthetic */ GitNewBranchOptions $options;
            final /* synthetic */ List $gitRepositories;
            final /* synthetic */ MergeRequestDetailsVm $detailsVm;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
                Git git2 = git;
                GitFetchSupport.fetchSupport((Project)this.$project).fetch(this.$gitRepository, this.$repoInfo.getRemote()).throwExceptionIfFailed();
                GitStandardRemoteBranch remoteBranch = new GitStandardRemoteBranch(this.$repoInfo.getRemote(), this.$sourceBranchInfo.getDisplayName());
                new GitBranchWorker(this.$project, git2, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, git2, indicator)).checkoutNewBranchStartingFrom(this.$options.getName(), remoteBranch.getName(), this.$gitRepositories);
                this.$gitRepository.update();
            }
            {
                this.$project = $captured_local_variable$0;
                this.$gitRepository = $captured_local_variable$1;
                this.$repoInfo = $captured_local_variable$2;
                this.$sourceBranchInfo = $captured_local_variable$3;
                this.$options = $captured_local_variable$4;
                this.$gitRepositories = $captured_local_variable$5;
                this.$detailsVm = $captured_local_variable$6;
                super($super_call_param$7, $super_call_param$8, $super_call_param$9);
            }
        }.queue();
    }

    private final void checkoutLocalBranch(Project project, MergeRequestDetailsVm detailsVm, GitLocalBranch localBranch, List<? extends GitRepository> gitRepositories) {
        new Task.Backgroundable(project, localBranch, gitRepositories, detailsVm, project, SpaceBundle.message("review.checkout.action.progress.title.checking.out.branch", detailsVm.getReviewKey()), true){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitLocalBranch $localBranch;
            final /* synthetic */ List $gitRepositories;
            final /* synthetic */ MergeRequestDetailsVm $detailsVm;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Git git = Git.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)git, (String)"Git.getInstance()");
                Git git2 = git;
                new GitBranchWorker(this.$project, git2, (GitBranchUiHandler)new GitBranchUiHandlerImpl(this.$project, git2, indicator)).checkout(this.$localBranch.getName(), false, this.$gitRepositories);
            }
            {
                this.$project = $captured_local_variable$0;
                this.$localBranch = $captured_local_variable$1;
                this.$gitRepositories = $captured_local_variable$2;
                this.$detailsVm = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }.queue();
    }

    public SpaceReviewCheckoutBranchAction() {
        super(SpaceBundle.messagePointer("review.actions.checkout.branch", new Object[0]));
    }
}

