/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.plugins.pipelines.services.run;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.space.plugins.pipelines.services.run.SpaceRunConfiguration;
import com.intellij.space.plugins.pipelines.services.run.SpaceRunConfigurationType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/space/plugins/pipelines/services/run/SpaceRunConfigurationUtils;", "", "()V", "run", "", "taskName", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.space"})
public final class SpaceRunConfigurationUtils {
    @NotNull
    public static final SpaceRunConfigurationUtils INSTANCE;

    public final void run(@NotNull String taskName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RunManager runManager = RunManager.Companion.getInstance(project);
        RunnerAndConfigurationSettings settings = runManager.createConfiguration("Run task " + taskName, SpaceRunConfigurationType.class);
        RunConfiguration runConfiguration = settings.getConfiguration();
        if (runConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.space.plugins.pipelines.services.run.SpaceRunConfiguration");
        }
        SpaceRunConfiguration configuration = (SpaceRunConfiguration)runConfiguration;
        configuration.getOptions().setTaskName(taskName);
        runManager.addConfiguration(settings);
        runManager.setSelectedConfiguration(settings);
        ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)settings, (Executor)DefaultRunExecutor.getRunExecutorInstance());
    }

    private SpaceRunConfigurationUtils() {
    }

    static {
        SpaceRunConfigurationUtils spaceRunConfigurationUtils;
        INSTANCE = spaceRunConfigurationUtils = new SpaceRunConfigurationUtils();
    }
}

