/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.plugins.pipelines.services;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.space.plugins.pipelines.services.SpaceKtsFileDetector;
import com.intellij.space.plugins.pipelines.utils.DslFileFinder;
import com.intellij.space.tools.SpaceToolWindowFactoryKt;
import com.intellij.space.utils.LifetimedDisposable;
import com.intellij.space.utils.UtilitiesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import libraries.coroutines.extra.Lifetime;
import libraries.klogging.KLogger;
import libraries.klogging.KLoggers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.CellableKt;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\r\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0002J\t\u0010\u0016\u001a\u00020\u0017H\u0096\u0001J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0017R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/space/plugins/pipelines/services/SpaceKtsFileDetector;", "Lcom/intellij/space/utils/LifetimedDisposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_dslFile", "Lruntime/reactive/MutableProperty;", "Lcom/intellij/openapi/vfs/VirtualFile;", "dslFile", "Lruntime/reactive/Property;", "getDslFile", "()Lruntime/reactive/Property;", "fileListener", "com/intellij/space/plugins/pipelines/services/SpaceKtsFileDetector$fileListener$1", "Lcom/intellij/space/plugins/pipelines/services/SpaceKtsFileDetector$fileListener$1;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "getLifetime", "()Llibraries/coroutines/extra/Lifetime;", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkIsDslFileExists", "dispose", "", "handleFileChanged", "name", "", "refreshScript", "Companion", "intellij.space"})
public final class SpaceKtsFileDetector
implements LifetimedDisposable {
    private final MutableProperty<VirtualFile> _dslFile;
    private final fileListener.1 fileListener;
    @NotNull
    private final Project project;
    private static final KLogger LOG;
    @NotNull
    public static final Companion Companion;
    private final /* synthetic */ LifetimedDisposable $$delegate_0;

    @NotNull
    public final Property<VirtualFile> getDslFile() {
        return (Property)this._dslFile;
    }

    public final void refreshScript() {
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ SpaceKtsFileDetector this$0;
            {
                this.this$0 = spaceKtsFileDetector;
            }

            public final T compute() {
                boolean bl = false;
                if (!this.this$0.getProject().isDisposed()) {
                    SpaceKtsFileDetector.access$get_dslFile$p(this.this$0).setValue((Object)SpaceKtsFileDetector.access$checkIsDslFileExists(this.this$0));
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public final void handleFileChanged(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (DslFileFinder.INSTANCE.checkFileNameIsApplicable(name)) {
            this.refreshScript();
        }
    }

    private final VirtualFile checkIsDslFileExists() {
        return DslFileFinder.INSTANCE.find(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public SpaceKtsFileDetector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.$$delegate_0 = UtilitiesKt.LifetimedDisposable();
        this.project = project;
        this._dslFile = CellableKt.mutableProperty(null);
        this.fileListener = new VirtualFileListener(this){
            final /* synthetic */ SpaceKtsFileDetector this$0;

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
                    this.this$0.handleFileChanged(event.getOldValue().toString());
                    this.this$0.handleFileChanged(event.getNewValue().toString());
                }
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = event.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.fileName");
                this.this$0.handleFileChanged(string);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = event.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.fileName");
                this.this$0.handleFileChanged(string);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                String string = event.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.fileName");
                this.this$0.handleFileChanged(string);
            }
            {
                this.this$0 = this$0;
            }
        };
        LOG.info((Object)"SpaceKtsFileDetector");
        this.refreshScript();
        LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)this.fileListener);
        this.getLifetime().add((Function0)new Function0<Unit>(){

            public final void invoke() {
                LocalFileSystem.getInstance().removeVirtualFileListener((VirtualFileListener)fileListener);
            }
        });
        this._dslFile.forEach(this.getLifetime(), (Function1)new Function1<VirtualFile, Unit>(){

            public final void invoke(@Nullable VirtualFile file) {
                block0: {
                    ToolWindow toolWindow = SpaceToolWindowFactoryKt.getSpaceKtsToolwindow(this.getProject());
                    if (toolWindow == null) break block0;
                    toolWindow.setAvailable(file != null, null);
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        LOG = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(SpaceKtsFileDetector.class));
    }

    @NotNull
    public Lifetime getLifetime() {
        return this.$$delegate_0.getLifetime();
    }

    public void dispose() {
        this.$$delegate_0.dispose();
    }

    public static final /* synthetic */ MutableProperty access$get_dslFile$p(SpaceKtsFileDetector $this) {
        return $this._dslFile;
    }

    public static final /* synthetic */ VirtualFile access$checkIsDslFileExists(SpaceKtsFileDetector $this) {
        return $this.checkIsDslFileExists();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/plugins/pipelines/services/SpaceKtsFileDetector$Companion;", "", "()V", "LOG", "Llibraries/klogging/KLogger;", "intellij.space"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

