/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.plugins.pipelines.services;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.plugins.pipelines.services.SyncDslViewManager;
import com.intellij.space.plugins.pipelines.viewmodel.LogData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import libraries.io.random.UID;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.ObservableList;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"publishBuildLog", "", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/intellij/space/plugins/pipelines/viewmodel/LogData;", "intellij.space"})
public final class BuildLogPublisherKt {
    public static final void publishBuildLog(@NotNull Project project, @NotNull LogData data) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            Application application2 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
            if (!application2.isHeadlessEnvironment()) {
                UID uID = data.getBuildId();
                String string = SpaceBundle.message("build.log.title", new Object[0]);
                String string2 = project.getBasePath();
                Intrinsics.checkNotNull((Object)string2);
                DefaultBuildDescriptor descriptor = new DefaultBuildDescriptor((Object)uID, string, string2, System.currentTimeMillis());
                SyncDslViewManager view2 = (SyncDslViewManager)((Object)project.getService(SyncDslViewManager.class));
                view2.onEvent(data.getBuildId(), (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor, SpaceBundle.message("build.log.message.started", project.getName())));
                view2.onEvent(data.getBuildId(), (BuildEvent)new MessageEventImpl((Object)data.getBuildId(), MessageEvent.Kind.INFO, null, SpaceBundle.message("build.log.message.process", new Object[0]), null));
                if (!data.getLifetime().isTerminated()) {
                    data.getMessages().getChange().forEach((Lifetime)data.getLifetime(), (Function1)new Function1<ObservableList.Change<? extends BuildEvent>, Unit>(view2, data){
                        final /* synthetic */ SyncDslViewManager $view;
                        final /* synthetic */ LogData $data;

                        public final void invoke(@NotNull ObservableList.Change<? extends BuildEvent> change) {
                            block0: {
                                Intrinsics.checkNotNullParameter(change, (String)"change");
                                ObservableList.Change<? extends BuildEvent> change2 = change;
                                if (!(change2 instanceof ObservableList.Change.Add)) break block0;
                                BuildEvent message = (BuildEvent)((ObservableList.Change.Add)change).getNewValue();
                                this.$view.onEvent(this.$data.getBuildId(), message);
                            }
                        }
                        {
                            this.$view = syncDslViewManager;
                            this.$data = logData;
                            super(1);
                        }
                    });
                }
                data.getLifetime().addOrCallImmediately((Function0)new Function0<Unit>(view2, data, descriptor){
                    final /* synthetic */ SyncDslViewManager $view;
                    final /* synthetic */ LogData $data;
                    final /* synthetic */ DefaultBuildDescriptor $descriptor;

                    public final void invoke() {
                        this.$view.onEvent(this.$data.getBuildId(), (BuildEvent)new FinishBuildEventImpl(this.$descriptor.getId(), null, System.currentTimeMillis(), SpaceBundle.message("build.log.message.finished", new Object[0]), (EventResult)new SuccessResultImpl(false)));
                    }
                    {
                        this.$view = syncDslViewManager;
                        this.$data = logData;
                        this.$descriptor = defaultBuildDescriptor;
                        super(0);
                    }
                });
            }
        }
    }
}

