/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.space.chat.editor.SpaceChatFile;
import com.intellij.space.chat.model.api.SpaceChatCreationDetails;
import com.intellij.space.vcs.review.details.SpaceReviewChangesVm;
import com.intellij.space.vcs.review.details.diff.SpaceDiffFile;
import com.intellij.space.vcs.review.details.diff.SpaceDiffFileData;
import com.intellij.space.vcs.review.details.diff.SpaceDiffFileId;
import com.intellij.space.vcs.review.details.diff.SpaceDiffVm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Property;

@Service
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u0007J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\rJ6\u0010\u0016\u001a\u00020\t2\b\b\u0001\u0010\u0013\u001a\u00020\u00072\b\b\u0001\u0010\u0017\u001a\u00020\u00072\b\b\u0001\u0010\u0018\u001a\u00020\u00072\b\b\u0001\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bJ\u001c\u0010\u001c\u001a\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!J\u001c\u0010\"\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!RV\u0010\u0005\u001aJ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t \b*#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u000b\u00a2\u0006\u0002\b\n0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\f\u001aJ\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e \b*#\u0012\f\u0012\n \b*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \b*\u0004\u0018\u00010\u000e0\u000e0\u000b\u00a2\u0006\u0002\b\n0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/space/editor/SpaceVirtualFilesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "chatFiles", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/space/chat/editor/SpaceChatFile;", "Lorg/jetbrains/annotations/NotNull;", "", "diffFiles", "Lcom/intellij/space/vcs/review/details/diff/SpaceDiffFileId;", "Lcom/intellij/space/vcs/review/details/diff/SpaceDiffFile;", "sessionId", "dispose", "", "findChatFile", "id", "findDiffFile", "fileId", "findOrCreateChatFile", "path", "displayName", "tabTooltip", "chatCreationDetails", "Lcom/intellij/space/chat/model/api/SpaceChatCreationDetails;", "findOrCreateDiffFile", "changesVm", "Lruntime/reactive/Property;", "Lcom/intellij/space/vcs/review/details/SpaceReviewChangesVm;", "diffVm", "Lcom/intellij/space/vcs/review/details/diff/SpaceDiffVm;", "updateDiffPresentation", "intellij.space"})
public final class SpaceVirtualFilesManager
implements Disposable {
    private final String sessionId;
    private final Map<String, SpaceChatFile> chatFiles;
    private final Map<SpaceDiffFileId, SpaceDiffFile> diffFiles;
    private final Project project;

    @Nullable
    public final SpaceChatFile findChatFile(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.chatFiles.get(id);
    }

    @Nullable
    public final SpaceDiffFile findDiffFile(@NotNull SpaceDiffFileId fileId) {
        Intrinsics.checkNotNullParameter((Object)fileId, (String)"fileId");
        return this.diffFiles.get(fileId);
    }

    @NotNull
    public final SpaceChatFile findOrCreateChatFile(@NlsSafe @NotNull String id, @NlsSafe @NotNull String path, @NlsContexts.TabTitle @NotNull String displayName, @NlsContexts.Tooltip @NotNull String tabTooltip, @NotNull SpaceChatCreationDetails chatCreationDetails2) {
        SpaceChatFile spaceChatFile;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)tabTooltip, (String)"tabTooltip");
        Intrinsics.checkNotNullParameter((Object)chatCreationDetails2, (String)"chatCreationDetails");
        Map<String, SpaceChatFile> $this$getOrPut$iv = this.chatFiles;
        boolean $i$f$getOrPut = false;
        SpaceChatFile value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            boolean bl = false;
            String string = this.project.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.locationHash");
            SpaceChatFile answer$iv = new SpaceChatFile(this.sessionId, string, id, path, displayName, tabTooltip, chatCreationDetails2);
            $this$getOrPut$iv.put(id, answer$iv);
            spaceChatFile = answer$iv;
        } else {
            spaceChatFile = value$iv;
        }
        return spaceChatFile;
    }

    @NotNull
    public final SpaceDiffFile findOrCreateDiffFile(@NotNull Property<? extends SpaceReviewChangesVm> changesVm, @NotNull SpaceDiffVm diffVm) {
        SpaceDiffFile spaceDiffFile;
        Intrinsics.checkNotNullParameter(changesVm, (String)"changesVm");
        Intrinsics.checkNotNullParameter((Object)diffVm, (String)"diffVm");
        SpaceDiffFileId spaceDiffFileId = new SpaceDiffFileId(diffVm.getProjectKey().getKey(), diffVm.getReviewKey(), diffVm.getReviewId());
        boolean bl = false;
        boolean bl2 = false;
        SpaceDiffFileId fileId = spaceDiffFileId;
        boolean bl3 = false;
        Map<SpaceDiffFileId, SpaceDiffFile> $this$getOrPut$iv = this.diffFiles;
        boolean $i$f$getOrPut = false;
        SpaceDiffFile value$iv = $this$getOrPut$iv.get(fileId);
        if (value$iv == null) {
            boolean bl4 = false;
            String string = this.project.getLocationHash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.locationHash");
            SpaceDiffFile answer$iv = new SpaceDiffFile(this.sessionId, string, fileId, diffVm.getReviewKey());
            $this$getOrPut$iv.put(fileId, answer$iv);
            spaceDiffFile = answer$iv;
        } else {
            spaceDiffFile = value$iv;
        }
        SpaceDiffFile spaceDiffFile2 = spaceDiffFile;
        boolean bl5 = false;
        boolean bl6 = false;
        SpaceDiffFile $this$apply = spaceDiffFile2;
        boolean bl7 = false;
        this.updateDiffPresentation(changesVm, diffVm);
        return spaceDiffFile2;
    }

    public final void updateDiffPresentation(@NotNull Property<? extends SpaceReviewChangesVm> changesVm, @NotNull SpaceDiffVm diffVm) {
        block0: {
            Intrinsics.checkNotNullParameter(changesVm, (String)"changesVm");
            Intrinsics.checkNotNullParameter((Object)diffVm, (String)"diffVm");
            SpaceDiffFileId fileId = new SpaceDiffFileId(diffVm.getProjectKey().getKey(), diffVm.getReviewKey(), diffVm.getReviewId());
            SpaceDiffFile spaceDiffFile = this.diffFiles.get(fileId);
            if (spaceDiffFile == null) break block0;
            spaceDiffFile.updateDiffFileData(new SpaceDiffFileData(changesVm, diffVm));
        }
    }

    public void dispose() {
        this.chatFiles.clear();
        this.diffFiles.clear();
    }

    public SpaceVirtualFilesManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sessionId = String.valueOf(System.currentTimeMillis());
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap<String, SpaceChatFile>()");
        this.chatFiles = map2;
        Map map3 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createWeakValueMap<Space\u2026fFileId, SpaceDiffFile>()");
        this.diffFiles = map3;
    }
}

