/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.chat.ui.header;

import circlet.code.api.CodeReviewState;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.space.chat.model.impl.SpaceChatReviewHeaderDetails;
import com.intellij.space.chat.ui.SpaceChatAvatarType;
import com.intellij.space.chat.ui.SpaceChatContentPanelKt;
import com.intellij.space.chat.ui.header.SpaceChatReviewHeaderComponent$WhenMappings;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.vcs.review.HtmlEditorPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import icons.CollaborationToolsIcons;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/space/chat/ui/header/SpaceChatReviewHeaderComponent;", "Ljavax/swing/JPanel;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "details", "Lcom/intellij/space/chat/model/impl/SpaceChatReviewHeaderDetails;", "(Llibraries/coroutines/extra/Lifetime;Lcom/intellij/space/chat/model/impl/SpaceChatReviewHeaderDetails;)V", "stateIconSize", "", "getStateIconSize", "()I", "getHeaderHtml", "", "title", "reviewKey", "getReviewStateIcon", "Ljavax/swing/JComponent;", "state", "Lcirclet/code/api/CodeReviewState;", "Companion", "intellij.space"})
public final class SpaceChatReviewHeaderComponent
extends JPanel {
    private static final double STATE_ICON_FACTOR = 0.6666666666666666;
    private static final double STATE_ICON_GAP_FACTOR = 0.5;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final int getStateIconSize() {
        return (int)((double)SpaceChatAvatarType.MAIN_CHAT.getSize().get() * 0.6666666666666666);
    }

    private final JComponent getReviewStateIcon(CodeReviewState state2) {
        Icon icon;
        switch (SpaceChatReviewHeaderComponent$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
            case 1: {
                icon = CollaborationToolsIcons.PullRequestOpen;
                break;
            }
            case 2: 
            case 3: {
                icon = CollaborationToolsIcons.PullRequestClosed;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"when (state) {\n      Cod\u2026s.PullRequestClosed\n    }");
        Icon icon2 = icon;
        return new JLabel(UtilitiesKt.resizeIcon(icon2, this.getStateIconSize()));
    }

    @Nls
    private final String getHeaderHtml(@Nls String title2, @NlsSafe String reviewKey) {
        HtmlBuilder builder = new HtmlBuilder().append(title2);
        if (reviewKey != null) {
            builder.nbsp().appendRaw(SpaceChatContentPanelKt.getGrayTextHtml(reviewKey));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public SpaceChatReviewHeaderComponent(@NotNull Lifetime lifetime, final @NotNull SpaceChatReviewHeaderDetails details) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.setOpaque(false);
        MigLayout migLayout = new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill());
        boolean bl = false;
        boolean bl2 = false;
        MigLayout migLayout2 = migLayout;
        SpaceChatReviewHeaderComponent spaceChatReviewHeaderComponent = this;
        boolean bl3 = false;
        $this$apply.setColumnConstraints((Object)"[][]");
        Unit unit = Unit.INSTANCE;
        spaceChatReviewHeaderComponent.setLayout((LayoutManager)migLayout);
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        bl2 = false;
        boolean bl4 = false;
        BorderLayoutPanel $this$apply2 = borderLayoutPanel;
        boolean bl5 = false;
        $this$apply2.setOpaque(false);
        $this$apply2.setBorder((Border)JBUI.Borders.emptyRight((int)((int)((double)this.getStateIconSize() * 0.5))));
        final BorderLayoutPanel reviewStateIconPanel = borderLayoutPanel;
        HtmlEditorPane htmlEditorPane = new HtmlEditorPane();
        bl4 = false;
        boolean bl6 = false;
        HtmlEditorPane $this$apply3 = htmlEditorPane;
        boolean bl7 = false;
        Font font = $this$apply3.getFont();
        Font font2 = $this$apply3.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font");
        $this$apply3.setFont(font.deriveFont((float)((double)font2.getSize() * 1.5)));
        final HtmlEditorPane headerContent = htmlEditorPane;
        this.add((Component)reviewStateIconPanel, new CC().pushY());
        this.add((Component)((Object)headerContent), new CC().pushX().alignY("center"));
        details.getTitle().forEach(lifetime, (Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String newTitle) {
                Intrinsics.checkNotNullParameter((Object)newTitle, (String)"newTitle");
                headerContent.setBody(this.getHeaderHtml(newTitle, details.getReviewKey()));
            }
        });
        details.getState().forEach(lifetime, (Function1)new Function1<CodeReviewState, Unit>(){

            public final void invoke(@NotNull CodeReviewState newState) {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                Component[] componentArray = reviewStateIconPanel.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"reviewStateIconPanel.components");
                Component[] componentArray2 = componentArray;
                boolean bl = false;
                Component[] componentArray3 = componentArray2;
                boolean bl2 = false;
                if (!(componentArray3.length == 0)) {
                    reviewStateIconPanel.remove(0);
                }
                reviewStateIconPanel.add((Component)this.getReviewStateIcon(newState), 0);
                reviewStateIconPanel.revalidate();
                reviewStateIconPanel.repaint();
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/space/chat/ui/header/SpaceChatReviewHeaderComponent$Companion;", "", "()V", "STATE_ICON_FACTOR", "", "STATE_ICON_GAP_FACTOR", "intellij.space"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

