/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.auth;

import circlet.platform.api.oauth.OAuthTokenResponse;
import com.intellij.space.auth.AuthPageKt;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.runtime.SpaceDispatchersKt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CoroutineScope;
import libraries.coroutines.extra.CoroutineBuildersCommonKt;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.RestService;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/space/auth/SpaceOAuthCallbackHandler;", "Lorg/jetbrains/ide/RestService;", "()V", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "Companion", "intellij.space"})
public final class SpaceOAuthCallbackHandler
extends RestService {
    private static final String NAME = "space/oauth";
    @NotNull
    private static final Url redirectURL;
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected String getServiceName() {
        return NAME;
    }

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context2) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        CompletableDeferred<OAuthTokenResponse> currentRequest = SpaceWorkspaceComponent.Companion.getInstance().getLoginRequest();
        if (currentRequest == null || currentRequest.getLifetime().isTerminated()) {
            CompletableDeferred<OAuthTokenResponse> completableDeferred = currentRequest;
            if (completableDeferred != null && (completableDeferred = completableDeferred.getRedirectResult()) != null) {
                String string = currentRequest.getServer();
                String string2 = SpaceBundle.message("auth.error.request.canceled", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceBundle.message(\"auth.error.request.canceled\")");
                completableDeferred.complete((Object)new OAuthTokenResponse.Error(string, "", string2, null, 8, null));
            }
            return null;
        }
        CoroutineBuildersCommonKt.launch$default((Lifetime)currentRequest.getLifetime(), (CoroutineContext)SpaceDispatchersKt.getSpaceIODispatcher(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentRequest, urlDecoder, context2, request, null){
            int label;
            final /* synthetic */ SpaceWorkspaceComponent.LoginRequest $currentRequest;
            final /* synthetic */ QueryStringDecoder $urlDecoder;
            final /* synthetic */ ChannelHandlerContext $context;
            final /* synthetic */ FullHttpRequest $request;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.$currentRequest.getCodeFlowConfig();
                        v1 = this.$urlDecoder.uri();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"urlDecoder.uri()");
                        this.label = 1;
                        v2 = v0.handleCodeFlowRedirect(v1, (Continuation)this);
                        ** if (v2 != var6_2) goto lbl14
lbl13:
                        // 1 sources

                        return var6_2;
lbl14:
                        // 1 sources

                        ** GOTO lbl20
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl20:
                            // 2 sources

                            var3_3 = (OAuthTokenResponse)v2;
                        }
                        catch (Exception e) {
                            v3 = this.$currentRequest.getServer();
                            v4 = SpaceBundle.message("auth.error.unknown.label", new Object[]{e.getMessage()});
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"SpaceBundle.message(\"aut\u2026nknown.label\", e.message)");
                            var3_3 = (OAuthTokenResponse)new OAuthTokenResponse.Error(v3, "", v4, null, 8, null);
                        }
                        oAuthResponse = var3_3;
                        this.$currentRequest.getRedirectResult().complete((Object)oAuthResponse);
                        var3_3 = AuthPageKt.createAuthPage(this.$currentRequest.getServer());
                        var4_5 = Charsets.UTF_8;
                        var5_7 = false;
                        v5 = var3_3;
                        if (v5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        v6 = v5.getBytes(var4_5);
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"(this as java.lang.String).getBytes(charset)");
                        v7 = (HttpResponse)Responses.response((String)"text/html", (ByteBuf)Unpooled.wrappedBuffer((byte[])v6));
                        v8 = this.$context.channel();
                        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"context.channel()");
                        Responses.send$default((HttpResponse)v7, (Channel)v8, (HttpRequest)((HttpRequest)this.$request), null, (int)4, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$currentRequest = loginRequest;
                this.$urlDecoder = queryStringDecoder;
                this.$context = channelHandlerContext;
                this.$request = fullHttpRequest;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)12, null);
        return null;
    }

    static {
        Companion = new Companion(null);
        redirectURL = Urls.newFromEncoded((String)("http://localhost:" + SpaceOAuthCallbackHandler.Companion.getPort() + "/api/space/oauth/authorization_code"));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/space/auth/SpaceOAuthCallbackHandler$Companion;", "", "()V", "NAME", "", "port", "", "getPort", "()I", "redirectURL", "Lcom/intellij/util/Url;", "getRedirectURL", "()Lcom/intellij/util/Url;", "intellij.space"})
    public static final class Companion {
        private final int getPort() {
            return BuiltInServerManager.Companion.getInstance().getPort();
        }

        @NotNull
        public final Url getRedirectURL() {
            return redirectURL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

