/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.actions;

import circlet.client.api.ProjectKey;
import circlet.client.api.TD_MemberProfile;
import circlet.client.api.TeamDirectoryKt;
import circlet.platform.client.ConnectionStatus;
import circlet.workspaces.Workspace;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.space.actions.SpaceLoginPromoPanelKt;
import com.intellij.space.actions.SpaceMainToolBarAction;
import com.intellij.space.components.SpaceUserAvatarProvider;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.settings.SpaceLoginState;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.settings.SpaceSettingsPanel;
import com.intellij.space.stats.SpaceStatsCounterCollector;
import com.intellij.space.ui.LoginComponents;
import com.intellij.space.ui.SpaceAvatars;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.utils.SpaceUrls;
import com.intellij.space.vcs.Context;
import com.intellij.space.vcs.SpaceProjectContext;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.clone.SpaceCloneAction;
import com.intellij.space.vcs.review.SpaceShowReviewsAction;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.cloneDialog.AccountMenuItem;
import com.intellij.util.ui.cloneDialog.AccountMenuPopupStep;
import com.intellij.util.ui.cloneDialog.AccountsMenuListPopup;
import com.intellij.util.ui.cloneDialog.VcsCloneDialogPopupMenuKt;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.Source;
import runtime.reactive.SourceKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/space/actions/SpaceMainToolBarAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "()V", "settings", "Lcom/intellij/space/settings/SpaceSettings;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "buildMenu", "Lcom/intellij/util/ui/cloneDialog/AccountsMenuListPopup;", "workspace", "Lcirclet/workspaces/Workspace;", "icon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "createView", "Ljavax/swing/JComponent;", "st", "Lcom/intellij/space/settings/SpaceLoginState;", "component", "Ljava/awt/Component;", "packPopup", "Lkotlin/Function0;", "update", "intellij.space"})
public final class SpaceMainToolBarAction
extends DumbAwareAction
implements RightAlignedToolbarAction {
    private final SpaceSettings settings = SpaceSettings.Companion.getInstance();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean isOnNavBar = Intrinsics.areEqual((Object)e.getPlace(), (Object)"NavBarToolbar");
        boolean isOnMainBar = Intrinsics.areEqual((Object)e.getPlace(), (Object)"MainToolbar");
        if (!isOnNavBar && !isOnMainBar) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(true);
        SpaceWorkspaceComponent space = SpaceWorkspaceComponent.Companion.getInstance();
        SpaceAvatars avatars2 = (SpaceAvatars)SpaceUserAvatarProvider.Companion.getInstance().getAvatars().getValue();
        Workspace workspace2 = (Workspace)space.getWorkspace().getValue();
        boolean isOnline = (workspace2 != null && (workspace2 = workspace2.getClient()) != null && (workspace2 = workspace2.getConnectionStatus()) != null ? (ConnectionStatus)workspace2.getValue() : null) instanceof ConnectionStatus.Connected;
        boolean isConnecting = space.getLoginState().getValue() instanceof SpaceLoginState.Connecting;
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
        presentation2.setIcon(isOnline ? avatars2.getOnline() : (isConnecting ? (Icon)AnimatedIcon.Default.INSTANCE : avatars2.getOffline()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        Intrinsics.checkNotNullExpressionValue((Object)inputEvent, (String)"e.inputEvent");
        Component component2 = inputEvent.getComponent();
        SpaceWorkspaceComponent space = SpaceWorkspaceComponent.Companion.getInstance();
        Workspace workspace2 = (Workspace)space.getWorkspace().getValue();
        SpaceStatsCounterCollector.OPEN_MAIN_TOOLBAR_POPUP.log((Object)SpaceStatsCounterCollector.LoginState.Companion.convert((SpaceLoginState)space.getLoginState().getValue()));
        if (workspace2 != null) {
            Icon icon = ((SpaceAvatars)SpaceUserAvatarProvider.Companion.getInstance().getAvatars().getValue()).getCircle();
            Project project = e.getProject();
            Intrinsics.checkNotNull((Object)project);
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project!!");
            AccountsMenuListPopup accountsMenuListPopup = this.buildMenu(workspace2, icon, project);
            Component component3 = component2;
            Intrinsics.checkNotNullExpressionValue((Object)component3, (String)"component");
            accountsMenuListPopup.showUnderneathOf(component3);
        } else {
            Wrapper wrapper = new Wrapper();
            JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)wrapper, (JComponent)wrapper).setRequestFocus(true).setFocusable(true).setBorderColor(JBColor.border()).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"JBPopupFactory.getInstan\u2026))\n        .createPopup()");
            JBPopup popup = jBPopup;
            SourceKt.view((Source)((Source)space.getLoginState()), (Lifetime)space.getLifetime(), (Function2)((Function2)new Function2<Lifetime, SpaceLoginState, Unit>(this, component2, popup, wrapper){
                final /* synthetic */ SpaceMainToolBarAction this$0;
                final /* synthetic */ Component $component;
                final /* synthetic */ JBPopup $popup;
                final /* synthetic */ Wrapper $wrapper;

                public final void invoke(@NotNull Lifetime $noName_0, @NotNull SpaceLoginState st) {
                    Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)st, (String)"st");
                    Component component2 = this.$component;
                    Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"component");
                    JComponent view2 = SpaceMainToolBarAction.access$createView(this.this$0, st, component2, (Function0)new Function0<Unit>(this){
                        final /* synthetic */ actionPerformed.1 this$0;

                        public final void invoke() {
                            this.this$0.$popup.pack(true, true);
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                    if (view2 == null) {
                        this.$popup.cancel();
                        return;
                    }
                    this.$wrapper.setContent(view2);
                    this.$wrapper.repaint();
                    if (st instanceof SpaceLoginState.Disconnected) {
                        this.$popup.pack(true, true);
                    }
                }
                {
                    this.this$0 = spaceMainToolBarAction;
                    this.$component = component2;
                    this.$popup = jBPopup;
                    this.$wrapper = wrapper;
                    super(2);
                }
            }));
            int n = -wrapper.getPreferredSize().width;
            Component component4 = component2;
            Intrinsics.checkNotNullExpressionValue((Object)component4, (String)"component");
            popup.show(new RelativePoint(component2, new Point(n + component4.getWidth(), component2.getHeight())));
        }
    }

    private final JComponent createView(SpaceLoginState st, Component component2, Function0<Unit> packPopup) {
        JComponent jComponent;
        SpaceLoginState spaceLoginState = st;
        if (spaceLoginState instanceof SpaceLoginState.Connected) {
            jComponent = null;
        } else if (spaceLoginState instanceof SpaceLoginState.Connecting) {
            jComponent = (JComponent)LoginComponents.INSTANCE.buildConnectingPanel$intellij_space((SpaceLoginState.Connecting)st, SpaceStatsCounterCollector.LoginPlace.MAIN_TOOLBAR, (Border)SpaceLoginPromoPanelKt.prettyBorder(), (Function0<Unit>)((Function0)new Function0<Unit>(st){
                final /* synthetic */ SpaceLoginState $st;

                public final void invoke() {
                    ((SpaceLoginState.Connecting)this.$st).cancel();
                }
                {
                    this.$st = spaceLoginState;
                    super(0);
                }
            }));
        } else if (spaceLoginState instanceof SpaceLoginState.Disconnected) {
            jComponent = SpaceLoginPromoPanelKt.buildLoginPanelWithPromo((SpaceLoginState.Disconnected)st, SpaceStatsCounterCollector.ExplorePlace.MAIN_TOOLBAR, SpaceStatsCounterCollector.LoginPlace.MAIN_TOOLBAR, packPopup, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(component2){
                final /* synthetic */ Component $component;

                public final void invoke(@NotNull String serverName) {
                    Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
                    SpaceWorkspaceComponent space = SpaceWorkspaceComponent.Companion.getInstance();
                    space.signInManually(serverName, space.getLifetime(), this.$component);
                }
                {
                    this.$component = component2;
                    super(1);
                }
            }));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return jComponent;
    }

    private final AccountsMenuListPopup buildMenu(Workspace workspace2, Icon icon, Project project) {
        Collection collection;
        String host = this.settings.getServerSettings().getServer();
        String serverUrl = UtilitiesKt.cleanupUrl(host);
        boolean bl = false;
        List menuItems = new ArrayList();
        Collection collection2 = menuItems;
        String string = TeamDirectoryKt.englishFullName((TD_MemberProfile)((TD_MemberProfile)workspace2.getMe().getValue()));
        Icon icon2 = UtilitiesKt.resizeIcon(icon, 40);
        String string2 = SpaceBundle.message("main.toolbar.open.server", serverUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SpaceBundle.message(\"mai\u2026.open.server\", serverUrl)");
        AccountMenuItem.Account account = new AccountMenuItem.Account(string, serverUrl, icon2, CollectionsKt.listOf((Object)VcsCloneDialogPopupMenuKt.browseAction((String)string2, (String)host, (boolean)true)), false, 16, null);
        boolean bl2 = false;
        collection2.add(account);
        collection2 = menuItems;
        String string3 = SpaceBundle.message("action.com.intellij.space.vcs.clone.SpaceCloneAction.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SpaceBundle.message(\"act\u2026e.SpaceCloneAction.text\")");
        account = new AccountMenuItem.Action(string3, (Function0)new Function0<Unit>(project){
            final /* synthetic */ Project $project;

            public final void invoke() {
                SpaceCloneAction.Companion.runClone(this.$project);
            }
            {
                this.$project = project;
                super(0);
            }
        }, null, true, 4, null);
        bl2 = false;
        collection2.add(account);
        SpaceProjectContext projectContext = SpaceProjectContext.Companion.getInstance(project);
        Context context2 = projectContext.getCurrentContext();
        if (context2.isAssociatedWithSpaceRepository()) {
            Set<SpaceProjectInfo> descriptions = context2.getReposInProject().keySet();
            collection = menuItems;
            String string4 = SpaceBundle.message("action.show.code.reviews.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"SpaceBundle.message(\"act\u2026.show.code.reviews.text\")");
            Object object = new AccountMenuItem.Action(string4, (Function0)new Function0<Unit>(project){
                final /* synthetic */ Project $project;

                public final void invoke() {
                    SpaceShowReviewsAction.Companion.showCodeReviews$intellij_space(this.$project);
                }
                {
                    this.$project = project;
                    super(0);
                }
            }, null, false, 12, null);
            boolean bl3 = false;
            collection.add(object);
            if (descriptions.size() > 1) {
                AccountMenuItem.Action action;
                SpaceProjectInfo it;
                Collection<AccountMenuItem.Action> collection3;
                Object item$iv$iv;
                Object $this$mapTo$iv$iv;
                Object $this$map$iv;
                collection = menuItems;
                String string5 = SpaceBundle.message("open.in.browser.group.checklists", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"SpaceBundle.message(\"ope\u2026rowser.group.checklists\")");
                object = descriptions;
                String string6 = string5;
                boolean $i$f$map = false;
                void var13_21 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    SpaceProjectInfo spaceProjectInfo = (SpaceProjectInfo)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl4 = false;
                    String checklistsUrl = SpaceUrls.INSTANCE.checklists(it.getKey());
                    String string7 = SpaceBundle.message("open.in.browser.open.for.project.action", it.getProject().getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"SpaceBundle.message(\"ope\u2026action\", it.project.name)");
                    action = VcsCloneDialogPopupMenuKt.browseAction$default((String)string7, (String)checklistsUrl, (boolean)false, (int)4, null);
                    collection3.add(action);
                }
                collection3 = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 4;
                boolean bl5 = false;
                List list = CollectionsKt.toList((Iterable)collection3);
                String string8 = string6;
                $this$map$iv = new AccountMenuItem.Group(string8, list, bl5, n, defaultConstructorMarker);
                $i$f$map = false;
                collection.add($this$map$iv);
                collection = menuItems;
                String string9 = SpaceBundle.message("open.in.browser.group.issues", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"SpaceBundle.message(\"ope\u2026in.browser.group.issues\")");
                $this$map$iv = descriptions;
                string6 = string9;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    item$iv$iv = iterator.next();
                    it = (SpaceProjectInfo)item$iv$iv;
                    collection3 = destination$iv$iv;
                    boolean bl6 = false;
                    String issuesUrl = SpaceUrls.INSTANCE.issues(it.getKey());
                    String string10 = SpaceBundle.message("open.in.browser.open.for.project.action", it.getProject().getName());
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"SpaceBundle.message(\"ope\u2026action\", it.project.name)");
                    action = VcsCloneDialogPopupMenuKt.browseAction$default((String)string10, (String)issuesUrl, (boolean)false, (int)4, null);
                    collection3.add(action);
                }
                collection3 = (List)destination$iv$iv;
                DefaultConstructorMarker defaultConstructorMarker2 = null;
                int n2 = 4;
                boolean bl7 = false;
                List list2 = CollectionsKt.toList((Iterable)collection3);
                String string11 = string6;
                object = new AccountMenuItem.Group(string11, list2, bl7, n2, defaultConstructorMarker2);
                bl3 = false;
                collection.add(object);
            } else {
                collection = descriptions;
                boolean bl8 = false;
                if (!collection.isEmpty()) {
                    ProjectKey projectKey = ((SpaceProjectInfo)CollectionsKt.first((Iterable)descriptions)).getKey();
                    Collection collection4 = menuItems;
                    String string12 = SpaceBundle.message("main.toolbar.checklists.action", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"SpaceBundle.message(\"mai\u2026olbar.checklists.action\")");
                    AccountMenuItem.Action action = VcsCloneDialogPopupMenuKt.browseAction$default((String)string12, (String)SpaceUrls.INSTANCE.checklists(projectKey), (boolean)false, (int)4, null);
                    boolean bl9 = false;
                    collection4.add(action);
                    collection4 = menuItems;
                    String string13 = SpaceBundle.message("main.toolbar.issues.action", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"SpaceBundle.message(\"main.toolbar.issues.action\")");
                    action = VcsCloneDialogPopupMenuKt.browseAction$default((String)string13, (String)SpaceUrls.INSTANCE.issues(projectKey), (boolean)false, (int)4, null);
                    bl9 = false;
                    collection4.add(action);
                }
            }
        }
        Collection collection5 = menuItems;
        String string14 = SpaceBundle.message("main.toolbar.settings.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"SpaceBundle.message(\"mai\u2026toolbar.settings.action\")");
        collection = new AccountMenuItem.Action(string14, (Function0)new Function0<Unit>(project){
            final /* synthetic */ Project $project;

            public final void invoke() {
                SpaceSettingsPanel.Companion.openSettings(this.$project);
            }
            {
                this.$project = project;
                super(0);
            }
        }, null, true, 4, null);
        boolean bl10 = false;
        collection5.add(collection);
        collection5 = menuItems;
        String string15 = SpaceBundle.message("main.toolbar.log.out.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"SpaceBundle.message(\"main.toolbar.log.out.action\")");
        collection = new AccountMenuItem.Action(string15, (Function0)buildMenu.6.INSTANCE, null, false, 12, null);
        bl10 = false;
        collection5.add(collection);
        return new AccountsMenuListPopup(project, new AccountMenuPopupStep(menuItems), null, null, 12, null);
    }

    public static final /* synthetic */ JComponent access$createView(SpaceMainToolBarAction $this, SpaceLoginState st, Component component2, Function0 packPopup) {
        return $this.createView(st, component2, (Function0<Unit>)packPopup);
    }
}

