/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.JsonConf;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoder$WhenMappings;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.StringOpsKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002FGB3\b\u0010\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0002\u0010\fB/\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0013H\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010.\u001a\u00020!2\u0006\u0010\"\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u001fH\u0016J\u0010\u00103\u001a\u00020!2\u0006\u0010\"\u001a\u00020+H\u0016J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020!2\u0006\u0010\"\u001a\u000208H\u0016J\b\u00109\u001a\u00020!H\u0016J)\u0010:\u001a\u00020!\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=2\u0006\u0010\"\u001a\u0002H;H\u0016\u00a2\u0006\u0002\u0010>J\u0010\u0010?\u001a\u00020!2\u0006\u0010\"\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020!2\u0006\u0010\"\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010D\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010E\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder;", "Lkotlinx/serialization/json/JsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "modeReuseCache", "", "(Ljava/lang/StringBuilder;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "composer", "Lkotlinx/serialization/json/internal/StreamingJsonEncoder$Composer;", "(Lkotlinx/serialization/json/internal/StreamingJsonEncoder$Composer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "configuration", "Lkotlinx/serialization/json/internal/JsonConf;", "forceQuoting", "", "getJson", "()Lkotlinx/serialization/json/Json;", "[Lkotlinx/serialization/json/JsonEncoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "writePolymorphic", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeBoolean", "", "value", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescriptor", "encodeFloat", "", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "inlineDescriptor", "encodeInt", "encodeJsonElement", "element", "Lkotlinx/serialization/json/JsonElement;", "encodeLong", "", "encodeNull", "encodeSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeShort", "", "encodeString", "", "encodeTypeInfo", "endStructure", "shouldEncodeElementDefault", "Composer", "ComposerForUnsignedNumbers", "kotlinx-serialization-json"})
public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    @NotNull
    private final SerializersModule serializersModule;
    private final JsonConf configuration;
    private boolean forceQuoting;
    private boolean writePolymorphic;
    private final Composer composer;
    @NotNull
    private final Json json;
    private final WriteMode mode;
    private final JsonEncoder[] modeReuseCache;

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public void encodeJsonElement(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.encodeSerializableValue((SerializationStrategy)JsonElementSerializer.INSTANCE, element);
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.configuration.encodeDefaults;
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        StreamingJsonEncoder $this$encodePolymorphically$iv = this;
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically$iv.getJson().getConfiguration$kotlinx_serialization_json().useArrayPolymorphism) {
            serializer.serialize((Encoder)$this$encodePolymorphically$iv, value);
        } else {
            T t = value;
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
            }
            SerializationStrategy actualSerializer$iv = PolymorphicKt.access$findActualSerializer($this$encodePolymorphically$iv, serializer, t);
            boolean bl = false;
            this.writePolymorphic = true;
            actualSerializer$iv.serialize((Encoder)$this$encodePolymorphically$iv, value);
        }
    }

    private final void encodeTypeInfo(SerialDescriptor descriptor2) {
        this.composer.nextItem();
        this.encodeString(this.configuration.classDiscriminator);
        this.composer.print(':');
        this.composer.space();
        this.encodeString(descriptor2.getSerialName());
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.getJson(), descriptor2);
        if (newMode.begin != '\u0000') {
            this.composer.print(newMode.begin);
            this.composer.indent();
        }
        if (this.writePolymorphic) {
            this.writePolymorphic = false;
            this.encodeTypeInfo(descriptor2);
        }
        if (this.mode == newMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        return this.modeReuseCache != null && (object = object[newMode.ordinal()]) != null ? (CompositeEncoder)object : (CompositeEncoder)new StreamingJsonEncoder(this.composer, this.getJson(), newMode, this.modeReuseCache);
    }

    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItem();
            this.composer.print(this.mode.end);
        }
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        switch (StreamingJsonEncoder$WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl;
                    if (index % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (index == 0) {
                    this.forceQuoting = true;
                }
                if (index != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(descriptor2.getElementName(index));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor inlineDescriptor) {
        Intrinsics.checkNotNullParameter((Object)inlineDescriptor, (String)"inlineDescriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(inlineDescriptor) ? (Encoder)new StreamingJsonEncoder(new ComposerForUnsignedNumbers(this.composer.sb, this.composer.json), this.getJson(), this.mode, null) : (Encoder)this;
    }

    public void encodeNull() {
        this.composer.print("null");
    }

    public void encodeBoolean(boolean value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    public void encodeByte(byte value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    public void encodeShort(short value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    public void encodeInt(int value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    public void encodeLong(long value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeFloat(float value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
        if (this.configuration.allowSpecialFloatingPointValues) return;
        float f = value;
        boolean bl = false;
        float f2 = f;
        boolean bl2 = false;
        if (!Float.isInfinite(f2)) {
            f2 = f;
            bl2 = false;
            if (!Float.isNaN(f2)) {
                return;
            }
        }
        boolean bl3 = false;
        if (bl3) return;
        Number number = Float.valueOf(value);
        String string = this.composer.sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"composer.sb.toString()");
        throw (Throwable)((Object)JsonExceptionsKt.InvalidFloatingPointEncoded(number, string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encodeDouble(double value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
        if (this.configuration.allowSpecialFloatingPointValues) return;
        double d = value;
        boolean bl = false;
        double d2 = d;
        boolean bl2 = false;
        if (!Double.isInfinite(d2)) {
            d2 = d;
            bl2 = false;
            if (!Double.isNaN(d2)) {
                return;
            }
        }
        boolean bl3 = false;
        if (bl3) return;
        Number number = value;
        String string = this.composer.sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"composer.sb.toString()");
        throw (Throwable)((Object)JsonExceptionsKt.InvalidFloatingPointEncoded(number, string));
    }

    public void encodeChar(char value) {
        this.encodeString(String.valueOf(value));
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.composer.printQuoted(value);
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encodeString(enumDescriptor.getElementName(index));
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonEncoder(@NotNull Composer composer, @NotNull Json json, @NotNull WriteMode mode, @Nullable JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.composer = composer;
        this.json = json;
        this.mode = mode;
        this.modeReuseCache = modeReuseCache;
        this.serializersModule = this.getJson().getSerializersModule();
        this.configuration = this.getJson().getConfiguration$kotlinx_serialization_json();
        int i = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this)) {
            this.modeReuseCache[i] = this;
        }
    }

    public StreamingJsonEncoder(@NotNull StringBuilder output, @NotNull Json json, @NotNull WriteMode mode, @NotNull JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)modeReuseCache, (String)"modeReuseCache");
        this(new Composer(output, json), json, mode, modeReuseCache);
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor2, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return JsonEncoder.DefaultImpls.beginCollection(this, descriptor2, collectionSize);
    }

    @ExperimentalSerializationApi
    public void encodeNotNullMark() {
        JsonEncoder.DefaultImpls.encodeNotNullMark(this);
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        JsonEncoder.DefaultImpls.encodeNullableSerializableValue(this, serializer, value);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\u0010\f\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\u0010\n\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0016H\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0018H\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u0019H\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0018\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0014\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\u0006\u0010\u001e\u001a\u00020\u0010J\u0006\u0010\u001f\u001a\u00020\u0010R\u0010\u0010\u0005\u001a\u00020\u00068\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00060\u0003j\u0002`\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder$Composer;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "json", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/StringBuilder;Lkotlinx/serialization/json/Json;)V", "level", "", "<set-?>", "", "writingFirst", "getWritingFirst", "()Z", "indent", "", "nextItem", "print", "kotlin.jvm.PlatformType", "v", "", "", "", "", "", "", "", "printQuoted", "value", "space", "unIndent", "kotlinx-serialization-json"})
    public static class Composer {
        private int level;
        private boolean writingFirst;
        @JvmField
        @NotNull
        public final StringBuilder sb;
        @JvmField
        @NotNull
        public final Json json;

        public final boolean getWritingFirst() {
            return this.writingFirst;
        }

        public final void indent() {
            this.writingFirst = true;
            int n = this.level;
            this.level = n + 1;
        }

        public final void unIndent() {
            int n = this.level;
            this.level = n + -1;
        }

        public final void nextItem() {
            this.writingFirst = false;
            if (this.json.getConfiguration$kotlinx_serialization_json().prettyPrint) {
                this.print("\n");
                int n = this.level;
                boolean bl = false;
                int n2 = 0;
                n2 = 0;
                int n3 = n;
                while (n2 < n3) {
                    int it = n2++;
                    boolean bl2 = false;
                    this.print(this.json.getConfiguration$kotlinx_serialization_json().prettyPrintIndent);
                }
            }
        }

        public final void space() {
            if (this.json.getConfiguration$kotlinx_serialization_json().prettyPrint) {
                this.print(' ');
            }
        }

        public StringBuilder print(char v) {
            return this.sb.append(v);
        }

        public StringBuilder print(@NotNull String v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            return this.sb.append(v);
        }

        public StringBuilder print(float v) {
            return this.sb.append(v);
        }

        public StringBuilder print(double v) {
            return this.sb.append(v);
        }

        public StringBuilder print(byte v) {
            return this.sb.append((Object)v);
        }

        public StringBuilder print(short v) {
            return this.sb.append((Object)v);
        }

        public StringBuilder print(int v) {
            return this.sb.append(v);
        }

        public StringBuilder print(long v) {
            return this.sb.append(v);
        }

        public StringBuilder print(boolean v) {
            return this.sb.append(v);
        }

        public void printQuoted(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StringOpsKt.printQuoted(this.sb, value);
        }

        public Composer(@NotNull StringBuilder sb, @NotNull Json json) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            this.sb = sb;
            this.json = json;
            this.writingFirst = true;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0010\n\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\b\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\b\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0014\u0010\b\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\t\u001a\u00020\fH\u0016J\u0014\u0010\b\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\t\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder$ComposerForUnsignedNumbers;", "Lkotlinx/serialization/json/internal/StreamingJsonEncoder$Composer;", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "json", "Lkotlinx/serialization/json/Json;", "(Ljava/lang/StringBuilder;Lkotlinx/serialization/json/Json;)V", "print", "v", "", "", "", "", "kotlinx-serialization-json"})
    @ExperimentalUnsignedTypes
    public static final class ComposerForUnsignedNumbers
    extends Composer {
        @Override
        @NotNull
        public StringBuilder print(int v) {
            int n = v;
            boolean bl = false;
            StringBuilder stringBuilder = super.print(UInt.toString-impl((int)UInt.constructor-impl((int)n)));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"super.print(v.toUInt().toString())");
            return stringBuilder;
        }

        @Override
        @NotNull
        public StringBuilder print(long v) {
            long l = v;
            boolean bl = false;
            StringBuilder stringBuilder = super.print(ULong.toString-impl((long)ULong.constructor-impl((long)l)));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"super.print(v.toULong().toString())");
            return stringBuilder;
        }

        @Override
        @NotNull
        public StringBuilder print(byte v) {
            byte by = v;
            boolean bl = false;
            StringBuilder stringBuilder = super.print(UByte.toString-impl((byte)UByte.constructor-impl((byte)by)));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"super.print(v.toUByte().toString())");
            return stringBuilder;
        }

        @Override
        @NotNull
        public StringBuilder print(short v) {
            short s = v;
            boolean bl = false;
            StringBuilder stringBuilder = super.print(UShort.toString-impl((short)UShort.constructor-impl((short)s)));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"super.print(v.toUShort().toString())");
            return stringBuilder;
        }

        public ComposerForUnsignedNumbers(@NotNull StringBuilder sb, @NotNull Json json) {
            Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            super(sb, json);
        }
    }
}

